/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.util.Arrays;
import java.util.Collection;
import org.ujmp.core.Matrix;

public abstract class VerifyUtil {
    public static final void verifyTrue(boolean test, String message, Object ... messageArgs) {
        if (!test) {
            String text = messageArgs.length == 0 ? message : String.format(message, messageArgs);
            throw new IllegalArgumentException(text);
        }
    }

    public static final void verifyFalse(boolean test, String message, Object ... messageArgs) {
        if (!test) {
            String text = messageArgs.length == 0 ? message : String.format(message, messageArgs);
            throw new IllegalArgumentException(text);
        }
    }

    public static final void verifyTrue(boolean test, String message) {
        if (!test) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final void verifyFalse(boolean test, String message) {
        if (test) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final void verifySameSize(Matrix m1, Matrix m2) {
        VerifyUtil.verifyTrue(Arrays.equals(m1.getSize(), m2.getSize()), "matrices have different sizes");
    }

    public static final void verifySameSize(Matrix ... matrices) {
        VerifyUtil.verifyTrue(matrices.length > 1, "more than one matrix must be provided");
        int i = matrices.length;
        while (--i != 0) {
            VerifyUtil.verifyTrue(Arrays.equals(matrices[i].getSize(), matrices[i - 1].getSize()), "matrices have different sizes");
        }
    }

    public static final void verifySameSize(double[][] source1, double[][] source2, double[][] target) {
        VerifyUtil.verifyNotNull(source1, "matrix1 cannot be null");
        VerifyUtil.verifyNotNull(source2, "matrix2 cannot be null");
        VerifyUtil.verifyNotNull(target, "matrix3 cannot be null");
        VerifyUtil.verifyNotNull(source1[0], "matrix1 must be 2d");
        VerifyUtil.verifyNotNull(source2[0], "matrix2 must be 2d");
        VerifyUtil.verifyNotNull(target[0], "matrix3 must be 2d");
        VerifyUtil.verifyEquals(source1.length, source2.length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.verifyEquals(source2.length, target.length, "matrix1 and matrix3 have different sizes");
        VerifyUtil.verifyEquals(source1[0].length, source2[0].length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.verifyEquals(source2[0].length, target[0].length, "matrix1 and matrix3 have different sizes");
    }

    public static final void verifyEquals(int i1, int i2, String message) {
        VerifyUtil.verifyTrue(i1 == i2, message);
    }

    public static final void verifyEquals(double d1, double d2, double tol, String message) {
        VerifyUtil.verifyTrue(Math.abs(d1 - d2) < tol, message);
    }

    public static final void verifyEquals(float d1, float d2, float tol, String message) {
        VerifyUtil.verifyTrue(Math.abs(d1 - d2) < tol, message);
    }

    public static final void verifyEquals(long[] s1, long[] s2, String message) {
        VerifyUtil.verifyTrue(Arrays.equals(s1, s2), message);
    }

    public static final void verifyEquals(int[] s1, int[] s2, String message) {
        VerifyUtil.verifyTrue(Arrays.equals(s1, s2), message);
    }

    public static final void verifyEquals(double[] s1, double[] s2, String message) {
        VerifyUtil.verifyTrue(Arrays.equals(s1, s2), message);
    }

    public static final void verifyEquals(float[] s1, float[] s2, String message) {
        VerifyUtil.verifyTrue(Arrays.equals(s1, s2), message);
    }

    public static final void verifyNotNull(Matrix m) {
        VerifyUtil.verifyNotNull(m, "matrix is null");
    }

    public static final void verifyNotNull(Object o, String message) {
        VerifyUtil.verifyFalse(o == null, message);
    }

    public static final void verifyNull(Object o, String message) {
        VerifyUtil.verifyTrue(o == null, message);
    }

    public static final void verifySameSize(double[] source1, double[] source2, double[] target) {
        VerifyUtil.verifyNotNull(source1, "matrix1 cannot be null");
        VerifyUtil.verifyNotNull(source2, "matrix2 cannot be null");
        VerifyUtil.verifyNotNull(target, "matrix3 cannot be null");
        VerifyUtil.verifyEquals(source1.length, source2.length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.verifyEquals(source2.length, target.length, "matrix1 and matrix3 have different sizes");
    }

    public static final void verifySameSize(double[][] source, double[][] target) {
        VerifyUtil.verifyNotNull(source, "matrix1 cannot be null");
        VerifyUtil.verifyNotNull(target, "matrix2 cannot be null");
        VerifyUtil.verifyNotNull(source[0], "matrix1 must be 2d");
        VerifyUtil.verifyNotNull(target[0], "matrix2 must be 2d");
        VerifyUtil.verifyEquals(source.length, target.length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.verifyEquals(source[0].length, target[0].length, "matrix1 and matrix2 have different sizes");
    }

    public static final void verifySameSize(double[] source, double[] target) {
        VerifyUtil.verifyNotNull(source, "matrix1 cannot be null");
        VerifyUtil.verifyNotNull(target, "matrix2 cannot be null");
        VerifyUtil.verifyEquals(source.length, target.length, "matrix1 and matrix2 have different sizes");
    }

    public static final void verify2D(Matrix m) {
        VerifyUtil.verifyNotNull(m, "matrix cannot be null");
        VerifyUtil.verifyEquals(m.getDimensionCount(), 2, "matrix is not 2d");
    }

    public static final void verifyEquals(long l1, long l2, String message) {
        VerifyUtil.verifyTrue(l1 == l2, message);
    }

    public static final void verify2D(long ... size) {
        VerifyUtil.verifyNotNull(size, "size cannot be null");
        VerifyUtil.verifyTrue(size.length == 2, "size must be 2d");
    }

    public static final void verifySquare(Matrix matrix) {
        VerifyUtil.verify2D(matrix);
        VerifyUtil.verifyTrue(matrix.getRowCount() == matrix.getColumnCount(), "matrix must be square");
    }

    public static final void verifySingleValue(Matrix matrix) {
        VerifyUtil.verify2D(matrix);
        VerifyUtil.verifyTrue(matrix.getRowCount() == 1L, "matrix must be 1x1");
        VerifyUtil.verifyTrue(matrix.getColumnCount() == 1L, "matrix must be 1x1");
    }

    public static final void verifyNotEmpty(Object ... objects) {
        VerifyUtil.verifyTrue(objects.length > 0, "object array must not be empty");
    }

    public static final void verifyNotEmpty(Collection<?> collection) {
        VerifyUtil.verifyNotNull(collection, "collection must not be null");
        VerifyUtil.verifyFalse(collection.isEmpty(), "collection must not be empty");
    }

    public static final void verifyNotEmpty(String ... strings) {
        VerifyUtil.verifyTrue(strings.length > 0, "string array must not be empty");
    }
}

