/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.math.MathContext;
import java.util.Locale;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

public class UJMPSettings
extends DefaultMapMatrix<String, Object> {
    private static final long serialVersionUID = -4677534766141735270L;
    private static final Object lock = new Object();
    public static final String USEBLOCKMATRIXMULTIPLY = "UseBlockMatrixMultiply";
    public static final String USEMULTITHREADEDRANDOM = "UseMultThreadedRandom";
    public static final String DEFAULTBLOCKSIZE = "DefaultBlockSize";
    public static final String MATHCONTEXT = "MathContext";
    public static final String DEFAULTTOLERANCE = "DefaultTolerance";
    public static final String NUMBEROFTHREADS = "NumberOfThreads";
    public static final String USEJBLAS = "UseJBlas";
    public static final String USEOJALGO = "UseOjalgo";
    public static final String USEEJML = "UseEJML";
    public static final String USEPARALLELCOLT = "UseParallelColt";
    public static final String USECOMMONSMATH = "UseCommonsMath";
    public static final String USEMTJ = "UseMTJ";
    public static final String MAXROWSTOPRINT = "MaxRowsToPrint";
    public static final String MAXCOLSTOPRINT = "MaxColsToPrint";
    public static final String MAXTOOLTIPROWS = "MaxTooltipRows";
    public static final String MAXTOOLTIPCOLS = "MaxTooltipCols";
    public static final String USERAGENT = "UserAgent";
    private static UJMPSettings instance = null;

    private UJMPSettings() {
        this.put(DEFAULTBLOCKSIZE, 100);
        this.put(MATHCONTEXT, MathContext.DECIMAL128);
        this.put(USEMULTITHREADEDRANDOM, true);
        this.put(USEBLOCKMATRIXMULTIPLY, false);
        this.put(DEFAULTTOLERANCE, 1.0E-12);
        this.put(USEJBLAS, true);
        this.put(USEEJML, true);
        this.put(USEOJALGO, true);
        this.put(USEPARALLELCOLT, true);
        this.put(USEMTJ, true);
        this.put(USECOMMONSMATH, true);
        this.put(MAXROWSTOPRINT, 100);
        this.put(MAXCOLSTOPRINT, 100);
        this.put(MAXTOOLTIPROWS, 10);
        this.put(MAXTOOLTIPCOLS, 10);
        this.put(USERAGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:28.0) Gecko/20100101 Firefox/28.0");
        this.put(NUMBEROFTHREADS, Runtime.getRuntime().availableProcessors());
        Locale.setDefault(Locale.US);
        System.setProperty("file.encoding", "UTF-8");
        System.setProperty("sun.jnu.encoding", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UJMPSettings getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new UJMPSettings();
                }
            }
        }
        return instance;
    }

    public MathContext getMathContext() {
        return (MathContext)this.get(MATHCONTEXT);
    }

    public void setMathContext(MathContext mc) {
        this.put(MATHCONTEXT, mc);
    }

    public int getNumberOfThreads() {
        return MathUtil.getInt(this.get(NUMBEROFTHREADS));
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.put(NUMBEROFTHREADS, numberOfThreads);
    }

    public double getTolerance() {
        return MathUtil.getDouble(this.get(DEFAULTTOLERANCE));
    }

    public void setTolerance(double tolerance) {
        this.put(DEFAULTTOLERANCE, tolerance);
    }

    public int getMaxColumnsToPrint() {
        return MathUtil.getInt(this.get(MAXCOLSTOPRINT));
    }

    public void setMaxColumnsToPrint(int maxColumnsToPrint) {
        this.put(MAXCOLSTOPRINT, maxColumnsToPrint);
    }

    public int getMaxRowsToPrint() {
        return MathUtil.getInt(this.get(MAXROWSTOPRINT));
    }

    public void setMaxRowsToPrint(int maxRowsToPrint) {
        this.put(MAXROWSTOPRINT, maxRowsToPrint);
    }

    public int getMaxToolTipCols() {
        return MathUtil.getInt(this.get(MAXTOOLTIPCOLS));
    }

    public void setMaxToolTipCols(int maxToolTipCols) {
        this.put(MAXTOOLTIPCOLS, maxToolTipCols);
    }

    public int getMaxToolTipRows() {
        return MathUtil.getInt(this.get(MAXTOOLTIPROWS));
    }

    public void setMaxToolTipRows(int maxToolTipRows) {
        this.put(MAXTOOLTIPROWS, maxToolTipRows);
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void setLocale(Locale locale) {
        Locale.setDefault(locale);
    }

    public void setUseCommonsMath(boolean useCommonsMath) {
        this.put(USECOMMONSMATH, useCommonsMath);
    }

    public boolean isUseCommonsMath() {
        return MathUtil.getBoolean(this.get(USECOMMONSMATH));
    }

    public void setUseJBlas(boolean useJBlas) {
        this.put(USEJBLAS, useJBlas);
    }

    public boolean isUseJBlas() {
        return MathUtil.getBoolean(this.get(USEJBLAS));
    }

    public void setUseOjalgo(boolean useOjalgo) {
        this.put(USEOJALGO, useOjalgo);
    }

    public boolean isUseOjalgo() {
        return MathUtil.getBoolean(this.get(USEOJALGO));
    }

    public void setUseEJML(boolean useEJML) {
        this.put(USEEJML, useEJML);
    }

    public boolean isUseEJML() {
        return MathUtil.getBoolean(this.get(USEEJML));
    }

    public void setUseParallelColt(boolean useParallelColt) {
        this.put(USEPARALLELCOLT, useParallelColt);
    }

    public boolean isUseParallelColt() {
        return MathUtil.getBoolean(this.get(USEPARALLELCOLT));
    }

    public void setUseMTJ(boolean useMTJ) {
        this.put(USEMTJ, useMTJ);
    }

    public boolean isUseMTJ() {
        return MathUtil.getBoolean(this.get(USEMTJ));
    }

    public boolean isUseBlockMatrixMultiply() {
        return MathUtil.getBoolean(this.get(USEBLOCKMATRIXMULTIPLY));
    }

    public void setUseBlockMatrixMultiply(boolean useBlockMatrix) {
        this.put(USEBLOCKMATRIXMULTIPLY, useBlockMatrix);
    }

    public boolean isUseMultiThreadedRandom() {
        return MathUtil.getBoolean(USEMULTITHREADEDRANDOM);
    }

    public void setUseMultiThreadedRandom(boolean value) {
        this.put(USEMULTITHREADEDRANDOM, value);
    }

    public int getDefaultBlockSize() {
        return MathUtil.getInt(this.get(DEFAULTBLOCKSIZE));
    }

    public void setDefaultBlockSize(int defaultBlockSize) {
        this.put(DEFAULTBLOCKSIZE, defaultBlockSize);
    }

    public String getUserAgent() {
        return StringUtil.getString(this.get(USERAGENT));
    }

    public void setUserAgent(String value) {
        this.put(USERAGENT, value);
    }

    public String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }
}

