/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import org.ujmp.core.Matrix;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.util.RandomSimple;
import org.ujmp.core.util.SerializationUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

public abstract class MathUtil {
    private static List<DateFormat> dateFormats = null;
    public static final double EPSILON = 1.0E-12;
    public static final double ROOT2PI = Math.sqrt(Math.PI * 2);
    public static final double LOG10 = Math.log(10.0);
    public static final double LOG2 = Math.log(2.0);
    private static final double[] COFGAMMALN = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static long seed = System.nanoTime();
    private static final ThreadLocal<Random> randoms = new ThreadLocal();
    private static final Random random = new RandomSimple();

    public static Random getRandom() {
        if (UJMPSettings.getInstance().isUseMultiThreadedRandom()) {
            Random random = randoms.get();
            if (random == null) {
                random = new RandomSimple();
                randoms.set(random);
            }
            return random;
        }
        return random;
    }

    public static String md5(String text) throws NoSuchAlgorithmException {
        return MathUtil.md5(text.getBytes());
    }

    public static final int search(long[] values, int fromIndex, int toIndex, long key) {
        --toIndex;
        while (fromIndex <= toIndex) {
            int mid = fromIndex + toIndex >>> 1;
            long midVal = values[mid];
            if (midVal < key) {
                fromIndex = mid + 1;
                continue;
            }
            if (midVal > key) {
                toIndex = mid - 1;
                continue;
            }
            return mid;
        }
        return -(fromIndex + 1);
    }

    public static String md5(byte[] data) {
        MessageDigest mdAlgorithm;
        StringBuilder hexString = new StringBuilder();
        try {
            mdAlgorithm = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        mdAlgorithm.update(data);
        byte[] digest = mdAlgorithm.digest();
        for (int i = 0; i < digest.length; ++i) {
            String text = Integer.toHexString(0xFF & digest[i]);
            if (text.length() < 2) {
                text = "0" + text;
            }
            hexString.append(text);
        }
        hexString.trimToSize();
        return hexString.toString();
    }

    public static String md5(File file) throws NoSuchAlgorithmException, IOException {
        StringBuilder hexString = new StringBuilder();
        MessageDigest mdAlgorithm = MessageDigest.getInstance("MD5");
        FileInputStream fi = new FileInputStream(file);
        BufferedInputStream bi = new BufferedInputStream(fi);
        byte[] data = new byte[8192];
        int length = bi.read(data);
        while (length != -1) {
            mdAlgorithm.update(data, 0, length);
            length = bi.read(data);
        }
        bi.close();
        fi.close();
        byte[] digest = mdAlgorithm.digest();
        for (int i = 0; i < digest.length; ++i) {
            String text = Integer.toHexString(0xFF & digest[i]);
            if (text.length() < 2) {
                text = "0" + text;
            }
            hexString.append(text);
        }
        hexString.trimToSize();
        return hexString.toString();
    }

    public static String md5(Serializable o) throws NoSuchAlgorithmException, IOException {
        return MathUtil.md5(SerializationUtil.serialize(o));
    }

    public static final boolean xor(boolean b1, boolean b2) {
        if (!b1 && !b2) {
            return false;
        }
        if (!b1 && b2) {
            return true;
        }
        return b1 && !b2;
    }

    public static double[] logToProbs(double[] logs) {
        int i;
        double[] probs = new double[logs.length];
        double max = MathUtil.max(logs);
        logs = MathUtil.minus(logs, max);
        double sum = 0.0;
        for (i = 0; i < probs.length; ++i) {
            probs[i] = Math.exp(logs[i]);
            sum += probs[i];
        }
        if (sum == 0.0) {
            Arrays.fill(probs, 0.0);
            return probs;
        }
        while (sum < 1.0E-6) {
            sum = 0.0;
            for (i = 0; i < probs.length; ++i) {
                int n = i;
                probs[n] = probs[n] * 10.0;
                sum += probs[i];
            }
        }
        for (i = 0; i < probs.length; ++i) {
            probs[i] = probs[i] / sum;
        }
        return probs;
    }

    public static double[] plus(double[] values, double value) {
        double[] result = Arrays.copyOf(values, values.length);
        int i = 0;
        while (i < values.length) {
            int n = i++;
            result[n] = result[n] + value;
        }
        return result;
    }

    public static double[] minus(double[] values, double value) {
        double[] result = Arrays.copyOf(values, values.length);
        int i = 0;
        while (i < values.length) {
            int n = i++;
            result[n] = result[n] - value;
        }
        return result;
    }

    public static final long getSeed() {
        return seed;
    }

    public static final double round(double value, int decimals) {
        return (double)Math.round(value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static void setSeed(long seed) {
        MathUtil.seed = seed;
        MathUtil.getRandom().setSeed(seed);
    }

    public static final double log2(double d) {
        return Math.log(d) / LOG2;
    }

    public static final double log10(double d) {
        return Math.log(d) / LOG10;
    }

    public static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static final double gauss(double mean, double sigma, double x) {
        return Math.exp(-0.5 * Math.pow((x - mean) / sigma, 2.0)) / (sigma * ROOT2PI);
    }

    public static final double artanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static final double nextGaussian(double mean, double sigma) {
        return sigma <= 0.0 ? 0.0 : sigma * MathUtil.getRandom().nextGaussian() + mean;
    }

    public static final double nextGaussian() {
        return MathUtil.getRandom().nextGaussian();
    }

    public static final double nextDouble(double min, double max) {
        return min + MathUtil.getRandom().nextDouble() * (max - min);
    }

    public static final int nextInteger(int min, int max) {
        return min == max ? min : min + MathUtil.getRandom().nextInt(max - min);
    }

    public static final int nextInteger(int max) {
        return MathUtil.getRandom().nextInt(max);
    }

    public static boolean isEventHappening(double probability) {
        return MathUtil.nextDouble() < probability;
    }

    public static boolean nextBoolean() {
        return MathUtil.getRandom().nextBoolean();
    }

    public static double nextDouble() {
        return MathUtil.getRandom().nextDouble();
    }

    public static final double ignoreNaN(double v) {
        return Double.isNaN(v) || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY ? 0.0 : v;
    }

    public static final boolean isNaNOrInfinite(double v) {
        return Double.isNaN(v) || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public static final boolean isNaNOrInfinite(Object o) {
        return Double.valueOf(Double.NaN).equals(o) || Double.valueOf(Double.POSITIVE_INFINITY).equals(o) || Double.valueOf(Double.NEGATIVE_INFINITY).equals(o);
    }

    public static final Matrix getMatrix(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Matrix) {
            Matrix m = (Matrix)o;
            if (m.isScalar() && m.getAsObject(0L, 0L) instanceof Matrix) {
                return MathUtil.getMatrix(m.getAsObject(0L, 0L));
            }
            return m;
        }
        return Matrix.Factory.linkToValue(o);
    }

    public static final Date getDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Long) {
            return new Date((Long)o);
        }
        if (o instanceof String) {
            for (DateFormat df : dateFormats) {
                try {
                    return df.parse((String)o);
                }
                catch (Exception exception) {
                }
            }
        }
        return new Date(MathUtil.getLong(o));
    }

    public static final double getDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).doubleValue();
        }
        if ("true".equalsIgnoreCase(o.toString())) {
            return 1.0;
        }
        if ("false".equalsIgnoreCase(o.toString())) {
            return 0.0;
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static final double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static final long[] collectionToLongArray(Collection<? extends Number> numbers) {
        long[] ret = new long[numbers.size()];
        int i = 0;
        for (Number number : numbers) {
            ret[i++] = number.longValue();
        }
        return ret;
    }

    public static final double[] collectionToDoubleArray(Collection<? extends Number> numbers) {
        double[] ret = new double[numbers.size()];
        int i = 0;
        for (Number number : numbers) {
            ret[i++] = number.doubleValue();
        }
        return ret;
    }

    public static final int[] collectionToIntArray(Collection<? extends Number> numbers) {
        int[] ret = new int[numbers.size()];
        int i = 0;
        for (Number number : numbers) {
            ret[i++] = number.intValue();
        }
        return ret;
    }

    public static List<Long> toLongList(long[] numbers) {
        FastArrayList<Long> ret = new FastArrayList<Long>(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            ret.add(numbers[i]);
        }
        return ret;
    }

    public static List<Long> toLongList(int[] numbers) {
        FastArrayList<Long> ret = new FastArrayList<Long>(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            ret.add(Long.valueOf(numbers[i]));
        }
        return ret;
    }

    public static List<Double> toDoubleList(double[] numbers) {
        FastArrayList<Double> ret = new FastArrayList<Double>(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            ret.add(numbers[i]);
        }
        return ret;
    }

    public static List<Double> toDoubleList(int[] numbers) {
        FastArrayList<Double> ret = new FastArrayList<Double>(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            ret.add(Double.valueOf(numbers[i]));
        }
        return ret;
    }

    public static List<Double> toDoubleList(long[] numbers) {
        FastArrayList<Double> ret = new FastArrayList<Double>(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            ret.add(Double.valueOf(numbers[i]));
        }
        return ret;
    }

    public static double[] toDoubleArray(int ... intArray) {
        int nmb = intArray.length;
        double[] ret = new double[nmb];
        for (int i = 0; i < nmb; ++i) {
            ret[i] = intArray[i];
        }
        return ret;
    }

    public static double[][] toDoubleArray(int[] ... intArray) {
        int rows = intArray.length;
        if (rows <= 0) {
            return new double[0][0];
        }
        int cols = intArray[0].length;
        double[][] ret = new double[rows][cols];
        for (int i = rows - 1; i >= 0; --i) {
            for (int j = cols - 1; j >= 0; --j) {
                ret[i][j] = intArray[i][j];
            }
        }
        return ret;
    }

    public static List<Long> sequenceListLong(long startInclusive, long endExclusive) {
        return MathUtil.sequenceListLong(startInclusive, endExclusive, 1L);
    }

    public static List<Long> sequenceListLong(long startInclusive, long endExclusive, long stepsize) {
        FastArrayList<Long> list = new FastArrayList<Long>();
        if (startInclusive < endExclusive) {
            stepsize = Math.abs(stepsize);
            for (long l = startInclusive; l < endExclusive; l += stepsize) {
                list.add(l);
            }
        } else {
            stepsize = -Math.abs(stepsize);
            for (long l = startInclusive; l > endExclusive; l += stepsize) {
                list.add(l);
            }
        }
        return list;
    }

    public static List<Double> sequenceListDouble(double startInclusive, double endExclusive) {
        return MathUtil.sequenceListDouble(startInclusive, endExclusive, 1.0);
    }

    public static List<Double> sequenceListDouble(double startInclusive, double endExclusive, double stepsize) {
        FastArrayList<Double> list = new FastArrayList<Double>();
        if (startInclusive < endExclusive) {
            stepsize = Math.abs(stepsize);
            for (double l = startInclusive; l < endExclusive; l += stepsize) {
                list.add(l);
            }
        } else {
            stepsize = -Math.abs(stepsize);
            for (double l = startInclusive; l > endExclusive; l += stepsize) {
                list.add(l);
            }
        }
        return list;
    }

    public static List<Integer> sequenceListInt(int startInclusive, int endExclusive) {
        FastArrayList<Integer> list = new FastArrayList<Integer>();
        if (startInclusive < endExclusive) {
            for (int l = startInclusive; l < endExclusive; ++l) {
                list.add(l);
            }
        } else {
            for (int l = startInclusive - 1; l > endExclusive; --l) {
                list.add(l);
            }
        }
        return list;
    }

    public static long[] sequenceLong(long startInclusive, long endExclusive) {
        return MathUtil.collectionToLongArray(MathUtil.sequenceListLong(startInclusive, endExclusive));
    }

    public static long[] sequenceLong(long startInclusive, long endExclusive, long stepsize) {
        return MathUtil.collectionToLongArray(MathUtil.sequenceListLong(startInclusive, endExclusive, stepsize));
    }

    public static double[] sequenceDouble(double startInclusive, double endExclusive) {
        return MathUtil.collectionToDoubleArray(MathUtil.sequenceListDouble(startInclusive, endExclusive));
    }

    public static double[] sequenceDouble(double startInclusive, double endExclusive, double stepsize) {
        return MathUtil.collectionToDoubleArray(MathUtil.sequenceListDouble(startInclusive, endExclusive, stepsize));
    }

    public static int[] sequenceInt(int startInclusive, int endExclusive) {
        return MathUtil.collectionToIntArray(MathUtil.sequenceListInt(startInclusive, endExclusive));
    }

    public static List<Long> randPermLong(long startInclusive, long endExclusive) {
        List<Long> list = MathUtil.sequenceListLong(startInclusive, endExclusive);
        Collections.shuffle(list);
        return list;
    }

    public static List<Integer> randPermInt(int startInclusive, int endExclusive) {
        List<Integer> list = MathUtil.sequenceListInt(startInclusive, endExclusive);
        Collections.shuffle(list);
        return list;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 instanceof Matrix && o2 instanceof Matrix) {
            return ((Matrix)o1).equals((Matrix)o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return MathUtil.getDouble(o1) == MathUtil.getDouble(o2);
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)o1).equals((String)o2);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return ((Boolean)o1).equals(o2);
        }
        if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
            return ((BigDecimal)o1).compareTo((BigDecimal)o2) == 0;
        }
        if (o1 instanceof BigInteger && o2 instanceof BigInteger) {
            return ((BigInteger)o1).compareTo((BigInteger)o2) == 0;
        }
        if (o1 instanceof String && o2 instanceof Number) {
            return MathUtil.getDouble(o1) == MathUtil.getDouble(o2);
        }
        if (o1 instanceof Number && o2 instanceof String) {
            return MathUtil.getDouble(o1) == MathUtil.getDouble(o2);
        }
        return o1.equals(o2);
    }

    public static double sensitivity(double tp, double fn) {
        double r = tp / (tp + fn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double specificity(double tn, double fp) {
        double r = tn / (tn + fp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double positivePredictiveValue(double tp, double fp) {
        double r = tp / (tp + fp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double negativePredictiveValue(double tn, double fn) {
        double r = tn / (tn + fn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double falsePositiveRate(double fp, double tn) {
        double r = fp / (fp + tn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double falseNegativeRate(double fn, double tp) {
        double r = fn / (fn + tp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double recall(double tp, double fn) {
        double r = tp / (tp + fn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double precision(double tp, double fp) {
        double r = tp / (tp + fp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double fallout(double tn, double fp) {
        double r = tn / (fp + tn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double trueNegativeRate(double tn, double fp) {
        double r = tn / (fp + tn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double f1Measure(double precision, double recall) {
        double r = 2.0 * precision * recall / (precision + recall);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double fBetaMeasure(double beta, double precision, double recall) {
        double r = (1.0 + beta * beta) * precision * recall / (beta * beta * precision + recall);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static Object getPreferredObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return o;
        }
        if (o instanceof String) {
            Double d = MathUtil.getDouble(o);
            if (MathUtil.isNaNOrInfinite(d)) {
                return o;
            }
            return d;
        }
        return o;
    }

    public static boolean getBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).booleanValue();
        }
        if (o instanceof String) {
            String s = ((String)o).toLowerCase();
            if (s.equals("true")) {
                return true;
            }
            if (s.equals("false")) {
                return false;
            }
            try {
                return Double.parseDouble(s) != 0.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static byte getByte(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).byteValue();
        }
        if (o instanceof String) {
            try {
                return Byte.parseByte((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static BigInteger getBigInteger(Object o) {
        if (o == null) {
            return BigInteger.ZERO;
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Number) {
            if (MathUtil.isNaNOrInfinite(o)) {
                throw new IllegalArgumentException("NaN, Inf and -Inf not allowed for BigInteger");
            }
            return BigInteger.valueOf(((Number)o).longValue());
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).bigIntegerValue();
        }
        if (o instanceof String) {
            return new BigInteger((String)o);
        }
        return BigInteger.ZERO;
    }

    public static BigDecimal getBigDecimal(Object o) {
        if (o == null) {
            return BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            double val = ((Number)o).doubleValue();
            if (MathUtil.isNaNOrInfinite(val)) {
                return null;
            }
            if (val == 0.0) {
                return BigDecimal.ZERO;
            }
            if (val == 1.0) {
                return BigDecimal.ONE;
            }
            if (val == 10.0) {
                return BigDecimal.TEN;
            }
            return BigDecimal.valueOf(val);
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).bigDecimalValue();
        }
        if (o instanceof String) {
            try {
                return new BigDecimal((String)o);
            }
            catch (Exception e) {
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public static char getChar(Object o) {
        if (o == null) {
            return '\u0000';
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return (char)((Number)o).byteValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).charValue();
        }
        if (o instanceof String) {
            try {
                return (char)Byte.parseByte((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return '\u0000';
    }

    public static float getFloat(Object o) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).floatValue();
        }
        if (o instanceof String) {
            try {
                return Float.parseFloat((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public static Object getObject(Object o) {
        Matrix m;
        if (o == null) {
            return null;
        }
        if (o instanceof Matrix && (m = (Matrix)o).getValueCount() == 1L) {
            return m.getAsObject(0L, 0L);
        }
        return o;
    }

    public static int getInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).intValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static long getLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static short getShort(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).shortValue();
        }
        if (o instanceof String) {
            try {
                return Short.parseShort((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int[] toIntArray(long ... coordinates) {
        int[] result = new int[coordinates.length];
        int i = coordinates.length;
        while (--i != -1) {
            result[i] = (int)coordinates[i];
        }
        return result;
    }

    public static long[] toLongArray(int ... coordinates) {
        long[] result = new long[coordinates.length];
        int i = coordinates.length;
        while (--i != -1) {
            result[i] = coordinates[i];
        }
        return result;
    }

    public static boolean isNull(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof Number && ((Number)value).doubleValue() == 0.0;
    }

    public static double norminv(double p, double mu, double sigma) {
        double val;
        if (sigma <= 0.0) {
            return Double.NaN;
        }
        if (MathUtil.isNaNOrInfinite(p)) {
            return Double.NaN;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        double p_ = p;
        double q = p_ - 0.5;
        if (Math.abs(q) <= 0.425) {
            double r = 0.180625 - q * q;
            val = q * (((((((r * 2509.0809287301227 + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((r * 5226.495278852854 + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
        } else {
            double r = q > 0.0 ? 1.0 - p : p_;
            r = Math.sqrt(-Math.log(r));
            val = r <= 5.0 ? ((((((((r += -1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((r * 1.0507500716444169E-9 + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : ((((((((r += -5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((r * 2.0442631033899397E-15 + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }

    public static double f1Measure(double tp, double fp, double fn) {
        double precision = MathUtil.precision(tp, fp);
        double recall = MathUtil.recall(tp, fn);
        return MathUtil.f1Measure(precision, recall);
    }

    public static final long factorial(int n) {
        long r = 1L;
        for (int i = 2; i <= n; ++i) {
            r *= (long)i;
        }
        return r;
    }

    public static final BigInteger factorialBig(int n) {
        BigInteger r = BigInteger.ONE;
        for (int i = 2; i <= n; ++i) {
            r = r.multiply(BigInteger.valueOf(i));
        }
        return r;
    }

    public static final long binomialCoefficient(int n, int k) {
        if (k > n || k < 0) {
            return 0L;
        }
        return MathUtil.factorial(n) / MathUtil.factorial(k) / MathUtil.factorial(n - k);
    }

    public static final BigInteger binomialCoefficientBig(int n, int k) {
        if (k > n || k < 0) {
            return BigInteger.ZERO;
        }
        return MathUtil.factorialBig(n).divide(MathUtil.factorialBig(k)).divide(MathUtil.factorialBig(n - k));
    }

    public static final boolean greater(BigInteger i1, BigInteger i2) {
        return i1.subtract(i2).signum() > 0;
    }

    public static final boolean smaller(BigInteger i1, BigInteger i2) {
        return i1.subtract(i2).signum() < 0;
    }

    public static int max(int[] values) {
        int max = -2147483647;
        for (int i = values.length - 1; i != -1; --i) {
            max = values[i] > max ? values[i] : max;
        }
        return max;
    }

    public static double max(double[] values) {
        double max = -1.7976931348623157E308;
        for (int i = values.length - 1; i != -1; --i) {
            max = values[i] > max ? values[i] : max;
        }
        return max;
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        for (int i = values.length - 1; i != -1; --i) {
            min = values[i] < min ? values[i] : min;
        }
        return min;
    }

    public static final BigDecimal plus(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.add(v2, UJMPSettings.getInstance().getMathContext());
        }
        return null;
    }

    public static final BigDecimal minus(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.subtract(v2, UJMPSettings.getInstance().getMathContext());
        }
        return null;
    }

    public static final BigDecimal times(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.multiply(v2, UJMPSettings.getInstance().getMathContext());
        }
        return null;
    }

    public static final BigDecimal divide(BigDecimal v1, BigDecimal v2) {
        if (BigDecimal.ZERO.equals(v2)) {
            return null;
        }
        if (v1 != null && v2 != null) {
            return v1.divide(v2, UJMPSettings.getInstance().getMathContext());
        }
        return null;
    }

    public static boolean isGreater(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0;
    }

    public static boolean isSmaller(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) < 0;
    }

    public static final BigDecimal sqrt(BigDecimal n) {
        if (n.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal TWO = new BigDecimal("2");
        BigDecimal lastGuess = BigDecimal.ZERO;
        BigDecimal guess = BigDecimal.ONE.movePointRight(n.toBigInteger().toString().length() / 2);
        int maxIterations = 50;
        int iterations = 0;
        boolean more = true;
        while (more) {
            lastGuess = guess;
            guess = n.divide(guess, UJMPSettings.getInstance().getMathContext());
            guess = guess.add(lastGuess);
            guess = guess.divide(TWO, UJMPSettings.getInstance().getMathContext());
            BigDecimal error = n.subtract(guess.multiply(guess));
            if (++iterations >= maxIterations) {
                more = false;
                continue;
            }
            if (!lastGuess.equals(guess)) continue;
            more = error.abs().compareTo(BigDecimal.ONE) >= 0;
        }
        return guess;
    }

    public static final double gammaln(double x) {
        double ser = 1.00000000090015;
        double y = x;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        for (int j = 0; j < 5; ++j) {
            ser += COFGAMMALN[j] / (y += 1.0);
        }
        return -tmp + Math.log(ser * 2.5066282751072975 / x);
    }

    public static final long pos2IndexRowMajor(long[] size, long[] pos) {
        long sum = 0L;
        long prod = 1L;
        int length = pos.length;
        for (int k = length - 1; k >= 0; --k) {
            sum += prod * pos[k];
            prod *= size[k];
        }
        return sum;
    }

    public static final long pos2IndexColumnMajor(long[] size, long[] pos) {
        long sum = 0L;
        long prod = 1L;
        int length = pos.length;
        for (int k = 0; k < length; ++k) {
            sum += prod * pos[k];
            prod *= size[k];
        }
        return sum;
    }

    public static final long[] index2PosRowMajor(long[] size, long index) {
        long[] pos = new long[size.length];
        long res = index;
        int k = size.length;
        while (--k != -1) {
            pos[k] = res % size[k];
            res /= size[k];
        }
        return pos;
    }

    public static final long[] index2PosColumnMajor(long[] size, long index) {
        int length = size.length;
        long[] pos = new long[length];
        long res = index;
        for (int k = 0; k < length; ++k) {
            pos[k] = res % size[k];
            res /= size[k];
        }
        return pos;
    }

    public static final long totalCorrect(Matrix confusionMatrix) {
        VerifyUtil.verifySquare(confusionMatrix);
        return (long)confusionMatrix.trace();
    }

    public static final double accuracy(Matrix confusionMatrix) {
        VerifyUtil.verifySquare(confusionMatrix);
        return (double)MathUtil.totalCorrect(confusionMatrix) / confusionMatrix.getValueSum();
    }

    public static double precisionMacro(Matrix confusionMatrix) {
        VerifyUtil.verifySquare(confusionMatrix);
        double sum = 0.0;
        int catIndex = 0;
        while ((long)catIndex < confusionMatrix.getRowCount()) {
            sum += MathUtil.precision(confusionMatrix, catIndex);
            ++catIndex;
        }
        return sum / (double)confusionMatrix.getRowCount();
    }

    public static double recallMacro(Matrix confusionMatrix) {
        VerifyUtil.verifySquare(confusionMatrix);
        double sum = 0.0;
        int catIndex = 0;
        while ((long)catIndex < confusionMatrix.getRowCount()) {
            sum += MathUtil.recall(confusionMatrix, catIndex);
            ++catIndex;
        }
        return sum / (double)confusionMatrix.getRowCount();
    }

    public static double f1MeasureMacro(Matrix confusionMatrix) {
        VerifyUtil.verifySquare(confusionMatrix);
        double sum = 0.0;
        int catIndex = 0;
        while ((long)catIndex < confusionMatrix.getRowCount()) {
            sum += MathUtil.f1Measure(confusionMatrix, catIndex);
            ++catIndex;
        }
        return sum / (double)confusionMatrix.getRowCount();
    }

    public static double precision(Matrix confusionMatrix, long catIndex) {
        VerifyUtil.verifySquare(confusionMatrix);
        double tp = confusionMatrix.getAsDouble(catIndex, catIndex);
        double fp = 0.0;
        int c = 0;
        while ((long)c < confusionMatrix.getRowCount()) {
            if ((long)c != catIndex) {
                fp += confusionMatrix.getAsDouble(catIndex, c);
            }
            ++c;
        }
        return MathUtil.precision(tp, fp);
    }

    public static double recall(Matrix confusionMatrix, long catIndex) {
        VerifyUtil.verifySquare(confusionMatrix);
        double tp = confusionMatrix.getAsDouble(catIndex, catIndex);
        double fn = 0.0;
        int r = 0;
        while ((long)r < confusionMatrix.getRowCount()) {
            if ((long)r != catIndex) {
                fn += confusionMatrix.getAsDouble(r, catIndex);
            }
            ++r;
        }
        return MathUtil.recall(tp, fn);
    }

    public static double f1Measure(Matrix confusionMatrix, long catIndex) {
        VerifyUtil.verifySquare(confusionMatrix);
        return MathUtil.f1Measure(MathUtil.precision(confusionMatrix, catIndex), MathUtil.recall(confusionMatrix, catIndex));
    }

    public static double precisionMicro(Matrix confusionMatrix) {
        double tp = 0.0;
        double fp = 0.0;
        int catIndex = 0;
        while ((long)catIndex < confusionMatrix.getRowCount()) {
            tp += confusionMatrix.getAsDouble(catIndex, catIndex);
            int c = 0;
            while ((long)c < confusionMatrix.getRowCount()) {
                if (c != catIndex) {
                    fp += confusionMatrix.getAsDouble(catIndex, c);
                }
                ++c;
            }
            ++catIndex;
        }
        return MathUtil.precision(tp, fp);
    }

    public static double recallMicro(Matrix confusionMatrix) {
        double tp = 0.0;
        double fn = 0.0;
        int catIndex = 0;
        while ((long)catIndex < confusionMatrix.getRowCount()) {
            tp += confusionMatrix.getAsDouble(catIndex, catIndex);
            int r = 0;
            while ((long)r < confusionMatrix.getRowCount()) {
                if (r != catIndex) {
                    fn += confusionMatrix.getAsDouble(r, catIndex);
                }
                ++r;
            }
            ++catIndex;
        }
        return MathUtil.recall(tp, fn);
    }

    public static double f1MeasureMicro(Matrix confusionMatrix) {
        double tp = 0.0;
        double fn = 0.0;
        double fp = 0.0;
        int catIndex = 0;
        while ((long)catIndex < confusionMatrix.getRowCount()) {
            tp += confusionMatrix.getAsDouble(catIndex, catIndex);
            int r = 0;
            while ((long)r < confusionMatrix.getRowCount()) {
                if (r != catIndex) {
                    fn += confusionMatrix.getAsDouble(r, catIndex);
                }
                ++r;
            }
            int c = 0;
            while ((long)c < confusionMatrix.getRowCount()) {
                if (c != catIndex) {
                    fp += confusionMatrix.getAsDouble(catIndex, c);
                }
                ++c;
            }
            ++catIndex;
        }
        return MathUtil.f1Measure(tp, fp, fn);
    }

    public static final int longToIntClip(long value) {
        int intValue = (int)value;
        if (value == (long)intValue) {
            return intValue;
        }
        if (value >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    public static final int longToInt(long value) {
        int intValue = (int)value;
        if (value == (long)intValue) {
            return intValue;
        }
        throw new IllegalArgumentException("long value too large, it cannot be converted to int");
    }

    public static boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static boolean isSign(char c) {
        switch (c) {
            case '+': 
            case '-': {
                return true;
            }
        }
        return false;
    }

    public static int hexToInt(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static String intToHex(int i) {
        return Integer.toHexString(i);
    }

    public static boolean isDiscrete(double number) {
        return (double)((int)number) == number;
    }

    public static String guid() {
        return UUID.randomUUID().toString();
    }

    static {
        try {
            MathUtil.getRandom().setSeed(seed);
            dateFormats = new FastArrayList<DateFormat>();
            dateFormats.add(DateFormat.getDateInstance(3, Locale.US));
            dateFormats.add(DateFormat.getDateInstance(2, Locale.US));
            dateFormats.add(DateFormat.getDateInstance(1, Locale.US));
            dateFormats.add(DateFormat.getDateInstance(3, Locale.GERMAN));
            dateFormats.add(DateFormat.getDateInstance(2, Locale.GERMAN));
            dateFormats.add(DateFormat.getDateInstance(1, Locale.GERMAN));
            dateFormats.add(DateFormat.getTimeInstance(3, Locale.US));
            dateFormats.add(DateFormat.getTimeInstance(2, Locale.US));
            dateFormats.add(DateFormat.getTimeInstance(1, Locale.US));
            dateFormats.add(DateFormat.getTimeInstance(3, Locale.GERMAN));
            dateFormats.add(DateFormat.getTimeInstance(2, Locale.GERMAN));
            dateFormats.add(DateFormat.getTimeInstance(1, Locale.GERMAN));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

