/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.util.Iterator;
import org.ujmp.core.Coordinates;

public class CoordinateIterator
implements Iterable<long[]> {
    private long[] size = null;

    public CoordinateIterator(long ... size) {
        this.size = size;
    }

    @Override
    public Iterator<long[]> iterator() {
        return new It(this.size);
    }

    class It
    implements Iterator<long[]> {
        long[] cursor = null;
        long[] size = null;
        long[] lastEntry = null;
        boolean isNotEmpty = false;

        public It(long ... size) {
            this.size = size;
            this.lastEntry = Coordinates.minus(size, 1L);
            this.cursor = new long[size.length];
            int n = this.cursor.length - 1;
            this.cursor[n] = this.cursor[n] - 1L;
            this.isNotEmpty = Coordinates.product(size) != 0L;
        }

        @Override
        public boolean hasNext() {
            return !Coordinates.equals(this.lastEntry, this.cursor) && this.isNotEmpty;
        }

        @Override
        public long[] next() {
            this.increment(this.cursor.length - 1);
            return this.cursor;
        }

        private void increment(int dim) {
            int n = dim;
            this.cursor[n] = this.cursor[n] + 1L;
            if (this.cursor[dim] == this.size[dim]) {
                this.cursor[dim] = 0L;
                this.increment(dim - 1);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("not implemented");
        }
    }
}

