/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.treematrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujmp.core.collections.list.ArrayIndexList;
import org.ujmp.core.treematrix.AbstractTreeMatrix;

public class DefaultTreeMatrix<T>
extends AbstractTreeMatrix<T> {
    private static final long serialVersionUID = -6752285310555819432L;
    private final List<T> objects = new ArrayIndexList<T>();
    private T root = null;
    private final Map<T, List<T>> childrenMap = new HashMap<T, List<T>>();
    private final Map<T, T> parentMap = new HashMap<T, T>();

    @Override
    public List<T> getChildren(Object o) {
        List<T> children = this.childrenMap.get(o);
        if (children == null) {
            children = new ArrayList<T>();
            this.childrenMap.put(o, children);
        }
        return children;
    }

    @Override
    public final void clear() {
        this.objects.clear();
        this.childrenMap.clear();
        this.parentMap.clear();
        this.root = null;
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Map<T, T> getParentMap() {
        return this.parentMap;
    }

    @Override
    public List<T> getObjectList() {
        return this.objects;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(T o) {
        this.root = o;
        if (!this.objects.contains(o)) {
            this.objects.add(o);
        }
        this.fireValueChanged();
    }
}

