/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.stringmatrix.calculation.AbstractStringCalculation;
import org.ujmp.core.util.PorterStemmer;

public class Stem
extends AbstractStringCalculation {
    private static final long serialVersionUID = 1221910899287177556L;
    private PorterStemmer stemmer = new PorterStemmer();

    public Stem(Matrix m) {
        super(m);
    }

    @Override
    public String getString(long ... coordinates) {
        String s = this.getSource().getAsString(coordinates).toLowerCase();
        StringBuilder result = new StringBuilder(s.length());
        String[] words = s.split("\\s+");
        for (int i = 0; i < words.length; ++i) {
            String w = words[i];
            if (w.length() == 0) continue;
            result.append(this.stemmer.stem(w));
            if (i >= words.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }
}

