/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.stub;

import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;
import org.ujmp.core.util.CoordinateSetToLongWrapper;
import org.ujmp.core.util.MathUtil;

public abstract class AbstractMapToSparseMatrixWrapper
extends AbstractSparseObjectMatrix
implements Wrapper<Map<Coordinates, Object>> {
    private static final long serialVersionUID = -6292034262789053069L;
    private final Object defaultValue = null;
    private final Map<Coordinates, Object> values;
    private int maximumNumberOfEntries = -1;

    public AbstractMapToSparseMatrixWrapper(Map<Coordinates, Object> map, Matrix m) {
        super(m.getSize());
        this.size = Coordinates.copyOf(m.getSize());
        this.values = map;
        for (long[] c : m.allCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    public AbstractMapToSparseMatrixWrapper(Map<Coordinates, Object> map, long ... size) {
        super(size);
        this.size = Coordinates.copyOf(size);
        this.values = map;
    }

    public final Map<Coordinates, Object> getMap() {
        return this.values;
    }

    @Override
    public final Map<Coordinates, Object> getWrappedObject() {
        return this.getMap();
    }

    public final void setWrappedObject(Map<Coordinates, Object> object) {
        throw new RuntimeException("not allowed");
    }

    @Override
    public final Object getObject(long ... coordinates) {
        Object v = this.getMap().get(Coordinates.wrap(coordinates));
        return v == null ? this.defaultValue : v;
    }

    @Override
    public final boolean containsCoordinates(long ... coordinates) {
        return this.getMap().containsKey(Coordinates.wrap(coordinates));
    }

    @Override
    public final double getAsDouble(long ... coordinates) {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public final void setAsDouble(double v, long ... coordinates) {
        this.setObject((Object)v, coordinates);
    }

    @Override
    public final void setObject(Object o, long ... coordinates) {
        if (MathUtil.getDouble(o) == 0.0) {
            this.getMap().remove(Coordinates.wrap(coordinates));
        } else {
            while (this.maximumNumberOfEntries > 0 && this.getMap().size() > this.maximumNumberOfEntries) {
                this.getMap().remove(this.getMap().keySet().iterator().next());
            }
            if (Coordinates.isSmallerThan(coordinates, this.getSize())) {
                this.getMap().put(Coordinates.wrap(coordinates).clone(), o);
            }
        }
    }

    public final int getMaximumNumberOfEntries() {
        return this.maximumNumberOfEntries;
    }

    @Override
    public final long getValueCount() {
        return this.getMap().size();
    }

    @Override
    public final Iterable<long[]> availableCoordinates() {
        return new CoordinateSetToLongWrapper(this.getMap().keySet());
    }

    public final void setMaximumNumberOfEntries(int maximumNumberOfEntries) {
        this.maximumNumberOfEntries = maximumNumberOfEntries;
    }
}

