/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.objectmatrix.impl.NonZeroIterable;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix2D;

public class DefaultSparseColumnObjectMatrix2D
extends AbstractSparseObjectMatrix2D
implements Wrapper<Map<Long, Matrix>> {
    private static final long serialVersionUID = -1943118812754494387L;
    protected Map<Long, Matrix> columns = new HashMap<Long, Matrix>();

    public DefaultSparseColumnObjectMatrix2D(long rows, long columns) {
        super(rows, columns);
        this.setSize(rows, columns);
    }

    public DefaultSparseColumnObjectMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.setSize(m.getSize());
        for (long[] c : m.availableCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
        if (m.getMetaData() != null) {
            this.setMetaData((MapMatrix<String, Object>)m.getMetaData().clone());
        }
    }

    @Override
    public Object getObject(long row, long column) {
        Matrix m = this.columns.get(column);
        return m == null ? null : m.getAsObject(row, 0L);
    }

    @Override
    public Object getObject(int row, int column) {
        Matrix m = this.columns.get(column);
        return m == null ? null : m.getAsObject(row, 0L);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new NonZeroIterable(this);
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        if (Coordinates.isSmallerThan(coordinates, this.size)) {
            return this.getObject(coordinates) != null;
        }
        return false;
    }

    @Override
    public void setObject(Object o, long row, long column) {
        Matrix m = this.columns.get(column);
        if (m == null) {
            m = new DefaultSparseObjectMatrix(this.getRowCount(), 1L);
            this.columns.put(column, m);
        }
        m.setAsObject(o, row, 0L);
    }

    @Override
    public void setObject(Object o, int row, int column) {
        this.setObject(o, (long)row, (long)column);
    }

    @Override
    public void setSize(long ... size) {
        if (this.size[0] != size[0]) {
            for (Matrix m : this.columns.values()) {
                m.setSize(size[0], 1L);
            }
        }
        this.size = size;
    }

    @Override
    public final void clear() {
        this.columns.clear();
    }

    public Matrix getColumn(long column) {
        return this.columns.get((int)column);
    }

    @Override
    public Matrix max(Calculation.Ret returnType, int dimension) {
        if (returnType == Calculation.Ret.NEW) {
            if (dimension == 0) {
                DenseMatrix ret = Matrix.Factory.zeros(1L, this.getColumnCount());
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{0L, c[1]};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, 0L, c[1]);
                }
                return ret;
            }
            if (dimension == 1) {
                DenseMatrix ret = Matrix.Factory.zeros(this.getRowCount(), 1L);
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{c[0], 0L};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, c[0], 0L);
                }
                return ret;
            }
        }
        throw new RuntimeException("not supported");
    }

    @Override
    public Matrix selectColumns(Calculation.Ret returnType, long ... columns) {
        if (returnType == Calculation.Ret.LINK && columns.length == 1) {
            return this.getColumn(columns[0]);
        }
        return super.selectColumns(returnType, columns);
    }

    @Override
    public Map<Long, Matrix> getWrappedObject() {
        return this.columns;
    }

    public void setWrappedObject(Map<Long, Matrix> object) {
        this.columns = object;
    }
}

