/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.HashSet;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class UniqueValueCount
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -5621298156781794790L;

    public UniqueValueCount(Matrix m, int dimension) {
        super(dimension, m);
    }

    @Override
    public Object getObject(long ... coordinates) {
        HashSet<Object> set = new HashSet<Object>();
        switch (this.getDimension()) {
            case 0: {
                int r = 0;
                while ((long)r < this.getSource().getRowCount()) {
                    set.add(this.getSource().getAsObject(r, coordinates[1]));
                    ++r;
                }
                return set.size();
            }
            case 1: {
                int c = 0;
                while ((long)c < this.getSource().getColumnCount()) {
                    set.add(this.getSource().getAsObject(coordinates[0], c));
                    ++c;
                }
                return set.size();
            }
        }
        for (long[] c : this.getSource().availableCoordinates()) {
            set.add(this.getSource().getAsObject(c));
        }
        return set.size();
    }

    @Override
    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getColumnCount()};
            }
            case 1: {
                return new long[]{this.getSource().getRowCount(), 1L};
            }
        }
        return new long[]{1L, 1L};
    }
}

