/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class Join
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -4037364843847848445L;
    private Matrix result = null;
    private long column1 = 0L;
    private long column2 = 0L;

    public Join(Matrix m1, Matrix m2, long column1, long column2) {
        super(m1, m2);
        this.column1 = column1;
        this.column2 = column2;
    }

    @Override
    public Object getObject(long ... coordinates) {
        if (this.result == null) {
            this.createMatrix();
        }
        return this.result.getAsObject(coordinates);
    }

    @Override
    public long[] getSize() {
        if (this.result == null) {
            this.createMatrix();
        }
        return this.result.getSize();
    }

    private void createMatrix() {
        List list;
        Object o;
        Matrix m1 = this.getSource();
        Matrix m2 = this.getSources()[1];
        HashMap<Object, LinkedList<Long>> right = new HashMap<Object, LinkedList<Long>>();
        for (long r = 0L; r < m2.getRowCount(); ++r) {
            o = m2.getAsObject(r, this.column2);
            list = (LinkedList<Long>)right.get(o);
            if (list == null) {
                list = new LinkedList<Long>();
                right.put(o, (LinkedList<Long>)list);
            }
            list.add(r);
        }
        this.result = Matrix.Factory.zeros(this.getValueType(), m1.getRowCount(), m1.getColumnCount() + m2.getColumnCount());
        for (long[] c : m1.allCoordinates()) {
            this.result.setAsObject(m1.getAsObject(c), c);
        }
        for (long r = 0L; r < m1.getRowCount(); ++r) {
            o = m1.getAsObject(r, this.column1);
            list = (List)right.get(o);
            if (list == null) continue;
            long row2 = (Long)list.iterator().next();
            for (long c = 0L; c < m2.getColumnCount(); ++c) {
                this.result.setAsObject(m2.getAsObject(row2, c), r, c + m1.getColumnCount());
            }
        }
    }
}

