/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.TreeMap;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class ExtractAnnotation
extends AbstractObjectCalculation {
    private static final long serialVersionUID = 1461447576658284276L;
    private long[] size = null;

    public ExtractAnnotation(Matrix m, int dim) {
        super(dim, m);
        this.size = Coordinates.copyOf(m.getSize());
        int n = dim;
        this.size[n] = this.size[n] - 1L;
        this.setMetaData(new DefaultMapMatrix<String, Object>(new TreeMap()));
        this.getMetaData().put("Label", m.getLabelObject());
        if (dim == 0) {
            Matrix ai;
            MapMatrix<String, Object> a = m.getMetaData();
            if (a != null && (ai = (Matrix)a.get("DimensionMetaData1")) != null) {
                ai = ai.deleteRows(Calculation.Ret.NEW, 0L);
                this.getMetaData().put("DimensionMetaData1", ai);
            }
            this.getMetaData().put("DimensionMetaData0", m.selectRows(Calculation.Ret.NEW, 0L));
        } else if (dim == 1) {
            Matrix ai;
            MapMatrix<String, Object> a = m.getMetaData();
            if (a != null && (ai = (Matrix)a.get("DimensionMetaData0")) != null) {
                ai = ai.selectColumns(Calculation.Ret.NEW, 0L);
                this.getMetaData().put("DimensionMetaData0", ai);
            }
            this.getMetaData().put("DimensionMetaData1", m.selectColumns(Calculation.Ret.NEW, 0L));
        } else {
            throw new RuntimeException("only supported for 2D matrices");
        }
    }

    @Override
    public Object getObject(long ... coordinates) {
        coordinates = Coordinates.copyOf(coordinates);
        int n = this.getDimension();
        coordinates[n] = coordinates[n] + 1L;
        return this.getSource().getAsObject(coordinates);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }
}

