/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.graphmatrix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ujmp.core.genericmatrix.stub.AbstractSparseGenericMatrix2D;
import org.ujmp.core.graphmatrix.GraphMatrix;
import org.ujmp.core.util.MathUtil;

public abstract class AbstractGraphMatrix<N, E>
extends AbstractSparseGenericMatrix2D<E>
implements GraphMatrix<N, E> {
    private static final long serialVersionUID = -4939918585100574441L;

    public AbstractGraphMatrix() {
        super(0L, 0L);
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.isConnected(coordinates[0], coordinates[1]);
    }

    @Override
    public boolean isConnected(N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        return this.isConnected(index1, index2);
    }

    @Override
    public List<N> getParents(long index) {
        List<Long> indices = this.getParentIndices((N)index);
        ArrayList objects = new ArrayList(indices.size());
        for (int i = 0; i < indices.size(); ++i) {
            objects.add(this.getNode(indices.get(i)));
        }
        return objects;
    }

    public List<E> getEdgesToParents(N node) {
        long index = this.getIndexOfNode(node);
        List<Long> parentIndices = this.getParentIndices((N)index);
        ArrayList<E> edgeList = new ArrayList<E>(parentIndices.size());
        for (long parentIndex : parentIndices) {
            edgeList.add(this.getEdge((N)parentIndex, (N)index));
        }
        return edgeList;
    }

    public List<E> getEdgesToChildren(N node) {
        long index = this.getIndexOfNode(node);
        List<Long> childIndices = this.getChildIndices((N)index);
        ArrayList<E> edgeList = new ArrayList<E>(childIndices.size());
        for (long childIndex : childIndices) {
            edgeList.add(this.getEdge((N)index, (N)childIndex));
        }
        return edgeList;
    }

    @Override
    public List<N> getParents(N node) {
        List<Long> indices = this.getParentIndices(node);
        ArrayList objects = new ArrayList(indices.size());
        for (int i = 0; i < indices.size(); ++i) {
            objects.add(this.getNode(indices.get(i)));
        }
        return objects;
    }

    @Override
    public List<N> getChildren(long index) {
        List<Long> indices = this.getChildIndices((N)index);
        ArrayList objects = new ArrayList(indices.size());
        for (int i = 0; i < indices.size(); ++i) {
            objects.add(this.getNode(indices.get(i)));
        }
        return objects;
    }

    @Override
    public List<Long> getParentIndices(N node) {
        long index = this.getIndexOfNode(node);
        return this.getParentIndices((N)index);
    }

    @Override
    public E getEdge(N node1, N node2) {
        long index1 = this.getIndexOfNode(node1);
        long index2 = this.getIndexOfNode(node2);
        return this.getEdge((N)index1, (N)index2);
    }

    @Override
    public int getDegree(N node) {
        return this.getParentCount(node) + this.getChildCount(node);
    }

    @Override
    public int getDegree(long nodeIndex) {
        return this.getParentCount((N)nodeIndex) + this.getChildCount((N)nodeIndex);
    }

    @Override
    public int getChildCount(N node) {
        return this.getChildCount((N)this.getIndexOfNode(node));
    }

    @Override
    public int getParentCount(N node) {
        long index = this.getIndexOfNode(node);
        return this.getParentCount((N)index);
    }

    @Override
    public List<Long> getChildIndices(N node) {
        long index = this.getIndexOfNode(node);
        return this.getChildIndices((N)index);
    }

    @Override
    public List<N> getChildren(N node) {
        List<Long> indices = this.getChildIndices(node);
        ArrayList objects = new ArrayList(indices.size());
        for (int i = 0; i < indices.size(); ++i) {
            objects.add(this.getNode(indices.get(i)));
        }
        return objects;
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        Iterable<long[]> iterable = new Iterable<long[]>(){

            @Override
            public Iterator<long[]> iterator() {
                Iterator<long[]> iterator = new Iterator<long[]>(){
                    Iterator<N> parents;
                    N parent;
                    long parentIndex;
                    Iterator<N> children;
                    long[] current;
                    {
                        this.parents = AbstractGraphMatrix.this.getNodeList().iterator();
                        this.parent = this.parents.next();
                        this.parentIndex = AbstractGraphMatrix.this.getIndexOfNode(this.parent);
                        this.children = AbstractGraphMatrix.this.getChildren(this.parent).iterator();
                        this.current = null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current != null) {
                            return true;
                        }
                        while (!this.children.hasNext() && this.parents.hasNext()) {
                            this.parent = this.parents.next();
                            this.parentIndex = AbstractGraphMatrix.this.getIndexOfNode(this.parent);
                            this.children = AbstractGraphMatrix.this.getChildren(this.parent).iterator();
                        }
                        if (this.children.hasNext()) {
                            this.current = new long[]{this.parentIndex, AbstractGraphMatrix.this.getIndexOfNode(this.children.next())};
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public long[] next() {
                        long[] tmp = this.current;
                        this.current = null;
                        return tmp;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove not allowed");
                    }
                };
                return iterator;
            }
        };
        return iterable;
    }

    @Override
    public final long[] getSize() {
        this.size[0] = this.getNodeCount();
        this.size[1] = this.getNodeCount();
        return this.size;
    }

    @Override
    public final E getObject(long row, long column) {
        return this.getEdge((N)row, (N)column);
    }

    @Override
    public final E getObject(int row, int column) {
        return this.getEdge((N)row, (N)column);
    }

    @Override
    public final long getValueCount() {
        return this.getEdgeCount();
    }

    @Override
    public final void setObject(E value, long row, long column) {
        this.setEdge(value, row, column);
    }

    @Override
    public final void setObject(E value, int row, int column) {
        this.setEdge(value, (long)row, (long)column);
    }

    @Override
    public final boolean isConnected(long node1, long node2) {
        return MathUtil.getBoolean(this.getObject(node1, node2));
    }

    @Override
    public final long getIndexOfNode(N o) {
        return this.getNodeList().indexOf(o);
    }
}

