/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.floatmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.floatmatrix.stub.AbstractDenseFloatMatrix2D;

public class ArrayDenseFloatMatrix2D
extends AbstractDenseFloatMatrix2D {
    private static final long serialVersionUID = 6599658021180126741L;
    private final float[][] values;

    public ArrayDenseFloatMatrix2D(float[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseFloatMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new float[rows][columns];
    }

    @Override
    public long getRowCount() {
        return this.values.length;
    }

    @Override
    public long getColumnCount() {
        return this.values.length == 0 ? 0L : (long)this.values[0].length;
    }

    @Override
    public float getFloat(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    @Override
    public void setFloat(float value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    @Override
    public float getFloat(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void setFloat(float value, int row, int column) {
        this.values[row][column] = value;
    }

    @Override
    public final Matrix transpose() {
        float[][] result = new float[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseFloatMatrix2D(result);
    }
}

