/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.floatmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.floatmatrix.FloatMatrix;
import org.ujmp.core.floatmatrix.calculation.FloatCalculation;
import org.ujmp.core.floatmatrix.impl.FloatCalculationMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;

public abstract class AbstractFloatCalculation
extends AbstractCalculation
implements FloatCalculation {
    private static final long serialVersionUID = 7992575645594878948L;

    public AbstractFloatCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractFloatCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    @Override
    public final FloatMatrix calcLink() {
        return new FloatCalculationMatrix(this);
    }

    @Override
    public final FloatMatrix calcNew() {
        FloatMatrix result = (FloatMatrix)Matrix.Factory.zeros(ValueType.FLOAT, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsFloat(this.getFloat(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData((MapMatrix<String, Object>)this.getMetaData().clone());
        }
        return result;
    }

    @Override
    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsFloat(this.getFloat(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    @Override
    public void setFloat(float value, long ... coordinates) {
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.FLOAT;
    }
}

