/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.filematrix;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.filechooser.FileFilter;
import org.ujmp.core.util.io.UJMPFileFilter;

public enum FileFormat {
    UNKNOWN("unknown", ""),
    AES("AES Crypt File", new byte[]{65, 69, 83}, "aes"),
    AI("Adobe Illustrator File", "ai"),
    AML("AML Files", "aml"),
    ARJ("ARJ Compressed File", new byte[]{96, -22}, "arj"),
    ARC("FreeArc Compressed File", new byte[]{65, 114, 67, 1}, "arc"),
    ARFF("Attribute-Relation File", "arf", "arff"),
    ATOM("Atom Feed", "atom", "xml"),
    ATT("ATT File", "att"),
    AVI("AVI Video File", 8, new byte[]{65, 86, 73, 32, 76, 73, 83, 84}, "avi"),
    BMP("BMP Image File", new byte[]{66, 77}, "bmp"),
    BZ("BZip File", new byte[]{66, 90}, "bz", "bzip", "bz2", "tbz2", "tb2"),
    C("C File", "c"),
    CAB("CAB Installer File", new byte[]{77, 83, 67, 70}, "cab"),
    CLASS("Class File", new byte[]{-54, -2, -70, -66}, "class"),
    CS("C# File", "cs"),
    CSV("Comma Separated File", "csv"),
    DB("SQLite Database File", new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116, 32}, "db"),
    DIRECTORY("Directory", ""),
    DLL("Windows Dynamic Library", new byte[]{77, 90}, "dll"),
    DOC("Microsoft Word File", new byte[]{-48, -49, 17, -32, -95, -79, 26, -31}, "doc"),
    DOCX("Microsoft Word 2010 File", new byte[]{80, 75, 3, 4}, "docx"),
    DWG("AutoCAD File", new byte[]{65, 67, 49, 48}, "dwg"),
    ELF("Unix Executable File", new byte[]{127, 69, 76, 70}, "elf"),
    EML("Email File", new byte[]{82, 101, 116, 117, 114, 110, 45, 80, 97, 116, 104, 58, 32}, "eml"),
    EPS("EPS File", new byte[]{37, 33, 80, 83, 45, 65, 100, 111, 98, 101, 45, 51, 46, 48, 32, 69, 80, 83, 70, 45, 51, 32, 48}, "eps"),
    EPUB("Open Publication Structure eBook File", new byte[]{80, 75, 3, 4, 10, 0, 2, 0}, "epub"),
    EXE("Windows Executable File", new byte[]{77, 90}, "exe"),
    FDB("Firebird/Interbase Database File", new byte[]{1, 0, 57, 48}, "fdb", "gdb"),
    FIG("Xfig File", new byte[]{35, 70, 73, 71}, "fig"),
    FILE("Text File", "*"),
    FLAC("Free Lossless Audio Codec File", new byte[]{102, 76, 97, 67, 0, 0, 0, 34}, "flac"),
    FLV("Flash Video File", new byte[]{70, 76, 86}, "flv"),
    GIF("GIF Image File", new byte[]{71, 73, 70, 56}, "gif"),
    GRAPHML("GraphML File", "graphml", "gml"),
    GZ("GZip File", new byte[]{31, -117, 8}, "gz", "tgz"),
    H("C Header File", "h"),
    HEX("Binary File", "raw", "hex", "bin"),
    HLP("Help File", new byte[]{63, 95, 3, 0}, "hlp"),
    HTML("HTML File", "html", "htm"),
    ICO("Icon File", new byte[]{0, 0, 1, 0}, "ico"),
    ImapMessages("Imap Message", "imap"),
    ImapFolders("Imap Folder", "imap"),
    ISO("ISO-9660 Disc Image", new byte[]{67, 68, 48, 48, 49}, "iso"),
    JAVA("Java File", "java"),
    JAR("Java JAR File", new byte[]{80, 75, 3, 4, 20, 0, 8, 0, 8, 0}, "jar"),
    JPG("JPEG Image File", new byte[]{-1, -40, -1, -32}, "jpg", "jpeg", "jfif", "jpe"),
    JPEG2000("JPEG2000 Image File", new byte[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10}, "jp2"),
    LOG("Log File", "log"),
    M("Matlab Script File", "m"),
    MAT("Matlab Data File", "mat"),
    MDB("Microsoft Access File", new byte[]{83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116}, "mdb"),
    MDF("Microsoft SQL Server 2000 Database File", new byte[]{1, 15, 0, 0}, "mdf"),
    MID("MIDI File", new byte[]{77, 84, 104, 100}, "mid"),
    MKV("Matroska Stream File", new byte[]{26, 69, -33, -93, -109, 66, -126, -120, 109, 97, 116, 114, 111, 115, 107, 97}, "mkv"),
    MOV("MOV Video File", new byte[]{109, 111, 111, 118}, "mov"),
    MP3("MP3 Audio File", new byte[]{73, 68, 51}, "mp3"),
    MP4("MPEG4 Video File", 4, new byte[]{102, 116, 121, 112}, "mp4", "m4a", "m4v"),
    MPG("MPEG File", new byte[]{0, 0, 1, -70}, "mpg", "mpeg", "vob"),
    MSG("Outlook Message File", new byte[]{-48, -49, 17, -32, -95, -79, 26, -31}, "msg"),
    MSI("Microsoft Installer File", new byte[]{-48, -49, 17, -32, -95, -79, 26, -31}, "msi"),
    MTX("Matrix Data Format", "mtx"),
    NET("Net Files", "net"),
    OGG("Ogg Vorbis Codec Compressed Multimedia File", new byte[]{76, 1}, "ogg", "oga", "ogv", "ogx"),
    OBJ("Object Code File", new byte[]{76, 1}, "obj"),
    PDF("PDF File", new byte[]{37, 80, 68, 70}, "pdf"),
    PHP("PHP File", "php"),
    PLT("GnuPlot File", "plt"),
    PNG("PNG Image File", new byte[]{-119, 80, 78, 71}, "png"),
    PPM("Portable Pixmap Image File", new byte[]{80, 54}, "ppm"),
    PPT("Microsoft PowerPoint Document", new byte[]{-48, -49, 17, -32, -95, -79, 26, -31}, "ppt"),
    PPTX("Microsoft PowerPoint 2010 Document", new byte[]{80, 75, 3, 4}, "pptx"),
    PS("PostScript File", new byte[]{37, 33}, "ps"),
    PSD("Photoshop Image File", new byte[]{56, 66, 80, 83}, "psd"),
    PST("Outlook Post Office File", new byte[]{33, 66, 68, 78, 66}, "pst"),
    R("Matlab R File", "r"),
    RAR("RAR Compressed File", new byte[]{82, 97, 114, 33, 26, 7}, "rar"),
    RPM("RedHat Package Manager File", new byte[]{-19, -85, -18, -37}, "rpm"),
    RSS("RSS Feed", "rss", "rdf", "xml"),
    RTF("RTF Document File", new byte[]{123, 92, 114, 116, 102, 49}, "rtf"),
    SAV("SPSS Data File", new byte[]{36, 70, 76, 50, 64, 40, 35, 41, 32, 83, 80, 83, 83, 32, 68, 65, 84, 65, 32, 70, 73, 76, 69}, "sav"),
    SER("Serialized Data Files", "ser", "obj", "dat"),
    SLN("Visual Studio File", new byte[]{77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 86, 105, 115, 117, 97, 108, 32, 83, 116, 117, 100, 105, 111, 32, 83, 111, 108, 117, 116, 105, 111, 110, 32, 70, 105, 108, 101}, "sln"),
    SPARSECSV("Sparse CSV File", "csv"),
    SQL("SQL File", "sql"),
    SWF("Flash Shockwave File", new byte[]{70, 87, 83}, "swf"),
    SYS("SYS File", new byte[]{77, 90}, "sys"),
    TAR("Tar File", new byte[]{117, 115, 116, 97, 114}, "tar"),
    TEX("Latex Files", "tex"),
    TIF("TIF Image File", new byte[]{73, 73}, "tif", "tiff"),
    TTF("True Type Font File", new byte[]{0, 1, 0, 0, 0}, "ttf"),
    TXT("Text File", "txt"),
    VCF("vCard File", new byte[]{66, 69, 71, 73, 78, 58, 86, 67, 65, 82, 68, 13, 10}, "vcf"),
    VMDK("VMWare Disk File", new byte[]{75, 68, 77, 86}, "vmdk"),
    VSD("Visio Document", new byte[]{-48, -49, 17, -32, -95, -79, 26, -31}, "vsd"),
    WAV("Wave Audio File", 8, new byte[]{87, 65, 86, 69, 102, 109, 116, 32}, "wav"),
    WMA("Windows Audio File", new byte[]{48, 38, -78, 117, -114, 102, -49}, "wma"),
    WMF("Windows Meta File", new byte[]{-41, -51, -58, -102}, "wmf"),
    WMV("Windows Video File", new byte[]{48, 38, -78, 117, -114, 102, -49}, "wmv"),
    XCF("Gimp Image File", new byte[]{103, 105, 109, 112, 32, 120, 99, 102, 32, 118}, "xcf"),
    XLS("Microsoft Excel File", new byte[]{-48, -49, 17, -32, -95, -79, 26, -31}, "xls"),
    XLSX("Microsoft Excel 2010 File", new byte[]{80, 75, 3, 4}, "xlsx"),
    XML("XML File", new byte[]{60, 120, 109, 108}, "xml"),
    Z("Compress File", new byte[]{31, -99}, "z"),
    Z7("7-Zip File", new byte[]{55, 122, -68, -81, 39, 28}, "7z"),
    ZIP("PKZip File", new byte[]{80, 75, 3, 4}, "zip"),
    ZLIB("Zlib File", new byte[]{120, -100}, "zlib"),
    ZOO("ZOO Compressed File", new byte[]{90, 79, 79, 32}, "zoo");

    private final String[] extensions;
    private final String description;
    private final byte[] magicBytes;
    private final int offset;
    private static int maxMagicByteLength;
    private static final Object lock;
    private FileFilter fileFilter = null;

    private FileFormat(String description, byte[] magicBytes, String ... extensions) {
        this(description, 0, magicBytes, extensions);
    }

    private FileFormat(String description, String ... extensions) {
        this(description, 0, new byte[0], extensions);
    }

    private FileFormat(String description, int offset, byte[] magicBytes, String ... extensions) {
        this.extensions = extensions;
        this.offset = offset;
        this.magicBytes = magicBytes;
        this.description = description;
        this.fileFilter = new UJMPFileFilter(this.getDescription(), this.getExtensions());
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public String getDescription() {
        return this.description;
    }

    public static FileFormat guess(String filename) {
        filename = filename.toLowerCase();
        for (FileFormat f : FileFormat.values()) {
            for (String e : f.getExtensions()) {
                if (!filename.endsWith("." + e)) continue;
                return f;
            }
        }
        return UNKNOWN;
    }

    public static FileFormat guess(File file) throws IOException {
        if (file == null || !file.isFile() || !file.canRead()) {
            return UNKNOWN;
        }
        FileFormat format = FileFormat.guess(file.getName());
        if (format != UNKNOWN) {
            return format;
        }
        FileInputStream is = new FileInputStream(file);
        format = FileFormat.guess(is);
        ((InputStream)is).close();
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxMagicByteLength() {
        if (maxMagicByteLength == 0) {
            Object object = lock;
            synchronized (object) {
                if (maxMagicByteLength == 0) {
                    for (FileFormat f : FileFormat.values()) {
                        if (maxMagicByteLength >= f.getMagicBytes().length) continue;
                        maxMagicByteLength = f.getMagicBytes().length;
                    }
                }
            }
        }
        return maxMagicByteLength;
    }

    private int getOffset() {
        return this.offset;
    }

    private byte[] getMagicBytes() {
        return this.magicBytes;
    }

    public static boolean isImage(FileFormat fileformat) {
        switch (fileformat) {
            case BMP: {
                return true;
            }
            case GIF: {
                return true;
            }
            case JPG: {
                return true;
            }
            case JPEG2000: {
                return true;
            }
            case ICO: {
                return true;
            }
            case PNG: {
                return true;
            }
            case TIF: {
                return true;
            }
            case XCF: {
                return true;
            }
            case PSD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCompressed(FileFormat fileformat) {
        switch (fileformat) {
            case GZ: {
                return true;
            }
            case Z: {
                return true;
            }
            case Z7: {
                return true;
            }
            case ZIP: {
                return true;
            }
            case ZLIB: {
                return true;
            }
            case ZOO: {
                return true;
            }
            case ARC: {
                return true;
            }
            case ARJ: {
                return true;
            }
            case RAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isText(FileFormat fileformat) {
        switch (fileformat) {
            case C: {
                return true;
            }
            case CS: {
                return true;
            }
            case CSV: {
                return true;
            }
            case GRAPHML: {
                return true;
            }
            case HTML: {
                return true;
            }
            case JAVA: {
                return true;
            }
            case LOG: {
                return true;
            }
            case M: {
                return true;
            }
            case NET: {
                return true;
            }
            case PHP: {
                return true;
            }
            case PLT: {
                return true;
            }
            case R: {
                return true;
            }
            case SQL: {
                return true;
            }
            case TEX: {
                return true;
            }
            case TXT: {
                return true;
            }
            case XML: {
                return true;
            }
        }
        return false;
    }

    public static FileFormat guess(byte[] data) {
        for (FileFormat f : FileFormat.values()) {
            int offset;
            byte[] magic = f.getMagicBytes();
            if (magic.length == 0 || (offset = f.getOffset()) + magic.length > data.length) continue;
            int len = magic.length;
            boolean match = true;
            for (int i = 0; i < len; ++i) {
                if (data[offset + i] == magic[i]) continue;
                match = false;
            }
            if (!match) continue;
            return f;
        }
        return UNKNOWN;
    }

    public static FileFormat guess(InputStream is) throws IOException {
        byte[] data = new byte[FileFormat.getMaxMagicByteLength()];
        is.read(data);
        return FileFormat.guess(data);
    }

    static {
        maxMagicByteLength = 0;
        lock = new Object();
    }
}

