/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.exporter;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.export.exporter.AbstractMatrixWriterExporter;
import org.ujmp.core.export.format.MatrixHtmlExportFormat;
import org.ujmp.core.util.ColorUtil;

public class DefaultMatrixWriterHtmlExporter
extends AbstractMatrixWriterExporter
implements MatrixHtmlExportFormat {
    public DefaultMatrixWriterHtmlExporter(Matrix matrix, Writer writer) {
        super(matrix, writer);
    }

    @Override
    public void asHtml() throws IOException {
        String EOL = System.getProperty("line.separator");
        Writer writer = this.getWriter();
        Matrix matrix = this.getMatrix();
        long rowCount = matrix.getRowCount();
        long colCount = matrix.getColumnCount();
        writer.write("<div class=\"table-reponsive\" style=\"overflow-x: scroll;\">" + EOL);
        writer.write("<table class=\"table table-bordered\">" + EOL);
        if (matrix.getMetaData() != null) {
            writer.write("<thead>" + EOL);
            writer.write("<tr>" + EOL);
            writer.write("<th>" + EOL);
            if (matrix.getLabelObject() != null) {
                writer.write(String.valueOf(matrix.getLabelObject()));
            }
            writer.write("</th>" + EOL);
            for (long c = 0L; c < matrix.getColumnCount(); ++c) {
                writer.write("<th>");
                writer.write(matrix.getColumnLabel(c));
                writer.write("</th>" + EOL);
            }
            writer.write("</tr>" + EOL);
            writer.write("</thead>" + EOL);
        }
        writer.write("<tbody>" + EOL);
        int row = 0;
        while ((long)row < rowCount) {
            writer.write("<tr>" + EOL);
            if (matrix.getMetaData() != null) {
                writer.write("<th>");
                writer.write(matrix.getRowLabel(row));
                writer.write("</th>" + EOL);
            }
            int col = 0;
            while ((long)col < colCount) {
                Object o = matrix.getAsObject(row, col);
                Color bg = ColorUtil.fromObject(o);
                Color fg = ColorUtil.contrastBW(bg);
                writer.write("<td class=\"text-right\" style=\"color:" + ColorUtil.toHtmlColor(fg) + ";background:" + ColorUtil.toHtmlColor(bg) + "\">");
                writer.write(matrix.getAsString(row, col));
                writer.write("</td>" + EOL);
                ++col;
            }
            writer.write("</tr>" + EOL);
            ++row;
        }
        writer.write("</tbody>" + EOL);
        writer.write("</table>" + EOL);
        writer.write("</div>" + EOL);
    }
}

