/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.util.Iterator;
import org.ujmp.core.doublematrix.impl.DefaultSparseRowDoubleMatrix2D;

class NonZeroIterator
implements Iterator<long[]> {
    private final DefaultSparseRowDoubleMatrix2D matrix;
    private final long[] coordinates = new long[]{-1L, -1L};
    private final Iterator<Long> rowIterator;
    private Iterator<long[]> columnIterator;
    private long currentRow;

    public NonZeroIterator(DefaultSparseRowDoubleMatrix2D matrix) {
        this.matrix = matrix;
        this.rowIterator = matrix.rows.keySet().iterator();
        while (this.rowIterator.hasNext() && (this.columnIterator == null || !this.columnIterator.hasNext())) {
            this.currentRow = this.rowIterator.next();
            this.columnIterator = matrix.rows.get(this.currentRow).availableCoordinates().iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.columnIterator != null && this.columnIterator.hasNext();
    }

    @Override
    public long[] next() {
        long[] rowCoordinates = this.columnIterator.next();
        this.coordinates[0] = this.currentRow;
        this.coordinates[1] = rowCoordinates[0];
        if (!this.columnIterator.hasNext()) {
            while (this.rowIterator.hasNext() && (this.columnIterator == null || !this.columnIterator.hasNext())) {
                this.currentRow = this.rowIterator.next();
                this.columnIterator = this.matrix.rows.get(this.currentRow).availableCoordinates().iterator();
            }
        }
        return this.coordinates;
    }

    @Override
    public void remove() {
        throw new RuntimeException("cannot modify matrix");
    }
}

