/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Var;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;

public class Std
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 6318655294298955306L;
    private Matrix variance = null;
    private boolean ignoreNaN = false;
    private boolean besselsCorrection = true;

    public Std(int dimension, boolean ignoreNaN, Matrix matrix, boolean besselsCorrection) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
        this.besselsCorrection = besselsCorrection;
        MapMatrix<String, Object> aold = matrix.getMetaData();
        if (aold != null) {
            DefaultMapMatrix<String, Object> a = new DefaultMapMatrix<String, Object>();
            a.put("Label", aold.get("Label"));
            if (dimension == 0 || dimension == 1) {
                // empty if block
            }
            this.setMetaData(a);
        }
    }

    @Override
    public double getDouble(long ... coordinates) {
        if (this.variance == null) {
            this.variance = new Var(this.getDimension(), this.ignoreNaN, this.getSource(), this.besselsCorrection).calcNew();
        }
        return Math.sqrt(this.variance.getAsDouble(coordinates));
    }

    @Override
    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }
}

