/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.util.MathUtil;

public class Cumprod
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -3784193604269223968L;
    private Matrix cumprod = null;
    private boolean ignoreNaN = true;

    public Cumprod(Matrix m, boolean ignoreNaN) {
        super(m);
        this.ignoreNaN = ignoreNaN;
    }

    @Override
    public double getDouble(long ... coordinates) {
        if (this.cumprod == null) {
            this.createMatrix();
        }
        return this.cumprod.getAsDouble(coordinates);
    }

    private void createMatrix() {
        Matrix source = this.getSource();
        DenseMatrix m = Matrix.Factory.zeros(source.getSize());
        for (long c = 0L; c < source.getColumnCount(); ++c) {
            double prod = 1.0;
            long r = 0L;
            while (r < source.getRowCount()) {
                double v = source.getAsDouble(r, c);
                if (this.ignoreNaN || !MathUtil.isNaNOrInfinite(v)) {
                    prod *= v;
                }
                m.setAsDouble(prod, r++, c);
            }
        }
        this.cumprod = m;
    }
}

