/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import java.util.Arrays;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.SparseDoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.util.MathUtil;

public class AddMissing
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8211102877475985639L;
    private double[] percentMissing = null;
    private Matrix missingValues = null;

    public AddMissing(int dimension, Matrix source, double ... percentMissing) {
        super(dimension, source);
        if (percentMissing.length == 1 && dimension != Integer.MAX_VALUE) {
            this.percentMissing = new double[(int)this.getSource().getSize(dimension)];
            Arrays.fill(this.percentMissing, percentMissing[0]);
        } else {
            this.percentMissing = percentMissing;
        }
    }

    @Override
    public double getDouble(long ... coordinates) {
        if (this.missingValues == null) {
            this.missingValues = SparseDoubleMatrix2D.Factory.zeros(this.getSource().getRowCount(), this.getSource().getColumnCount());
            switch (this.getDimension()) {
                case 0x7FFFFFFF: {
                    int count = (int)(this.percentMissing[0] * (double)Coordinates.product(this.getSource().getSize()));
                    for (int i = 0; i < count; ++i) {
                        double v = 0.0;
                        int r = 0;
                        int c = 0;
                        do {
                            r = MathUtil.nextInteger(0, (int)this.getSource().getRowCount());
                            c = MathUtil.nextInteger(0, (int)this.getSource().getColumnCount());
                        } while (MathUtil.isNaNOrInfinite(v = this.missingValues.getAsDouble(r, c)));
                        this.missingValues.setAsDouble(Double.NaN, r, c);
                    }
                    break;
                }
                case 1: {
                    int missingCount = (int)((double)this.getSource().getColumnCount() * this.percentMissing[0]);
                    for (long r = this.getSource().getRowCount() - 1L; r != -1L; --r) {
                        for (int i = 0; i < missingCount; ++i) {
                            double v = 0.0;
                            int c = 0;
                            do {
                                c = MathUtil.nextInteger(0, (int)this.getSource().getColumnCount());
                            } while (MathUtil.isNaNOrInfinite(v = this.missingValues.getAsDouble(r, c)));
                            this.missingValues.setAsDouble(Double.NaN, r, c);
                        }
                    }
                    break;
                }
            }
        }
        if (MathUtil.isNaNOrInfinite(this.missingValues.getAsDouble(coordinates))) {
            return Double.NaN;
        }
        return this.getSource().getAsDouble(coordinates);
    }
}

