/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Max;
import org.ujmp.core.doublematrix.calculation.general.statistical.Min;

public class Normalize
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -1898669824045141350L;
    private Matrix ret = null;

    public Normalize(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    @Override
    public double getDouble(long ... coordinates) {
        if (this.ret == null) {
            Matrix max = new Max(this.getDimension(), this.getSource()).calcNew();
            Matrix min = new Min(this.getDimension(), this.getSource()).calcNew();
            Matrix range = max.minus(min);
            Matrix diff = null;
            switch (this.getDimension()) {
                case 0: {
                    diff = this.getSource().minus(Matrix.Factory.vertCat(min, this.getSource().getRowCount()));
                    break;
                }
                case 1: {
                    diff = this.getSource().minus(Matrix.Factory.horCat(min, this.getSource().getColumnCount()));
                    break;
                }
                default: {
                    diff = this.getSource().minus(min);
                }
            }
            switch (this.getDimension()) {
                case 0: {
                    this.ret = diff.divide(Matrix.Factory.vertCat(range, this.getSource().getRowCount()));
                    break;
                }
                case 1: {
                    this.ret = diff.divide(Matrix.Factory.horCat(range, this.getSource().getColumnCount()));
                    break;
                }
                default: {
                    this.ret = diff.divide(range);
                }
            }
        }
        return this.ret.getAsDouble(coordinates);
    }
}

