/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.util.UJMPSettings;

public class Pinv
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 7886298456216056038L;
    private Matrix pinv = null;

    public Pinv(Matrix matrix) {
        super(matrix);
    }

    @Override
    public double getDouble(long ... coordinates) {
        if (this.pinv == null) {
            Matrix[] usv = this.getSource().svd();
            Matrix u = usv[0];
            Matrix s = usv[1];
            Matrix v = usv[2];
            int i = (int)Math.min(s.getRowCount(), s.getColumnCount());
            while (--i >= 0) {
                long[] lArray = new long[]{i, i};
                double d = s.getAsDouble(lArray);
                if (Math.abs(d) > UJMPSettings.getInstance().getTolerance()) {
                    s.setAsDouble(1.0 / d, i, i);
                    continue;
                }
                s.setAsDouble(0.0, i, i);
            }
            this.pinv = v.mtimes(s.transpose()).mtimes(u.transpose());
        }
        return this.pinv.getAsDouble(coordinates);
    }

    @Override
    public long[] getSize() {
        return Coordinates.transpose(this.getSource().getSize());
    }
}

