/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

public interface LU<T> {
    public static final int THRESHOLD = 100;
    public static final LU<Matrix> MATRIX = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.solve(source, b);
                }
                return MATRIXSMALLSINGLETHREADED.solve(source, b);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.solve(source, b);
            }
            return MATRIXSMALLMULTITHREADED.solve(source, b);
        }
    };
    public static final LU<Matrix> INSTANCE = MATRIX;
    public static final LU<Matrix> UJMP = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            LUMatrix lu = new LUMatrix(source);
            return new Matrix[]{lu.getL(), lu.getU(), lu.getP()};
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            LUMatrix lu = new LUMatrix(source);
            return lu.solve(b);
        }
    };
    public static final LU<Matrix> MATRIXSMALLMULTITHREADED = UJMP;
    public static final LU<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final LU<Matrix> MATRIXLARGESINGLETHREADED = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            LU lu = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            LU<Matrix> lu = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null && UJMPSettings.getInstance().isUseOjalgo()) {
                lu = DecompositionOps.LU_OJALGO;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.solve(source, b);
        }
    };
    public static final LU<Matrix> MATRIXLARGEMULTITHREADED = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            LU<Matrix> lu = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null && UJMPSettings.getInstance().isUseOjalgo()) {
                lu = DecompositionOps.LU_OJALGO;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            LU<Matrix> lu = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null && UJMPSettings.getInstance().isUseOjalgo()) {
                lu = DecompositionOps.LU_OJALGO;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.solve(source, b);
        }
    };

    public T[] calc(T var1);

    public T solve(T var1, T var2);

    public static final class LUMatrix {
        private final double[][] LU;
        private final int m;
        private final int n;
        private int pivsign;
        private final int[] piv;

        public LUMatrix(Matrix A) {
            this.LU = A.toDoubleArray();
            this.m = (int)A.getRowCount();
            this.n = (int)A.getColumnCount();
            this.piv = new int[this.m];
            for (int i = 0; i < this.m; ++i) {
                this.piv[i] = i;
            }
            this.pivsign = 1;
            double[] LUcolj = new double[this.m];
            double[] LUrowi = null;
            for (int j = 0; j < this.n; ++j) {
                int i;
                int i2;
                for (i2 = 0; i2 < this.m; ++i2) {
                    LUcolj[i2] = this.LU[i2][j];
                }
                i2 = 0;
                while (i2 < this.m) {
                    LUrowi = this.LU[i2];
                    int kmax = Math.min(i2, j);
                    double s = 0.0;
                    for (int k = 0; k < kmax; ++k) {
                        s += LUrowi[k] * LUcolj[k];
                    }
                    int n = i2++;
                    double d = LUcolj[n] - s;
                    LUcolj[n] = d;
                    LUrowi[j] = d;
                }
                int p = j;
                for (i = j + 1; i < this.m; ++i) {
                    if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                    p = i;
                }
                if (p != j) {
                    int k;
                    for (k = 0; k < this.n; ++k) {
                        double t = this.LU[p][k];
                        this.LU[p][k] = this.LU[j][k];
                        this.LU[j][k] = t;
                    }
                    k = this.piv[p];
                    this.piv[p] = this.piv[j];
                    this.piv[j] = k;
                    this.pivsign = -this.pivsign;
                }
                if (j >= this.m || this.LU[j][j] == 0.0) continue;
                for (i = j + 1; i < this.m; ++i) {
                    double[] dArray = this.LU[i];
                    int n = j;
                    dArray[n] = dArray[n] / this.LU[j][j];
                }
            }
        }

        public final boolean isNonsingular() {
            for (int j = 0; j < this.n; ++j) {
                if (this.LU[j][j] != 0.0) continue;
                return false;
            }
            return true;
        }

        public final DenseDoubleMatrix2D getL() {
            int min = Math.min(this.m, this.n);
            double[][] L = new double[this.m][min];
            for (int i = 0; i < this.m; ++i) {
                for (int j = 0; j < min; ++j) {
                    if (i > j) {
                        L[i][j] = this.LU[i][j];
                        continue;
                    }
                    if (i != j) continue;
                    L[i][j] = 1.0;
                }
            }
            return Matrix.Factory.linkToArray(L);
        }

        public final DenseDoubleMatrix2D getU() {
            int min = Math.min(this.m, this.n);
            double[][] U = new double[min][this.n];
            for (int i = 0; i < min; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    if (i > j) continue;
                    U[i][j] = this.LU[i][j];
                }
            }
            return Matrix.Factory.linkToArray(U);
        }

        public final int[] getPivot() {
            int[] p = new int[this.m];
            for (int i = 0; i < this.m; ++i) {
                p[i] = this.piv[i];
            }
            return p;
        }

        public final Matrix getP() {
            DenseDoubleMatrix2D p = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros((long)this.m, (long)this.m);
            for (int i = 0; i < this.m; ++i) {
                p.setDouble(1.0, i, this.piv[i]);
            }
            return p;
        }

        public final double[] getDoublePivot() {
            double[] vals = new double[this.m];
            for (int i = 0; i < this.m; ++i) {
                vals[i] = this.piv[i];
            }
            return vals;
        }

        public final double det() {
            if (this.m != this.n) {
                throw new IllegalArgumentException("Matrix must be square.");
            }
            double d = this.pivsign;
            for (int j = 0; j < this.n; ++j) {
                d *= this.LU[j][j];
            }
            return d;
        }

        public final DenseDoubleMatrix2D solve(Matrix B) {
            int j;
            int i;
            int k;
            if (B.getRowCount() != (long)this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isNonsingular()) {
                throw new RuntimeException("Matrix is singular.");
            }
            int nx = (int)B.getColumnCount();
            double[][] X = new double[this.piv.length][(int)B.getColumnCount()];
            if (B instanceof DenseDoubleMatrix2D) {
                DenseDoubleMatrix2D m = (DenseDoubleMatrix2D)B;
                int c = (int)B.getColumnCount();
                while (--c >= 0) {
                    int r = this.piv.length;
                    while (--r >= 0) {
                        X[r][c] = m.getDouble(this.piv[r], c);
                    }
                }
            } else {
                int c = (int)B.getColumnCount();
                while (--c >= 0) {
                    int r = this.piv.length;
                    while (--r >= 0) {
                        X[r][c] = B.getAsDouble(this.piv[r], c);
                    }
                }
            }
            for (k = 0; k < this.n; ++k) {
                for (i = k + 1; i < this.n; ++i) {
                    for (j = 0; j < nx; ++j) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                    }
                }
            }
            for (k = this.n - 1; k >= 0; --k) {
                int j2 = 0;
                while (j2 < nx) {
                    double[] dArray = X[k];
                    int n = j2++;
                    dArray[n] = dArray[n] / this.LU[k][k];
                }
                for (i = 0; i < k; ++i) {
                    for (j = 0; j < nx; ++j) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                    }
                }
            }
            return Matrix.Factory.linkToArray(X);
        }
    }
}

