/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Chol;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Inv;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

public interface InvSPD<T>
extends Inv<T> {
    public static final int THRESHOLD = 100;
    public static final InvSPD<Matrix> MATRIX = new InvSPD<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            if (source.getDimensionCount() != 2 || source.getRowCount() != source.getColumnCount()) {
                throw new RuntimeException("inverse only possible for square matrices. use pinv or ginv instead");
            }
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }
    };
    public static final InvSPD<Matrix> UJMP = new InvSPD<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            DenseDoubleMatrix2D b = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(source.getRowCount(), source.getRowCount());
            int i = (int)source.getRowCount();
            while (--i >= 0) {
                b.setDouble(1.0, i, i);
            }
            return Chol.INSTANCE.solve(source, b);
        }
    };
    public static final InvSPD<Matrix> INSTANCE = MATRIX;
    public static final InvSPD<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final InvSPD<Matrix> MATRIXLARGESINGLETHREADED = new InvSPD<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            InvSPD<Matrix> inv = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                inv = DecompositionOps.INVSPD_JBLAS;
            }
            if (inv == null && UJMPSettings.getInstance().isUseEJML()) {
                inv = DecompositionOps.INVSPD_EJML;
            }
            if (inv == null && UJMPSettings.getInstance().isUseOjalgo()) {
                inv = DecompositionOps.INVSPD_OJALGO;
            }
            if (inv == null && UJMPSettings.getInstance().isUseMTJ()) {
                inv = DecompositionOps.INVSPD_MTJ;
            }
            if (inv == null) {
                inv = UJMP;
            }
            return inv.calc(source);
        }
    };
    public static final InvSPD<Matrix> MATRIXLARGEMULTITHREADED = new InvSPD<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            InvSPD<Matrix> inv = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                inv = DecompositionOps.INVSPD_JBLAS;
            }
            if (inv == null && UJMPSettings.getInstance().isUseOjalgo()) {
                inv = DecompositionOps.INVSPD_OJALGO;
            }
            if (inv == null && UJMPSettings.getInstance().isUseEJML()) {
                inv = DecompositionOps.INVSPD_EJML;
            }
            if (inv == null && UJMPSettings.getInstance().isUseParallelColt()) {
                inv = DecompositionOps.INVSPD_PARALLELCOLT;
            }
            if (inv == null && UJMPSettings.getInstance().isUseMTJ()) {
                inv = DecompositionOps.INVSPD_MTJ;
            }
            if (inv == null) {
                inv = UJMP;
            }
            return inv.calc(source);
        }
    };
    public static final InvSPD<Matrix> MATRIXSMALLMULTITHREADED = UJMP;

    @Override
    public T calc(T var1);
}

