/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.util.SerializationUtil;

public class SerializationMap<V extends Serializable>
extends AbstractMap<String, V> {
    private static final long serialVersionUID = -864310271863383588L;
    private final Map<String, byte[]> map;

    public SerializationMap(Map<String, byte[]> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V get(Object key) {
        try {
            byte[] data = this.map.get(key);
            return (V)(data == null ? null : (Serializable)SerializationUtil.deserialize(data));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(String key, V value) {
        try {
            Object oldValue = this.get(key);
            this.map.put(key, SerializationUtil.serialize(value));
            return (V)oldValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V remove(Object key) {
        Object oldValue = this.get(key);
        this.map.remove(key);
        return (V)oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

