/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.io.Flushable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.interfaces.Wrapper;

public class BufferedWriteMap<K, V>
extends AbstractMap<K, V>
implements Wrapper<Map<K, V>>,
Flushable {
    private static final long serialVersionUID = -5656442600680089505L;
    private Map<K, V> map = null;
    private Map<K, V> writeBuffer = Collections.synchronizedMap(new HashMap());

    public BufferedWriteMap(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public synchronized void clear() {
        this.writeBuffer.clear();
        this.map.clear();
    }

    @Override
    public synchronized V get(Object key) {
        V v = this.writeBuffer.get(key);
        if (v == null) {
            v = this.map.get(key);
        }
        return v;
    }

    @Override
    public synchronized Set<K> keySet() {
        HashSet<K> keySet = new HashSet<K>();
        keySet.addAll(this.writeBuffer.keySet());
        keySet.addAll(this.map.keySet());
        return keySet;
    }

    @Override
    public synchronized V put(K key, V value) {
        V oldValue = this.get((Object)key);
        this.writeBuffer.put(key, value);
        return oldValue;
    }

    @Override
    public synchronized V remove(Object key) {
        V oldValue = this.writeBuffer.remove(key);
        if (oldValue == null) {
            oldValue = this.map.remove(key);
        } else {
            this.map.remove(key);
        }
        return oldValue;
    }

    @Override
    public synchronized int size() {
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.map.size();
    }

    @Override
    public synchronized Map<K, V> getWrappedObject() {
        return this.map;
    }

    public synchronized void setWrappedObject(Map<K, V> object) {
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.map = object;
    }

    @Override
    public synchronized void flush() throws IOException {
    }
}

