/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.util.SerializationUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.io.FileUtil;

public abstract class AbstractDiskMap<K, V>
extends AbstractMap<K, V>
implements Erasable {
    private static final long serialVersionUID = -8615077389159395747L;
    private File path = null;
    private boolean useGZip = true;
    private int maxDepth = 10;

    public AbstractDiskMap(File path, boolean useGZip) throws IOException {
        this.useGZip = useGZip;
        this.path = path;
    }

    public final File getPath() {
        if (this.path == null) {
            try {
                this.path = File.createTempFile("diskmap" + System.nanoTime(), "");
                this.path.delete();
                if (!this.path.exists()) {
                    this.path.mkdirs();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.path;
    }

    @Override
    public final synchronized int size() {
        return FileUtil.countFiles(this.getPath());
    }

    private final File getFileNameForKey(Object o) throws IOException {
        String key;
        String suffix = ".dat";
        if (this.useGZip) {
            suffix = suffix + ".gz";
        }
        if (o instanceof String && StringUtil.isSuitedAsFilename((String)o) && !((String)o).contains(".")) {
            key = (String)o;
        } else {
            suffix = ".obj" + suffix;
            key = StringUtil.reverse(StringUtil.encodeToHex((Serializable)o));
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getPath().getAbsolutePath());
        result.append(File.separator);
        for (int i = 0; i < this.maxDepth && i < key.length() - 1; ++i) {
            char c = key.charAt(i);
            result.append(c);
            result.append(File.separator);
        }
        result.append(key);
        result.append(suffix);
        return new File(result.toString());
    }

    @Override
    public final synchronized V remove(Object key) {
        try {
            V v = this.get(key);
            File file = this.getFileNameForKey(key);
            if (file.exists()) {
                file.delete();
            }
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized boolean containsKey(Object key) {
        try {
            File file = this.getFileNameForKey(key);
            if (file == null) {
                return false;
            }
            return file.exists();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Set<K> keySet() {
        try {
            HashSet set = new HashSet();
            this.listFilesToSet(this.getPath(), set);
            return set;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void listFilesToSet(File path, Set<K> set) throws ClassNotFoundException, IOException {
        File[] files = path.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.listFilesToSet(f, set);
                    continue;
                }
                set.add(this.getKeyForFile(f));
            }
        }
    }

    private K getKeyForFile(File file) throws ClassNotFoundException, IOException {
        String filename = file.getName();
        if (filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        if (filename.endsWith(".dat")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        if (filename.endsWith(".obj")) {
            filename = filename.substring(0, filename.length() - 4);
            filename = StringUtil.reverse(filename);
            return (K)SerializationUtil.deserialize(StringUtil.decodeFromHex(filename));
        }
        return (K)filename;
    }

    @Override
    public final synchronized void clear() {
        try {
            this.erase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void erase() throws IOException {
        FileUtil.deleteRecursive(this.path);
    }

    public final void setPath(File path) {
        this.path = path;
    }

    @Override
    public final synchronized V put(K key, V value) {
        try {
            if (key == null) {
                return null;
            }
            File file = this.getFileNameForKey(key);
            if (value == null && file.exists()) {
                file.delete();
                return null;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fo = new FileOutputStream(file);
            FilterOutputStream bo = new BufferedOutputStream(fo);
            if (this.useGZip) {
                bo = new GZIPOutputStream((OutputStream)bo, 8192);
            }
            this.writeValue(bo, value);
            ((OutputStream)bo).close();
            fo.close();
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("could not put object " + key, e);
        }
    }

    @Override
    public final synchronized V get(Object key) {
        try {
            File file = this.getFileNameForKey(key);
            if (file == null || !file.exists()) {
                return null;
            }
            V o = null;
            FileInputStream fi = new FileInputStream(file);
            FilterInputStream bi = new BufferedInputStream(fi);
            if (this.useGZip) {
                bi = new GZIPInputStream((InputStream)bi, 8192);
            }
            o = this.readValue(bi);
            ((InputStream)bi).close();
            fi.close();
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("could not get object " + key, e);
        }
    }

    public abstract void writeValue(OutputStream var1, V var2);

    public abstract V readValue(InputStream var1);
}

