/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.composite;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import org.ujmp.core.collections.composite.ListSet;

public class SortedListSet<A>
extends AbstractList<A>
implements SortedSet<A>,
ListSet<A>,
Serializable {
    private static final long serialVersionUID = -9069699328418816771L;
    private final SortedSet<A> set = new TreeSet<A>();
    private final List<A> list = new ArrayList<A>();

    @Override
    public Comparator<? super A> comparator() {
        return this.set.comparator();
    }

    @Override
    public A first() {
        return this.set.first();
    }

    @Override
    public SortedSet<A> headSet(A toElement) {
        return this.set.headSet(toElement);
    }

    @Override
    public A last() {
        return this.set.last();
    }

    @Override
    public SortedSet<A> subSet(A fromElement, A toElement) {
        return this.set.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<A> tailSet(A fromElement) {
        return this.set.tailSet(fromElement);
    }

    @Override
    public synchronized boolean add(A e) {
        this.list.clear();
        return this.set.add(e);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends A> c) {
        this.list.clear();
        return this.set.addAll(c);
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<A> iterator() {
        return this.set.iterator();
    }

    @Override
    public synchronized boolean remove(Object o) {
        this.list.clear();
        return this.set.remove(o);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        this.list.clear();
        return this.set.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        this.list.clear();
        return this.set.retainAll(c);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public void add(int index, A element) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean addAll(int index, Collection<? extends A> c) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public synchronized A get(int index) {
        this.createList();
        return this.list.get(index);
    }

    @Override
    public synchronized int indexOf(Object o) {
        this.createList();
        return this.list.indexOf(o);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        this.createList();
        return this.list.lastIndexOf(o);
    }

    @Override
    public synchronized ListIterator<A> listIterator() {
        this.createList();
        return this.list.listIterator();
    }

    @Override
    public synchronized ListIterator<A> listIterator(int index) {
        this.createList();
        return this.list.listIterator(index);
    }

    @Override
    public synchronized A remove(int index) {
        this.createList();
        A o = this.list.remove(index);
        this.list.clear();
        this.set.remove(o);
        return o;
    }

    @Override
    public A set(int index, A element) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public synchronized List<A> subList(int fromIndex, int toIndex) {
        this.createList();
        return this.list.subList(fromIndex, toIndex);
    }

    private void createList() {
        if (this.list.size() != this.set.size()) {
            this.list.clear();
            this.list.addAll(this.set);
        }
    }

    @Override
    public Spliterator<A> spliterator() {
        return ListSet.super.spliterator();
    }
}

