/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.PlusMatrixCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

class PlusMatrixSparseMatrix
implements PlusMatrixCalculation<SparseMatrix, SparseMatrix, SparseMatrix> {
    PlusMatrixSparseMatrix() {
    }

    @Override
    public final void calc(SparseMatrix source1, SparseMatrix source2, SparseMatrix target) {
        MapMatrix<String, Object> a;
        VerifyUtil.verifySameSize(source1, source2, target);
        for (long[] c : source1.availableCoordinates()) {
            BigDecimal svalue = source1.getAsBigDecimal(c);
            target.setAsBigDecimal(svalue, c);
        }
        for (long[] c : source2.availableCoordinates()) {
            BigDecimal v1 = target.getAsBigDecimal(c);
            BigDecimal v2 = source2.getAsBigDecimal(c);
            BigDecimal result = MathUtil.plus(v1, v2);
            target.setAsBigDecimal(result, c);
        }
        if (source1 != target && (a = source1.getMetaData()) != null) {
            target.setMetaData((MapMatrix<String, Object>)a.clone());
        }
    }
}

