/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bytematrix.stub;

import org.ujmp.core.bytematrix.ByteMatrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.genericmatrix.stub.AbstractGenericMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

public abstract class AbstractByteMatrix
extends AbstractGenericMatrix<Byte>
implements ByteMatrix {
    private static final long serialVersionUID = 701344082157040644L;

    public AbstractByteMatrix(long ... size) {
        super(size);
    }

    @Override
    public final Byte getObject(long ... coordinates) {
        return this.getByte(coordinates);
    }

    @Override
    public final void setObject(Byte o, long ... coordinates) {
        this.setByte(o, coordinates);
    }

    @Override
    public final byte getAsByte(long ... coordinates) {
        return this.getByte(coordinates);
    }

    @Override
    public final void setAsByte(byte value, long ... coordinates) {
        this.setByte(value, coordinates);
    }

    @Override
    public final double getAsDouble(long ... coordinates) {
        return this.getByte(coordinates);
    }

    @Override
    public final void setAsDouble(double value, long ... coordinates) {
        VerifyUtil.verifyTrue(!MathUtil.isNaNOrInfinite(value), "Nan, Inf and -Inf not allowed in this matrix");
        this.setByte((byte)value, coordinates);
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.BYTE;
    }
}

