/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.booleanmatrix.stub;

import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.genericmatrix.stub.AbstractGenericMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

public abstract class AbstractBooleanMatrix
extends AbstractGenericMatrix<Boolean>
implements BooleanMatrix {
    private static final long serialVersionUID = -6190735100426536876L;

    public AbstractBooleanMatrix(long ... size) {
        super(size);
    }

    @Override
    public final Boolean getObject(long ... coordinates) {
        return this.getBoolean(coordinates);
    }

    @Override
    public final void setObject(Boolean o, long ... coordinates) {
        this.setBoolean(o, coordinates);
    }

    @Override
    public final boolean getAsBoolean(long ... coordinates) {
        return this.getBoolean(coordinates);
    }

    @Override
    public final void setAsBoolean(boolean value, long ... coordinates) {
        this.setBoolean(value, coordinates);
    }

    @Override
    public final double getAsDouble(long ... coordinates) {
        return this.getBoolean(coordinates) ? 1.0 : 0.0;
    }

    @Override
    public final void setAsDouble(double value, long ... coordinates) {
        VerifyUtil.verifyTrue(!MathUtil.isNaNOrInfinite(value), "Nan, Inf and -Inf not allowed in this matrix");
        this.setBoolean(value != 0.0, coordinates);
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.BOOLEAN;
    }
}

