/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.AbstractBenchmarkTask;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkResult;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.util.SerializationUtil;

public class SolveSquareBenchmarkTask
extends AbstractBenchmarkTask {
    public SolveSquareBenchmarkTask(long benchmarkSeed, Class<? extends DoubleMatrix2D> matrixClass, BenchmarkConfig config) {
        super(benchmarkSeed, matrixClass, config.getSolveSquareSizes(), config);
    }

    @Override
    public BenchmarkResult task(Class<? extends Matrix> matrixClass, long benchmarkSeed, int run, long[] size) {
        Matrix b1 = null;
        DoubleMatrix2D b2 = null;
        Matrix result = null;
        try {
            DoubleMatrix2D a = BenchmarkUtil.createMatrix(matrixClass, size);
            if (!a.getClass().getName().startsWith("org.ujmp.core.") && a.getClass().getDeclaredMethod("solve", Matrix.class) == null) {
                System.out.print("-");
                System.out.flush();
                return BenchmarkResult.NOTAVAILABLE;
            }
            DoubleMatrix2D x = (DoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(size[1], size[0]);
            BenchmarkUtil.rand(benchmarkSeed, run, 0, a);
            BenchmarkUtil.rand(benchmarkSeed, run, 1, x);
            b1 = new DefaultDenseDoubleMatrix2D(a).mtimes(new DefaultDenseDoubleMatrix2D(x));
            b2 = BenchmarkUtil.createMatrix(matrixClass, b1);
            BenchmarkUtil.purgeMemory(this.getConfig());
            long m0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long t0 = System.nanoTime();
            result = a.solve(b2);
            long t1 = System.nanoTime();
            long m1 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (result == null) {
                System.out.print("e");
                System.out.flush();
                return BenchmarkResult.ERROR;
            }
            double diff = BenchmarkUtil.difference(result, x);
            result = null;
            long mem = m1 - m0 - SerializationUtil.sizeOf(result);
            mem = mem > 0L ? mem : 0L;
            return new BenchmarkResult((double)(t1 - t0) / 1000000.0, diff, mem);
        }
        catch (Throwable e) {
            System.out.print("e");
            System.out.flush();
            return BenchmarkResult.ERROR;
        }
    }

    @Override
    public String getTaskName() {
        return "solveSquare";
    }
}

