/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.symbolic;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IMutateable;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.symbolic.OrD;
import org.jgap.symbolic.XorD;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class AndD
extends MathCommand
implements IMutateable,
ICloneable {
    public AndD(GPConfiguration a_conf) throws InvalidConfigurationException {
        this(a_conf, CommandGene.DoubleClass);
    }

    public AndD(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType);
    }

    @Override
    public CommandGene applyMutation(int index, double a_percentage) throws InvalidConfigurationException {
        MathCommand mutant = a_percentage < 0.5 ? new XorD(this.getGPConfiguration()) : new OrD(this.getGPConfiguration());
        return mutant;
    }

    @Override
    public Object clone() {
        try {
            AndD result = new AndD(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    @Override
    public String toString() {
        return "&1 && &2";
    }

    @Override
    public String getName() {
        return "AndD";
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double d1 = c.execute_double(n, 0, args);
        double d2 = c.execute_double(n, 1, args);
        boolean b1 = true;
        boolean b2 = true;
        if (d1 < 1.0) {
            b1 = false;
        }
        if (d2 < 1.0) {
            b2 = false;
        }
        if (b1 & b2) {
            return 1.0;
        }
        return 0.0;
    }
}

