/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl.job;

import org.jgap.Population;
import org.jgap.impl.job.IPopulationSplitter;

public class SimplePopulationSplitter
implements IPopulationSplitter {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private int m_count;

    public SimplePopulationSplitter(int a_count) {
        if (a_count < 1) {
            throw new IllegalArgumentException("Count must be greater than zero!");
        }
        this.m_count = a_count;
    }

    @Override
    public Population[] split(Population a_pop) throws Exception {
        int count;
        int popSize = a_pop.size();
        int chunkSize = popSize / (count = this.m_count);
        if (chunkSize < 1) {
            chunkSize = 1;
            count = 1;
        }
        Population[] result = new Population[count];
        int index = 0;
        for (int i = 0; i < count; ++i) {
            Population chunk = new Population(a_pop.getConfiguration(), chunkSize);
            for (int j = 0; j < chunkSize; ++j) {
                chunk.addChromosome(a_pop.getChromosome(index));
                ++index;
            }
            result[i] = chunk;
            if ((popSize -= chunkSize) < 1) break;
            if (popSize >= chunkSize) continue;
            chunkSize = popSize;
        }
        return result;
    }
}

