/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr.grid;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.server.GridServer;
import org.jgap.distr.grid.JGAPClientHandlerThread;

public class JGAPServer {
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private static final String className = JGAPServer.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private GridServer m_gs = new GridServer(JGAPClientHandlerThread.class);

    public JGAPServer(String[] args) throws Exception {
        Options options = new Options();
        CommandLine cmd = MainCmd.parseCommonOptions(options, this.m_gs.getNodeConfig(), args);
        this.m_gs.start();
    }

    public void addFile(String a_filename) throws Exception {
        String path = this.m_gs.getVFSSessionPool().getPath();
        if (path == null) {
            return;
        }
        if (path.charAt(path.length() - 1) != '\\') {
            path = path + "\\";
        }
        JGAPServer.copyFile(a_filename, path);
    }

    public static void copyFile(String source, String dest) throws Exception {
        int c;
        File destFile = new File(dest);
        if (!destFile.isFile()) {
            String origFilename = new File(source).getName();
            dest = dest + origFilename;
        }
        File inputFile = new File(source);
        File outputFile = new File(dest);
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static void main(String[] args) throws Exception {
        MainCmd.setUpLog4J("server", true);
        new JGAPServer(args);
    }
}

