/*
 * Decompiled with CFR 0.152.
 */
package smile.symbolic.internal;

import smile.symbolic.internal.BinaryNode;
import smile.symbolic.internal.Constant;
import smile.symbolic.internal.Expression;

public class Sum
extends BinaryNode {
    public Sum(Expression left, Expression right) {
        super(left, right, Expression.BinaryOperator.PLUS);
    }

    @Override
    public Expression derive() {
        return new Sum(this.left.derive(), this.right.derive());
    }

    @Override
    public Expression reduce() {
        Expression l = this.left.reduce();
        Expression r = this.right.reduce();
        if (l instanceof Constant || r instanceof Constant) {
            if (l.getType().equals("0")) {
                return r;
            }
            if (r.getType().equals("0")) {
                return l;
            }
        }
        return new Sum(l, r);
    }

    @Override
    public double getValue() {
        return 0.0;
    }
}

