/*
 * Decompiled with CFR 0.152.
 */
package smile.symbolic.internal;

import smile.symbolic.internal.BinaryNode;
import smile.symbolic.internal.Constant;
import smile.symbolic.internal.Difference;
import smile.symbolic.internal.Expression;
import smile.symbolic.internal.Product;

public class Exponent
extends BinaryNode {
    public Exponent(Expression left, Expression right) {
        super(left, right, Expression.BinaryOperator.POWER);
    }

    @Override
    public Expression derive() {
        if (this.left instanceof Constant) {
            return new Constant(0.0);
        }
        return new Product(this.right, new Product(this.left.derive(), new Exponent(this.left, new Difference(this.right, new Constant(1.0)))));
    }

    @Override
    public Expression reduce() {
        Expression l = this.left.reduce();
        Expression r = this.right.reduce();
        if (r instanceof Constant) {
            if (r.getValue() == 0.0) {
                return new Constant(1.0);
            }
            if (r.getValue() == 1.0) {
                return this.left;
            }
        }
        return new Exponent(l, r);
    }

    @Override
    public double getValue() {
        return 0.0;
    }
}

