/*
 * Decompiled with CFR 0.152.
 */
package smile.symbolic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import smile.symbolic.InvalidExpressionException;

public class ExpressionParser {
    private String expression;
    private String var;
    private ArrayList<String> tokens;

    public String getExpression() {
        return this.expression;
    }

    public String getVar() {
        return this.var;
    }

    public ArrayList<String> getTokens() {
        return this.tokens;
    }

    public static boolean isOperator(String str) {
        return str.matches("[+*/^-]");
    }

    public static boolean isOperand(String str, String var) {
        return str.matches("[0-9]+") || str.equals(var);
    }

    public static boolean isFunction(String str) {
        String[] funcs = new String[]{"sin", "cos", "tan", "csc", "sec", "cot", "log", "ln"};
        return Arrays.asList(funcs).contains(str);
    }

    public static int getPrecedence(String str) {
        if (ExpressionParser.isFunction(str)) {
            return 5;
        }
        int val = 0;
        if (str.equals("+")) {
            val = 2;
        } else if (str.equals("-")) {
            val = 2;
        } else if (str.equals("*") || str.equals("/")) {
            val = 3;
        } else if (str.equals("^") || str.equals("$")) {
            val = 4;
        }
        return val;
    }

    public static boolean isLeftAssociative(String s) {
        return !s.equals("^") && !s.equals("$") && !s.equals("+") && !s.equals("*");
    }

    public String format(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!s.substring(i, i + 1).equals("*") || i <= 0 || !ExpressionParser.isOperand(s.substring(i - 1, i), this.var) || i >= s.length() - 1 || !s.substring(i + 1, i + 2).equals(this.var)) continue;
            s = s.substring(0, i) + s.substring(i + 1);
        }
        return s;
    }

    public String parse(String expression) throws InvalidExpressionException {
        this.expression = expression;
        try {
            this.var = this.check();
        }
        catch (InvalidExpressionException e) {
            e.printStackTrace();
        }
        this.expression = this.formatString(expression);
        System.out.println(this.expression);
        this.tokens = this.tokenize(this.expression);
        return this.expression;
    }

    private String check() throws InvalidExpressionException {
        this.expression = this.expression.replaceAll("\\s", "");
        this.expression = this.expression.toLowerCase();
        String var = "";
        if (this.expression.length() == 0) {
            throw new InvalidExpressionException("Empty Expression");
        }
        if (!this.expression.matches("[a-zA-Z0-9+*/^()-]+")) {
            throw new InvalidExpressionException("Syntax Error");
        }
        if (this.expression.matches("[+*/^()-]+")) {
            throw new InvalidExpressionException("Syntax Error");
        }
        String firstChar = this.expression.substring(0, 1);
        String lastChar = this.expression.substring(this.expression.length() - 1, this.expression.length());
        if (!firstChar.equals("-") && ExpressionParser.isOperator(firstChar) || firstChar.equals(")") || ExpressionParser.isOperator(lastChar) || lastChar.equals("(")) {
            throw new InvalidExpressionException("Syntax Error");
        }
        for (int i = 0; i < this.expression.length(); ++i) {
            String temp = "";
            while (i < this.expression.length() && this.expression.substring(i, i + 1).matches("[a-zA-Z]")) {
                temp = temp + this.expression.substring(i, i + 1);
                ++i;
            }
            if (temp.length() == 1) {
                if (var.length() == 0) {
                    var = temp;
                }
                if (!temp.equals(var)) {
                    throw new InvalidExpressionException("For now, expression must contain a single variable");
                }
                if (i >= this.expression.length() || !this.expression.substring(i, i + 1).matches("[0-9]+")) continue;
                throw new InvalidExpressionException("Syntax Error");
            }
            if (ExpressionParser.isFunction(temp)) {
                if (i < this.expression.length()) {
                    if (this.expression.substring(i, i + 1).equals("(")) continue;
                    throw new InvalidExpressionException("Syntax Error");
                }
                throw new InvalidExpressionException("Syntax Error");
            }
            if (temp.length() == 0) continue;
            throw new InvalidExpressionException(temp + ": function not found");
        }
        int cntOpenParen = 0;
        int cntCloseParen = 0;
        for (int i = 0; i < this.expression.length() - 1; ++i) {
            String tmp1 = this.expression.substring(i, i + 1);
            String tmp2 = this.expression.substring(i + 1, i + 2);
            if (tmp1.equals("-")) {
                if (!ExpressionParser.isOperator(tmp2) && !tmp2.equals(")")) continue;
                throw new InvalidExpressionException("Syntax Error");
            }
            if (tmp2.equals("-")) {
                if (!tmp1.equals("(")) continue;
                throw new InvalidExpressionException("Syntax Error");
            }
            if ((ExpressionParser.isOperator(tmp1) || tmp1.equals("(")) && (ExpressionParser.isOperator(tmp2) || tmp2.equals(")"))) {
                throw new InvalidExpressionException("Syntax Error");
            }
            if (this.expression.substring(i, i + 1).equals("(")) {
                ++cntOpenParen;
                continue;
            }
            if (!this.expression.substring(i, i + 1).equals(")")) continue;
            ++cntCloseParen;
        }
        if (cntOpenParen < cntCloseParen) {
            throw new InvalidExpressionException("Syntax Error");
        }
        return var;
    }

    private String formatString(String exp) {
        int i;
        exp = exp.replaceAll("\\s", "");
        exp = exp.toLowerCase();
        int count = 0;
        if (exp.substring(0, 1).equals("-")) {
            exp = "$" + exp.substring(1);
        }
        for (i = 0; i < exp.length(); ++i) {
            if (exp.substring(i, i + 1).equals("(")) {
                ++count;
                continue;
            }
            if (!exp.substring(i, i + 1).equals(")")) continue;
            --count;
        }
        while (count > 0) {
            exp = exp + ")";
            --count;
        }
        for (i = 0; i < exp.length() - 1; ++i) {
            String tmp1 = exp.substring(i, i + 1);
            String tmp2 = exp.substring(i + 1, i + 2);
            if (tmp2.equals("-") && (ExpressionParser.isOperator(tmp1) || tmp1.equals("("))) {
                exp = exp.substring(0, i + 1) + "$" + exp.substring(i + 2);
                continue;
            }
            if (!tmp1.matches("[0-9]+") && !tmp1.equals(this.var) || !tmp2.equals("(") && !tmp2.equals(this.var)) continue;
            exp = exp.substring(0, i + 1) + "*" + exp.substring(i + 1);
        }
        return exp;
    }

    public ArrayList<String> tokenize(String exp) {
        ArrayList<String> tokens = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < exp.length(); ++i) {
            String token = "";
            if (ExpressionParser.isOperator(exp.substring(i, i + 1)) || exp.substring(i, i + 1).equals("$")) {
                token = exp.substring(i, i + 1);
                while (!stack.isEmpty() && (ExpressionParser.isOperator((String)stack.peek()) || ((String)stack.peek()).equals("$")) && (ExpressionParser.isLeftAssociative(token) && ExpressionParser.getPrecedence(token) <= ExpressionParser.getPrecedence((String)stack.peek()) || !ExpressionParser.isLeftAssociative(token) && ExpressionParser.getPrecedence(token) < ExpressionParser.getPrecedence((String)stack.peek()))) {
                    tokens.add((String)stack.pop());
                }
                stack.push(token);
                continue;
            }
            if (exp.substring(i, i + 1).equals(this.var)) {
                token = this.var;
                tokens.add(token);
                continue;
            }
            if (exp.substring(i, i + 1).equals("(")) {
                token = exp.substring(i, i + 1);
                stack.push(token);
                continue;
            }
            if (exp.substring(i, i + 1).equals(")")) {
                while (!stack.isEmpty() && !((String)stack.peek()).equals("(")) {
                    tokens.add((String)stack.pop());
                }
                if (!stack.isEmpty()) {
                    stack.pop();
                }
                if (stack.isEmpty() || !ExpressionParser.isFunction((String)stack.peek())) continue;
                tokens.add((String)stack.pop());
                continue;
            }
            if (exp.substring(i, i + 1).matches("[0-9]+")) {
                while (i < exp.length() && exp.substring(i, i + 1).matches("[0-9]+")) {
                    token = token + exp.substring(i, i + 1);
                    ++i;
                }
                tokens.add(token);
                --i;
                continue;
            }
            if (exp.substring(i, i + 1).equals(this.var)) {
                tokens.add(token);
                continue;
            }
            while (i < exp.length() && exp.substring(i, i + 1).matches("[a-zA-Z]+")) {
                token = token + exp.substring(i, i + 1);
                ++i;
            }
            if (token.length() == 0) continue;
            stack.push(token);
        }
        while (!stack.isEmpty()) {
            tokens.add((String)stack.pop());
        }
        System.out.println(tokens);
        return tokens;
    }
}

