/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.parser.ArffParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.math.kernel.PolynomialKernel;
import smile.regression.SVR;
import smile.validation.CrossValidation;

public class SVRTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCPU() {
        System.out.println("CPU");
        ArffParser parser = new ArffParser();
        parser.setResponseIndex(6);
        try {
            AttributeDataset data = parser.parse(IOUtils.getTestDataFile("weka/cpu.arff"));
            double[] datay = data.toArray(new double[data.size()]);
            double[][] datax = (double[][])data.toArray((E[])new double[data.size()][]);
            Math.standardize(datax);
            int n = datax.length;
            int k = 10;
            CrossValidation cv = new CrossValidation(n, k);
            double rss = 0.0;
            for (int i = 0; i < k; ++i) {
                double[][] trainx = (double[][])Math.slice(datax, cv.train[i]);
                double[] trainy = Math.slice(datay, cv.train[i]);
                double[][] testx = (double[][])Math.slice(datax, cv.test[i]);
                double[] testy = Math.slice(datay, cv.test[i]);
                SVR<double[]> svr = new SVR<double[]>((T[])trainx, trainy, new PolynomialKernel(3, 1.0, 1.0), 0.1, 1.0);
                for (int j = 0; j < testx.length; ++j) {
                    double r = testy[j] - svr.predict(testx[j]);
                    rss += r * r;
                }
            }
            System.out.println("10-CV RMSE = " + Math.sqrt(rss / (double)n));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

