/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;

public class Palette {
    public static final Color WHITE = Color.WHITE;
    public static final Color BLACK = Color.BLACK;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color SLATE_GRAY = new Color(7372944);
    public static final Color LIGHT_SLATE_GRAY = new Color(7175053);
    public static final Color DARK_SLATE_GRAY = new Color(0x2F4F4F);
    public static final Color RED = Color.RED;
    public static final Color DARK_RED = new Color(0x8B0000);
    public static final Color VIOLET_RED = new Color(16135562);
    public static final Color GREEN = Color.GREEN;
    public static final Color DARK_GREEN = new Color(25600);
    public static final Color LIGHT_GREEN = new Color(0x90EE90);
    public static final Color PASTEL_GREEN = new Color(65280);
    public static final Color FOREST_GREEN = new Color(0x808000);
    public static final Color GRASS_GREEN = new Color(0x408080);
    public static final Color BLUE = Color.BLUE;
    public static final Color NAVY_BLUE = new Color(128);
    public static final Color SLATE_BLUE = new Color(6970061);
    public static final Color ROYAL_BLUE = new Color(2842846);
    public static final Color CADET_BLUE = new Color(5011582);
    public static final Color MIDNIGHT_BLUE = new Color(1383252);
    public static final Color SKY_BLUE = new Color(6723839);
    public static final Color STEEL_BLUE = new Color(4744096);
    public static final Color DARK_BLUE = new Color(139);
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color DARK_MAGENTA = new Color(0x8B008B);
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_CYAN = new Color(35723);
    public static final Color PURPLE = new Color(10494192);
    public static final Color LIGHT_PURPLE = new Color(0xFF0080);
    public static final Color DARK_PURPLE = new Color(0x800080);
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color YELLOW = Color.YELLOW;
    public static final Color GOLD = new Color(16766720);
    public static final Color BROWN = new Color(0xA52A2A);
    public static final Color SALMON = new Color(16416882);
    public static final Color TURQUOISE = new Color(65535);
    public static final Color BURGUNDY = new Color(0x800000);
    public static final Color PLUM = new Color(12139407);
    public static final Color[] COLORS = new Color[]{RED, BLUE, GREEN, MAGENTA, CYAN, PURPLE, ORANGE, PINK, YELLOW, GOLD, BROWN, SALMON, TURQUOISE, BURGUNDY, PLUM, DARK_RED, VIOLET_RED, DARK_GREEN, LIGHT_GREEN, PASTEL_GREEN, FOREST_GREEN, GRASS_GREEN, NAVY_BLUE, SLATE_BLUE, ROYAL_BLUE, CADET_BLUE, MIDNIGHT_BLUE, SKY_BLUE, STEEL_BLUE, DARK_BLUE, DARK_MAGENTA, DARK_CYAN, LIGHT_PURPLE, DARK_PURPLE, LIGHT_GRAY, DARK_GRAY, SLATE_GRAY, LIGHT_SLATE_GRAY, DARK_SLATE_GRAY, BLACK};

    private Palette() {
    }

    public static Color[] terrain(int n) {
        return Palette.terrain(n, 1.0f);
    }

    public static Color[] terrain(int n, float alpha) {
        int i;
        int k = n / 2;
        float[] H = new float[]{0.33333334f, 0.16666667f, 0.0f};
        float[] S = new float[]{1.0f, 1.0f, 0.0f};
        float[] V = new float[]{0.65f, 0.9f, 0.95f};
        Color[] palette = new Color[n];
        float h = H[0];
        float hw = (H[1] - H[0]) / (float)(k - 1);
        float s = S[0];
        float sw = (S[1] - S[0]) / (float)(k - 1);
        float v = V[0];
        float vw = (V[1] - V[0]) / (float)(k - 1);
        for (i = 0; i < k; ++i) {
            palette[i] = Palette.hsv(h, s, v, alpha);
            h += hw;
            s += sw;
            v += vw;
        }
        h = H[1];
        hw = (H[2] - H[1]) / (float)(n - k);
        s = S[1];
        sw = (S[2] - S[1]) / (float)(n - k);
        v = V[1];
        vw = (V[2] - V[1]) / (float)(n - k);
        for (i = k; i < n; ++i) {
            palette[i] = Palette.hsv(h += hw, s += sw, v += vw, alpha);
        }
        return palette;
    }

    public static Color[] topo(int n) {
        return Palette.topo(n, 1.0f);
    }

    public static Color[] topo(int n, float alpha) {
        int l;
        int j = n / 3;
        int k = n / 3;
        int i = n - j - k;
        Color[] palette = new Color[n];
        float h = 0.71666664f;
        float hw = (0.51666665f - h) / (float)(i - 1);
        for (l = 0; l < i; ++l) {
            palette[l] = Palette.hsv(h, 1.0f, 1.0f, alpha);
            h += hw;
        }
        h = 0.38333333f;
        hw = (0.18333334f - h) / (float)(j - 1);
        while (l < i + j) {
            palette[l] = Palette.hsv(h, 1.0f, 1.0f, alpha);
            h += hw;
            ++l;
        }
        h = 0.16666667f;
        hw = (0.1f - h) / (float)(k - 1);
        float s = 1.0f;
        float sw = (0.3f - s) / (float)(k - 1);
        while (l < n) {
            palette[l] = Palette.hsv(h, s, 1.0f, alpha);
            h += hw;
            s += sw;
            ++l;
        }
        return palette;
    }

    public static Color[] jet(int n) {
        return Palette.jet(n, 1.0f);
    }

    public static Color[] jet(int n, float alpha) {
        int m = (int)Math.ceil(n / 4);
        float[] u = new float[3 * m];
        for (int i = 0; i < u.length; ++i) {
            u[i] = i == 0 ? 0.0f : (i <= m ? (float)i / (float)m : (i <= 2 * m - 1 ? 1.0f : (float)(3 * m - i) / (float)m));
        }
        int m2 = m / 2 + m % 2;
        int mod = n % 4;
        int[] r = new int[n];
        int[] g = new int[n];
        int[] b = new int[n];
        for (int i = 0; i < u.length - 1; ++i) {
            if (m2 - mod + i < n) {
                g[m2 - mod + i] = i + 1;
            }
            if (m2 - mod + i + m < n) {
                r[m2 - mod + i + m] = i + 1;
            }
            if (i <= 0 || m2 - mod + i >= u.length) continue;
            b[i] = m2 - mod + i;
        }
        Color[] palette = new Color[n];
        for (int i = 0; i < n; ++i) {
            palette[i] = new Color(u[r[i]], u[g[i]], u[b[i]], alpha);
        }
        return palette;
    }

    public static Color[] redgreen(int n) {
        return Palette.redgreen(n, 1.0f);
    }

    public static Color[] redgreen(int n, float alpha) {
        Color[] palette = new Color[n];
        for (int i = 0; i < n; ++i) {
            palette[i] = new Color((float)Math.sqrt(((float)i + 1.0f) / (float)n), (float)Math.sqrt(1.0f - ((float)i + 1.0f) / (float)n), 0.0f, alpha);
        }
        return palette;
    }

    public static Color[] redblue(int n) {
        return Palette.redblue(n, 1.0f);
    }

    public static Color[] redblue(int n, float alpha) {
        Color[] palette = new Color[n];
        for (int i = 0; i < n; ++i) {
            palette[i] = new Color((float)Math.sqrt(((float)i + 1.0f) / (float)n), 0.0f, (float)Math.sqrt(1.0f - ((float)i + 1.0f) / (float)n), alpha);
        }
        return palette;
    }

    public static Color[] heat(int n) {
        return Palette.heat(n, 1.0f);
    }

    public static Color[] heat(int n, float alpha) {
        int j = n / 4;
        int k = n - j;
        float h = 0.16666667f;
        Color[] c = Palette.rainbow(k, 0.0f, h, alpha);
        Color[] palette = new Color[n];
        System.arraycopy(c, 0, palette, 0, k);
        float s = 1.0f - 1.0f / (float)(2 * j);
        float end = 1.0f / (float)(2 * j);
        float w = (end - s) / (float)(j - 1);
        for (int i = k; i < n; ++i) {
            palette[i] = Palette.hsv(h, s, 1.0f, alpha);
            s += w;
        }
        return palette;
    }

    public static Color[] rainbow(int n) {
        return Palette.rainbow(n, 1.0f);
    }

    public static Color[] rainbow(int n, float alpha) {
        return Palette.rainbow(n, 0.0f, (float)(n - 1) / (float)n, alpha);
    }

    private static Color[] rainbow(int n, float start, float end, float alpha) {
        return Palette.rainbow(n, start, end, 1.0f, 1.0f, alpha);
    }

    private static Color[] rainbow(int n, float start, float end, float s, float v, float alpha) {
        Color[] palette = new Color[n];
        float h = start;
        float w = (end - start) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            palette[i] = Palette.hsv(h, s, v, alpha);
            h += w;
        }
        return palette;
    }

    private static Color hsv(float h, float s, float v, float alpha) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (s == 0.0f) {
            r = v;
            g = v;
            b = v;
        } else {
            if (h == 1.0f) {
                h = 0.0f;
            }
            int i = (int)Math.floor(h *= 6.0f);
            float f = h - (float)i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * f);
            float t = v * (1.0f - s * (1.0f - f));
            switch (i) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = p;
                    b = q;
                }
            }
        }
        return new Color(r, g, b, alpha);
    }
}

