/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.relevance;

import smile.nlp.Corpus;
import smile.nlp.TextTerms;
import smile.nlp.relevance.RelevanceRanker;

public class BM25
implements RelevanceRanker {
    private double k1;
    private double b;
    private double delta;
    private double kf = 4.9;
    private double bTitle = 0.6;
    private double bBody = 0.5;
    private double bAnchor = 0.6;
    private double wTitle = 13.5;
    private double wBody = 1.0;
    private double wAnchor = 11.5;

    public BM25() {
        this(1.2, 0.75, 1.0);
    }

    public BM25(double k1, double b, double delta) {
        if (k1 < 0.0) {
            throw new IllegalArgumentException("Negative k1 = " + k1);
        }
        if (b < 0.0 || b > 1.0) {
            throw new IllegalArgumentException("Invalid b = " + b);
        }
        if (delta < 0.0) {
            throw new IllegalArgumentException("Invalid delta = " + delta);
        }
        this.k1 = k1;
        this.b = b;
        this.delta = delta;
    }

    public double score(int termFreq, int docLen, double avgDocLen, int titleTermFreq, int titleLen, double avgTitleLen, int anchorTermFreq, int anchorLen, double avgAnchorLen, long N, long n) {
        if (termFreq <= 0) {
            return 0.0;
        }
        double tf = this.wBody * (double)termFreq / (1.0 + this.bBody * ((double)docLen / avgDocLen - 1.0));
        if (titleTermFreq > 0) {
            tf += this.wTitle * (double)titleTermFreq / (1.0 + this.bTitle * ((double)titleLen / avgTitleLen - 1.0));
        }
        if (anchorTermFreq > 0) {
            tf += this.wAnchor * (double)anchorTermFreq / (1.0 + this.bAnchor * ((double)anchorLen / avgAnchorLen - 1.0));
        }
        tf /= this.kf + tf;
        double idf = Math.log(((double)(N - n) + 0.5) / ((double)n + 0.5));
        return (tf + this.delta) * idf;
    }

    public double score(double freq, long N, long n) {
        if (freq <= 0.0) {
            return 0.0;
        }
        double tf = (this.k1 + 1.0) * freq / (freq + this.k1);
        double idf = Math.log(((double)(N - n) + 0.5) / ((double)n + 0.5));
        return (tf + this.delta) * idf;
    }

    public double score(double freq, int docSize, double avgDocSize, long N, long n) {
        if (freq <= 0.0) {
            return 0.0;
        }
        double tf = freq * (this.k1 + 1.0) / (freq + this.k1 * (1.0 - this.b + this.b * (double)docSize / avgDocSize));
        double idf = Math.log(((double)(N - n) + 0.5) / ((double)n + 0.5));
        return (tf + this.delta) * idf;
    }

    @Override
    public double rank(Corpus corpus, TextTerms doc, String term, int tf, int n) {
        if (tf <= 0) {
            return 0.0;
        }
        int N = corpus.getNumDocuments();
        int docSize = doc.size();
        int avgDocSize = corpus.getAverageDocumentSize();
        return this.score(tf, docSize, avgDocSize, N, n);
    }

    @Override
    public double rank(Corpus corpus, TextTerms doc, String[] terms, int[] tf, int n) {
        int N = corpus.getNumDocuments();
        int docSize = doc.size();
        int avgDocSize = corpus.getAverageDocumentSize();
        double r = 0.0;
        for (int i = 0; i < terms.length; ++i) {
            r += this.score(tf[i], docSize, avgDocSize, N, n);
        }
        return r;
    }
}

