/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.pos;

import java.util.regex.Pattern;
import smile.nlp.pos.PennTreebankPOS;

class RegexPOSTagger {
    private static final Pattern[] REGEX = new Pattern[]{Pattern.compile("^-?[0-9]+(\\.[0-9]+)?$"), Pattern.compile("^\\d{1,3},(\\d{3},)*\\d{3}(\\.\\d+)?$"), Pattern.compile("^(((\\d{3})|(\\d{3}-)){0,1}\\d{3}-\\d{4})((x|ext)\\d{1,5}){0,1}$"), Pattern.compile("^(x|ext)\\d{1,5}$"), Pattern.compile("^((mailto\\:|(news|(ht|f)tp(s?))\\://){1}\\S+)$"), Pattern.compile("^(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])$")};
    private static final PennTreebankPOS[] REGEX_POS = new PennTreebankPOS[]{PennTreebankPOS.CD, PennTreebankPOS.CD, PennTreebankPOS.NN, PennTreebankPOS.NN, PennTreebankPOS.NN, PennTreebankPOS.NN};

    private RegexPOSTagger() {
    }

    public static PennTreebankPOS tag(String word) {
        for (int i = 0; i < REGEX.length; ++i) {
            if (!REGEX[i].matcher(word).matches()) continue;
            return REGEX_POS[i];
        }
        return null;
    }
}

