/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.BufferedReader;
import java.util.ArrayList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.math.distance.EditDistance;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.LinearSearch;
import smile.stat.distribution.MultivariateGaussianDistribution;

public class LinearSearchSpeedTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testString() {
        System.out.println("string");
        ArrayList<String> words = new ArrayList<String>();
        long start = System.currentTimeMillis();
        try {
            BufferedReader input = IOUtils.getTestDataReader("neighbor/index.noun");
            String line = input.readLine();
            while (line != null) {
                if (!line.startsWith(" ")) {
                    String[] w = line.split("\\s");
                    words.add(w[0].replace('_', ' '));
                }
                line = input.readLine();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Loading string data: %.2fs%n", time);
        String[] data = words.toArray(new String[words.size()]);
        LinearSearch<String> naive = new LinearSearch<String>(data, new EditDistance(50, true));
        start = System.currentTimeMillis();
        ArrayList neighbors = new ArrayList();
        for (int i = 1000; i < 1100; ++i) {
            naive.range((String)words.get(i), 1.0, neighbors);
            neighbors.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Linear string search: %.2fs%n", time);
    }

    @Test
    public void testToy() {
        int i;
        System.out.println("toy data");
        long start = System.currentTimeMillis();
        double[] mu1 = new double[]{1.0, 1.0, 1.0};
        double[][] sigma1 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        double[] mu2 = new double[]{-2.0, -2.0, -2.0};
        double[][] sigma2 = new double[][]{{1.0, 0.3, 0.8}, {0.3, 1.0, 0.5}, {0.8, 0.5, 1.0}};
        double[] mu3 = new double[]{4.0, 2.0, 3.0};
        double[][] sigma3 = new double[][]{{1.0, 0.8, 0.3}, {0.8, 1.0, 0.5}, {0.3, 0.5, 1.0}};
        double[] mu4 = new double[]{3.0, 5.0, 1.0};
        double[][] sigma4 = new double[][]{{1.0, 0.5, 0.5}, {0.5, 1.0, 0.5}, {0.5, 0.5, 1.0}};
        double[][] data = new double[10000][];
        MultivariateGaussianDistribution g1 = new MultivariateGaussianDistribution(mu1, sigma1);
        for (int i2 = 0; i2 < 2000; ++i2) {
            data[i2] = g1.rand();
        }
        MultivariateGaussianDistribution g2 = new MultivariateGaussianDistribution(mu2, sigma2);
        for (int i3 = 0; i3 < 3000; ++i3) {
            data[2000 + i3] = g2.rand();
        }
        MultivariateGaussianDistribution g3 = new MultivariateGaussianDistribution(mu3, sigma3);
        for (int i4 = 0; i4 < 3000; ++i4) {
            data[5000 + i4] = g3.rand();
        }
        MultivariateGaussianDistribution g4 = new MultivariateGaussianDistribution(mu4, sigma4);
        for (int i5 = 0; i5 < 2000; ++i5) {
            data[8000 + i5] = g4.rand();
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Generating toy data (four Gaussians): %.2fs%n", time);
        LinearSearch<double[]> naive = new LinearSearch<double[]>(data, new EuclideanDistance());
        start = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            naive.nearest(data[Math.randomInt(data.length)]);
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            naive.knn(data[Math.randomInt(data.length)], 10);
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("10-NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        ArrayList n = new ArrayList();
        for (int i6 = 0; i6 < 1000; ++i6) {
            naive.range(data[Math.randomInt(data.length)], 1.0, n);
            n.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Range: %.2fs%n", time);
    }

    @Test
    public void testUSPS() {
        int i;
        System.out.println("USPS");
        double[][] x = null;
        double[][] testx = null;
        long start = System.currentTimeMillis();
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            x = (double[][])train.toArray((E[])new double[train.size()][]);
            testx = (double[][])test.toArray((E[])new double[test.size()][]);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Loading USPS: %.2fs%n", time);
        LinearSearch<double[]> naive = new LinearSearch<double[]>((T[])x, new EuclideanDistance());
        start = System.currentTimeMillis();
        for (i = 0; i < testx.length; ++i) {
            naive.nearest(testx[i]);
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (i = 0; i < testx.length; ++i) {
            naive.knn(testx[i], 10);
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("10-NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        ArrayList n = new ArrayList();
        for (int i2 = 0; i2 < testx.length; ++i2) {
            naive.range(testx[i2], 8.0, n);
            n.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Range: %.2fs%n", time);
    }
}

