/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.util.ArrayList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.CoverTree;

public class CoverTreeSpeedTest {
    double[][] x = null;
    double[][] testx = null;
    CoverTree<double[]> coverTree = null;

    public CoverTreeSpeedTest() {
        long start = System.currentTimeMillis();
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            this.x = (double[][])train.toArray((E[])new double[train.size()][]);
            this.testx = (double[][])test.toArray((E[])new double[test.size()][]);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Loading data: %.2fs%n", time);
        start = System.currentTimeMillis();
        this.coverTree = new CoverTree<double[]>((E[])this.x, new EuclideanDistance());
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Building cover tree: %.2fs%n", time);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCoverTree() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.testx.length; ++i) {
            this.coverTree.nearest(this.testx[i]);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (int i = 0; i < this.testx.length; ++i) {
            this.coverTree.knn(this.testx[i], 10);
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("10-NN: %.2fs%n", time);
        start = System.currentTimeMillis();
        ArrayList n = new ArrayList();
        for (int i = 0; i < this.testx.length; ++i) {
            this.coverTree.range(this.testx[i], 8.0, n);
            n.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Range: %.2fs%n", time);
    }
}

