/*
 * Decompiled with CFR 0.152.
 */
package smile.mds;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.math.Math;
import smile.mds.IsotonicMDS;

public class IsotonicMDSTest {
    double[][] swiss = new double[][]{{0.0, 80.5395828149116, 87.3528682986426, 31.381142426623, 27.2185598443415, 83.1457882276667, 98.6354505236327, 101.038458024655, 95.111377342566, 86.204967374276, 100.783741248279, 45.777326265303, 51.4295255665459, 44.2325773610356, 53.819323667248, 58.3449877881554, 18.9260561132001, 19.7833894972525, 22.6758924851923, 56.7144990280263, 43.8731455448547, 39.5378755119695, 35.4301058423483, 38.96405523043, 55.9127320026486, 41.6070054197607, 48.9555921218404, 44.3087756544908, 17.8600111982048, 32.9733164846971, 114.4407379389, 112.986054006678, 116.652053561007, 108.255623410518, 101.159466190762, 107.109196617284, 113.312929535865, 98.4551517189426, 24.5235723335733, 17.3507607902363, 7.90996839437428, 29.1451814199191, 21.8883553516476, 11.7002606808566, 58.9978338585409, 53.1034923521985, 52.9202881700393}, {80.5395828149116, 0.0, 11.1100675065456, 52.2083795956166, 80.6909065508624, 12.6977517695063, 28.2865710187714, 27.1912191709015, 16.531451841868, 12.7914659050478, 25.382334408009, 79.8551338362162, 86.0068305426959, 82.9902289429304, 87.1617484909521, 68.025433478957, 83.059145191845, 81.9459754960547, 92.777185234302, 87.6142111760415, 82.6346301498349, 81.5557625186596, 72.020691471271, 82.6826438861264, 87.0574729704464, 81.0821318170656, 84.629772538983, 79.5600050276519, 72.1379539493601, 79.381594844145, 44.6560958884675, 42.6617580509758, 47.7932589388922, 36.7127280381069, 24.7399353273205, 34.3396039581123, 43.0558288736844, 23.4429115085989, 82.0567389066858, 83.562865556418, 80.680570151679, 82.0976028882695, 80.7793717479902, 82.9105910001853, 81.5358816718137, 41.2589154001896, 40.865022941386}, {87.3528682986426, 11.1100675065456, 0.0, 60.1580160909583, 89.6933531539545, 9.3983455990935, 32.6666879251632, 30.2628088583991, 16.0260069886419, 15.3938429250139, 27.2520476294902, 89.5577712987544, 95.7273571138366, 92.7788278649822, 96.809846606634, 77.7820673420294, 91.1237619943338, 89.3876619002869, 99.5799804177527, 97.580959208239, 92.1780825359261, 90.7009062799264, 81.2423387157214, 91.7279128728, 96.637932510997, 90.6392238492806, 93.9584248484403, 89.1486533829872, 79.868038663786, 88.4964406063882, 47.0453621518636, 45.690681763353, 50.5585798851194, 39.5449566948808, 25.8122529043863, 37.1515221760832, 45.5625240740677, 26.300853598315, 90.5374419784434, 89.2963722667388, 87.3913176465489, 89.2997222840027, 89.0410854605895, 89.599400109599, 86.152269848217, 50.9414457980925, 47.3256262504787}, {31.381142426623, 52.2083795956166, 60.1580160909583, 0.0, 30.9293081073599, 57.2395842053382, 68.2130955169167, 70.8811829754555, 66.0752601205625, 58.8507612525106, 70.787467817404, 37.5266905015617, 44.2570898275067, 39.0670654132096, 46.2634034632127, 38.165493577314, 30.9961433084828, 37.3975346781041, 45.5386034041449, 48.3942651561112, 38.3628935300767, 35.0133188943865, 26.3134357315802, 35.6951663394359, 47.1662686673432, 36.0325075452708, 41.956573978341, 36.1951999580055, 25.3346817623589, 30.8134532306913, 83.1954542027387, 81.9325216260308, 85.4087401850654, 77.3979075944563, 70.7203824933095, 76.383205614847, 82.1083802056769, 68.7456442256526, 31.8909469912701, 39.1622318056568, 32.2258048774581, 42.4549467082459, 28.9782677191029, 33.4289455412521, 63.7638212468481, 29.7317271614012, 35.5757445459684}, {27.2185598443415, 80.6909065508624, 89.6933531539545, 30.9293081073599, 0.0, 86.7531446115932, 92.0675083837941, 95.5561614967868, 93.5056153394009, 86.3493972185099, 96.3281500912376, 19.8834001116509, 25.6827198715401, 17.7139182565575, 28.2794200789196, 37.1442000856123, 11.9611705112836, 29.6525294030712, 33.5706732133867, 30.2653663450486, 17.9570292643299, 17.0648644881816, 14.26780992304, 15.2109039836559, 31.5605386519305, 16.7751274212746, 26.0484164585873, 18.7172006453957, 23.1488660629414, 9.669208861122, 105.511669970672, 104.065510136644, 106.992315611917, 100.54834658014, 96.758894164826, 99.8739705829302, 104.595363185946, 93.8818347711633, 10.7847855796951, 38.9374742375517, 28.0509108586513, 37.7871353770036, 10.1590403090056, 27.5032743505205, 70.8689099676297, 47.5577848516938, 57.4402202293828}, {83.1457882276667, 12.6977517695063, 9.3983455990935, 57.2395842053382, 86.7531446115932, 0.0, 35.7939715594679, 33.5941676485666, 20.365902877113, 13.7297523648462, 30.784600046127, 87.8413484641487, 94.4191717820062, 90.5840471606342, 95.3492134209821, 77.0157574785836, 87.8993907828717, 84.7333558877494, 95.5235384604235, 96.2569628650312, 90.1949311214328, 88.6300315920061, 78.899017104144, 89.7936907583155, 95.59873900842, 88.5245480078831, 92.9513856809031, 87.6268366426633, 75.5287501551561, 85.968778635037, 53.2649002627434, 50.9351754684324, 56.1976414095823, 44.4144357163299, 31.5538032572937, 42.4485582794045, 51.6489312570938, 30.5986535651489, 87.0620611977456, 84.321636606508, 83.1063926542357, 83.9736416978566, 86.094192603218, 85.3982224639366, 80.3921818338077, 48.3990661066926, 42.4672532664876}, {98.6354505236327, 28.2865710187714, 32.6666879251632, 68.2130955169167, 92.0675083837941, 35.7939715594679, 0.0, 5.5701077188866, 18.2099533222905, 25.7643338745639, 8.45444261912044, 85.3182213832426, 90.7539332480967, 89.1243872349202, 90.3892742530882, 68.944488539694, 96.6674841919453, 98.2453439100296, 108.670741232403, 90.1975614969717, 88.6667040100172, 89.7309249924462, 80.746170807042, 90.5755071749532, 90.7797471906592, 88.4800226039754, 91.3484214422997, 86.010272060958, 87.4626897596912, 89.2034892815298, 23.6600845307028, 18.9520157239276, 24.6061476058322, 11.6607075257036, 12.8641711742343, 12.5576311460402, 22.1210781834882, 11.8953940666125, 93.5745846905024, 101.741552966327, 98.080563314043, 97.5627229017313, 93.806259919048, 99.195261983625, 99.5018597816141, 53.568427268308, 59.4673893827533}, {101.038458024655, 27.1912191709015, 30.2628088583991, 70.8811829754555, 95.5561614967868, 33.5941676485666, 5.5701077188866, 0.0, 15.1894733285917, 23.9461562677604, 4.14155767797576, 89.5893386514266, 95.0728252446513, 93.2475356242727, 94.9406425088855, 73.565559876888, 99.9257204127146, 100.708254378675, 111.469592714785, 94.7275693766076, 92.90174863801, 93.6734199226227, 84.617553734435, 94.6647326093514, 95.1799747846153, 92.4468760964912, 95.4162459961615, 90.1691388447289, 90.1814282432919, 92.9170253505782, 24.2312298491018, 19.4363165234568, 25.46047132321, 12.2331516789419, 10.2773342847258, 12.0677255520666, 22.5275387026635, 9.71796789457549, 97.0829109575934, 103.999648557098, 100.607621977661, 99.8954833813822, 97.1444599552646, 101.960728224155, 100.211787729788, 55.8840129196177, 60.4329289377902}, {95.111377342566, 16.531451841868, 16.0260069886419, 66.0752601205625, 93.5056153394009, 20.365902877113, 18.2099533222905, 15.1894733285917, 0.0, 12.9897690510648, 11.982220161556, 90.275481167369, 96.490465850259, 93.943321210185, 96.756459732671, 76.363413360064, 96.4633966849602, 95.4325080881772, 105.875967055796, 97.1329959385584, 93.3027523709778, 93.2851676313014, 83.4293167897233, 93.9934620066736, 97.1225148974222, 92.6338685362972, 95.9737052530536, 90.5226076734426, 85.3784756247147, 91.7156197166, 34.7524330083521, 32.0942378005772, 37.5723156060416, 25.0046815616596, 13.2854243439944, 23.150207342484, 33.1961458606267, 11.9229023312279, 94.4282928999566, 97.0590768552844, 94.6233190075258, 94.6205712305733, 94.0732693170595, 96.4000539418936, 92.3353610487336, 52.7669176662803, 52.8193676599787}, {86.204967374276, 12.7914659050478, 15.3938429250139, 58.8507612525106, 86.3493972185099, 13.7297523648462, 25.7643338745639, 23.9461562677604, 12.9897690510648, 0.0, 21.8580168359346, 85.0672063723736, 92.2278271456072, 88.3936790726577, 92.4995870261051, 73.4789248696522, 89.0442945954428, 85.3932836937426, 96.5450822155121, 93.0404836616835, 87.8688938134537, 88.0378872985943, 77.0799429164293, 88.4724386461682, 93.621580845444, 87.2788204549076, 92.0045781469596, 85.5392634992843, 76.0600841440502, 85.561547438087, 45.8515964825654, 42.3808919207701, 48.3090509118115, 35.1632819856168, 25.1697357951966, 33.3171487375496, 44.1843456441306, 19.97004006005, 86.7111734437956, 87.262065641377, 85.4641772908392, 83.845164440175, 87.0678361968414, 87.6784631480274, 80.1428824038667, 44.4218696139638, 41.4314192370959}, {100.783741248279, 25.382334408009, 27.2520476294902, 70.787467817404, 96.3281500912376, 30.784600046127, 8.45444261912044, 4.14155767797576, 11.982220161556, 21.8580168359346, 0.0, 90.947556866581, 96.543024605613, 94.5967885289982, 96.4230475560693, 75.135531541342, 100.237199182739, 100.810465726531, 111.38990798093, 96.4281748245812, 94.1496914493085, 94.62926661451, 85.51631949517, 95.6140580667927, 96.656629881245, 93.6230441718277, 96.6532591276673, 91.4435459723648, 90.2677821816843, 93.766199133803, 26.1635242274431, 22.0996583684002, 27.7923028912683, 14.7588109277137, 8.76368073357308, 14.4586479312555, 24.5351278782076, 9.80246907671735, 97.6011787838651, 103.376362868888, 100.330514301483, 99.960572727451, 97.541322525379, 101.673209844088, 99.76699303878, 56.6957882033578, 59.9729805829258}, {45.777326265303, 79.8551338362162, 89.5577712987544, 37.5266905015617, 19.8834001116509, 87.8413484641487, 85.3182213832426, 89.5893386514266, 90.275481167369, 85.0672063723736, 90.947556866581, 0.0, 12.2504081564656, 7.80116017012854, 11.8583304052468, 22.1204068678675, 29.2489042529801, 46.0688408797096, 49.2677064617382, 13.3608532661653, 4.78686745168487, 15.113570061372, 12.9643511214407, 10.9321727026241, 18.5565190701274, 12.0134965767673, 18.601655840274, 5.57853027239254, 37.7121147643566, 15.8147526063483, 96.5027776802305, 95.27562962269, 97.4429084130805, 92.559405788931, 91.3520114721072, 92.4412873125423, 95.8430153949676, 88.6985123888783, 24.5928851499778, 55.2925211941, 45.465811331153, 51.7703583143868, 26.1000478926764, 43.8737609511653, 82.3388268072845, 48.0676408824065, 62.8917013603544}, {51.4295255665459, 86.0068305426959, 95.7273571138366, 44.2570898275067, 25.6827198715401, 94.4191717820062, 90.7539332480967, 95.0728252446513, 96.490465850259, 92.2278271456072, 96.543024605613, 12.2504081564656, 0.0, 10.6707825392517, 8.46773287249899, 23.5020190621997, 33.6767115377972, 54.7416258435937, 57.1156230816053, 7.77077216240445, 11.9273467292605, 13.6276373594251, 23.1507429686393, 15.3207343166051, 7.5707925608882, 10.9641050706385, 9.86377716698831, 9.7689559319305, 46.7637263271438, 18.7677622533961, 99.9755650146574, 99.2066434267383, 100.750349379047, 97.3064031808801, 96.329499635366, 97.3116339396272, 99.4140135996933, 94.8628146324997, 32.0698066723203, 62.8626311889663, 52.5431489349468, 61.5292003848579, 30.0517886322928, 50.4311847967109, 92.9919614805495, 56.9649506275569, 72.6278431457248}, {44.2325773610356, 82.9902289429304, 92.7788278649822, 39.0670654132096, 17.7139182565575, 90.5840471606342, 89.1243872349202, 93.2475356242727, 93.943321210185, 88.3936790726577, 94.5967885289982, 7.80116017012854, 10.6707825392517, 0.0, 12.2699674001197, 25.2133476555574, 27.2297062048051, 45.5622914261344, 49.244881967571, 13.0425495973755, 6.04483250388297, 11.7242526414267, 15.9920011255627, 11.6349860335112, 16.9487728169328, 7.04343666117613, 16.8352873453351, 8.0494782439609, 37.8720332171379, 12.6597353842804, 100.633386110177, 99.2300987604064, 101.439562794799, 96.6336426923874, 95.1075922311148, 96.5343819579325, 99.8993038013779, 92.7452424655842, 23.5258602393196, 54.7946128738948, 44.794465059871, 51.6691406934545, 24.1286468746177, 43.047048679323, 83.6929393676671, 51.3133510891659, 65.6031249255704}, {53.819323667248, 87.1617484909521, 96.809846606634, 46.2634034632127, 28.2794200789196, 95.3492134209821, 90.3892742530882, 94.9406425088855, 96.756459732671, 92.4995870261051, 96.4230475560693, 11.8583304052468, 8.46773287249899, 12.2699674001197, 0.0, 22.3437776573255, 35.8051728106429, 55.8888548818098, 57.4079167014446, 6.3545574196792, 11.0248854869336, 16.9180377112714, 23.3097061328538, 15.7957082778836, 11.1837560774545, 15.1742578072208, 17.1521893646263, 12.7679285712288, 47.5468148249701, 21.7999633027214, 100.230694400468, 99.259405599671, 100.788255268161, 97.0752264998645, 96.7045500480717, 97.4243686148389, 99.7203068587336, 94.9825252349083, 32.0968845840215, 63.270379325558, 53.864273874248, 61.5482737369619, 32.6221167308316, 51.0684726617117, 93.4287450413415, 58.2602102639529, 73.4049051494517}, {58.3449877881554, 68.025433478957, 77.7820673420294, 38.165493577314, 37.1442000856123, 77.0157574785836, 68.944488539694, 73.565559876888, 76.363413360064, 73.4789248696522, 75.135531541342, 22.1204068678675, 23.5020190621997, 25.2133476555574, 22.3437776573255, 0.0, 44.3306891442035, 60.9705510882098, 66.1976019203113, 22.5355186317067, 24.7778308170832, 26.6831857168517, 26.2530683920947, 28.2322510615076, 22.6768604528934, 25.0772984988415, 26.5770502501688, 22.4241031035803, 49.6857887126691, 30.1315449321803, 78.3636401655768, 77.3788110531559, 78.8381887158755, 75.3369603846611, 75.2412812224779, 75.8714017268694, 77.8336533897774, 74.3032765091823, 40.9837333584924, 67.2522720805773, 58.6138243079224, 65.3470611427935, 40.3761427082875, 56.7794196870662, 91.6474745969577, 45.8913161720167, 62.6855397998613}, {18.9260561132001, 83.059145191845, 91.1237619943338, 30.9961433084828, 11.9611705112836, 87.8993907828717, 96.6674841919453, 99.9257204127146, 96.4633966849602, 89.0442945954428, 100.237199182739, 29.2489042529801, 33.6767115377972, 27.2297062048051, 35.8051728106429, 44.3306891442035, 0.0, 27.7815784288798, 27.9177810722844, 39.0667582479018, 26.5021678358583, 22.0558019577616, 21.8560197657304, 20.9740315628636, 38.2053661152462, 24.6571470369141, 31.9499233175919, 27.5039342640285, 21.6211840563832, 16.0729586573226, 110.654905449329, 109.471249193567, 112.411164925909, 105.51699199655, 100.447281695425, 104.859084489614, 109.735115619386, 98.1798395802315, 11.0377715142143, 30.9027523046087, 20.3279708775864, 36.9251188217452, 4.55509604728594, 18.109734951125, 70.91517186047, 53.1529575846914, 59.4515004015878}, {19.7833894972525, 81.9459754960547, 89.3876619002869, 37.3975346781041, 29.6525294030712, 84.7333558877494, 98.2453439100296, 100.708254378675, 95.4325080881772, 85.3932836937426, 100.810465726531, 46.0688408797096, 54.7416258435937, 45.5622914261344, 55.8888548818098, 60.9705510882098, 27.7815784288798, 0.0, 17.1523059674202, 58.0425094219745, 44.9926038366307, 45.8905011957812, 35.8563927354663, 42.5519459014509, 60.8536284867221, 45.8474034161151, 55.3701408703283, 46.6094636313271, 13.3256331932107, 38.3199699895498, 115.442713065832, 113.154385244232, 117.419555866985, 108.078686613041, 102.328794090422, 106.809702274653, 114.237789281831, 97.3939341026945, 25.6735291691657, 20.9237281572859, 15.8357854241588, 11.4549596245469, 30.7288073312324, 21.3295944640305, 44.6758648489316, 48.0963865586595, 47.1485779212905}, {22.6758924851923, 92.777185234302, 99.5799804177527, 45.5386034041449, 33.5706732133867, 95.5235384604235, 108.670741232403, 111.469592714785, 105.875967055796, 96.5450822155121, 111.38990798093, 49.2677064617382, 57.1156230816053, 49.244881967571, 57.4079167014446, 66.1976019203113, 27.9177810722844, 17.1523059674202, 0.0, 60.7532394198038, 47.2386113259058, 48.0644036684114, 40.2869718395414, 43.0657926897903, 62.9452341325378, 49.5166275103626, 57.4360348561772, 49.6551598527283, 23.2289926600359, 41.5810353406454, 125.071713828507, 123.3822957316, 127.205041173689, 118.203790548358, 112.485087456071, 117.17524525257, 124.051787975829, 108.09718960269, 27.0098296921695, 19.256936412628, 16.736932215911, 23.0814405962886, 31.9272986643092, 18.3081948864436, 54.6632975587825, 60.6438653121649, 59.5541132080732}, {56.7144990280263, 87.6142111760415, 97.580959208239, 48.3942651561112, 30.2653663450486, 96.2569628650312, 90.1975614969717, 94.7275693766076, 97.1329959385584, 93.0404836616835, 96.4281748245812, 13.3608532661653, 7.77077216240445, 13.0425495973755, 6.3545574196792, 22.5355186317067, 39.0667582479018, 58.0425094219745, 60.7532394198038, 0.0, 13.9266686612413, 19.7482252367143, 25.8571073401492, 19.7775023701174, 10.836678457904, 16.3756557120623, 17.3011097909932, 14.0122946015276, 50.1521126175159, 24.2100722840722, 99.39424983368, 98.3495582094805, 99.8340903699733, 96.5632145281007, 96.659166145793, 96.8067063792587, 98.872010194999, 94.8036924386387, 35.5384073925661, 66.9943467764258, 57.1500166229197, 63.7291644382695, 35.7448863475603, 54.9772325603972, 94.760170958056, 58.0862126498191, 74.4360134612272}, {43.8731455448547, 82.6346301498349, 92.1780825359261, 38.3628935300767, 17.9570292643299, 90.1949311214328, 88.6667040100172, 92.90174863801, 93.3027523709778, 87.8688938134537, 94.1496914493085, 4.78686745168487, 11.9273467292605, 6.04483250388297, 11.0248854869336, 24.7778308170832, 26.5021678358583, 44.9926038366307, 47.2386113259058, 13.9266686612413, 0.0, 12.4480560731385, 13.5317441595679, 7.80005769209433, 18.109911650806, 10.2239913927976, 18.050454287912, 6.78896899389001, 36.9112841824827, 13.4200186288991, 100.20524137988, 98.9699575628888, 101.135814131296, 96.134452201071, 94.6149570628238, 96.0901602662832, 99.535033530913, 92.149118281186, 21.9864071644277, 53.3285439516212, 43.6268277554076, 50.9460116201455, 23.5564768163662, 41.4868220041015, 82.9765756102287, 51.1304214729353, 64.9053926881272}, {39.5378755119695, 81.5557625186596, 90.7009062799264, 35.0133188943865, 17.0648644881816, 88.6300315920061, 89.7309249924462, 93.6734199226227, 93.2851676313014, 88.0378872985943, 94.62926661451, 15.113570061372, 13.6276373594251, 11.7242526414267, 16.9180377112714, 26.6831857168517, 22.0558019577616, 45.8905011957812, 48.0644036684114, 19.7482252367143, 12.4480560731385, 0.0, 17.5474898489784, 9.8240724753027, 16.5428050825729, 6.03855115073144, 12.5603184673001, 11.529960971313, 37.0737589138194, 7.73733804353926, 100.92108848006, 100.041119545915, 102.041170122652, 97.3371645364709, 94.4964020479087, 97.2245421691457, 100.210097295632, 93.29858573419, 22.572328191837, 51.2377097458503, 41.1788780808803, 53.3138818695469, 18.144213953765, 38.5671738658668, 85.9297527053348, 53.6434348266403, 66.3014788673677}, {35.4301058423483, 72.020691471271, 81.2423387157214, 26.3134357315802, 14.26780992304, 78.899017104144, 80.746170807042, 84.617553734435, 83.4293167897233, 77.0799429164293, 85.51631949517, 12.9643511214407, 23.1507429686393, 15.9920011255627, 23.3097061328538, 26.2530683920947, 21.8560197657304, 35.8563927354663, 40.2869718395414, 25.8571073401492, 13.5317441595679, 17.5474898489784, 0.0, 13.1104385891548, 28.5287153583893, 16.7468832921233, 25.606764731219, 13.9005899155396, 25.8354872220363, 13.5026515914468, 94.02470366877, 92.5938529277187, 95.384587853594, 88.9627585003972, 86.1193149067037, 88.5820320381058, 93.2078988069144, 83.1026840721766, 16.6084436356933, 43.9602377154628, 34.5086423957825, 41.4819044885839, 19.1104395553844, 33.4783527073839, 71.5375425912856, 39.8888969514074, 51.955520399665}, {38.96405523043, 82.6826438861264, 91.7279128728, 35.6951663394359, 15.2109039836559, 89.7936907583155, 90.5755071749532, 94.6647326093514, 93.9934620066736, 88.4724386461682, 95.6140580667927, 10.9321727026241, 15.3207343166051, 11.6349860335112, 15.7957082778836, 28.2322510615076, 20.9740315628636, 42.5519459014509, 43.0657926897903, 19.7775023701174, 7.80005769209433, 9.8240724753027, 13.1104385891548, 0.0, 20.4240054837439, 11.3714950644144, 17.4166472089206, 9.50159986528584, 34.2636483755014, 10.2766726132538, 102.168684536897, 101.263618343411, 103.416633091587, 98.1889891994006, 95.6995841161287, 98.0301463836508, 101.507229299198, 93.6330972466467, 18.5878024521459, 48.7644142792672, 38.9101580567337, 49.5412797573902, 17.9146001909057, 36.2850175692392, 82.2092427893604, 52.4106181989871, 64.622108445949}, {55.9127320026486, 87.0574729704464, 96.637932510997, 47.1662686673432, 31.5605386519305, 95.59873900842, 90.7797471906592, 95.1799747846153, 97.1225148974222, 93.621580845444, 96.656629881245, 18.5565190701274, 7.5707925608882, 16.9487728169328, 11.1837560774545, 22.6768604528934, 38.2053661152462, 60.8536284867221, 62.9452341325378, 10.836678457904, 18.109911650806, 16.5428050825729, 28.5287153583893, 20.4240054837439, 0.0, 15.5067372454685, 10.4074780806879, 15.9860063805817, 52.1756034943536, 23.3415937759186, 99.0057377125185, 98.501413187832, 99.6257998713185, 96.9556269640912, 96.181091696861, 97.203320930923, 98.5255987040931, 95.5826600383145, 37.4659632199681, 67.462820130795, 57.4147402676351, 67.6593703783888, 34.3738985278074, 54.7956430749745, 99.1625110613885, 60.9908263593797, 76.8589936181837}, {41.6070054197607, 81.0821318170656, 90.6392238492806, 36.0325075452708, 16.7751274212746, 88.5245480078831, 88.4800226039754, 92.4468760964912, 92.6338685362972, 87.2788204549076, 93.6230441718277, 12.0134965767673, 10.9641050706385, 7.04343666117613, 15.1742578072208, 25.0772984988415, 24.6571470369141, 45.8474034161151, 49.5166275103626, 16.3756557120623, 10.2239913927976, 6.03855115073144, 16.7468832921233, 11.3714950644144, 15.5067372454685, 0.0, 12.6067005992845, 8.81703464890549, 37.4851023741433, 8.79811911717499, 99.6594220332428, 98.5293991659342, 100.633805950088, 96.0035567049471, 93.7034689859452, 95.8274955323367, 98.913057277591, 92.054603361266, 23.6747143594173, 53.4632920797064, 43.1607472131797, 52.8634665908319, 20.8987463738857, 41.2861526422601, 84.8669670720004, 51.4941744277933, 65.337737946764}, {48.9555921218404, 84.629772538983, 93.9584248484403, 41.956573978341, 26.0484164585873, 92.9513856809031, 91.3484214422997, 95.4162459961615, 95.9737052530536, 92.0045781469596, 96.6532591276673, 18.601655840274, 9.86377716698831, 16.8352873453351, 17.1521893646263, 26.5770502501688, 31.9499233175919, 55.3701408703283, 57.4360348561772, 17.3011097909932, 18.050454287912, 12.5603184673001, 25.606764731219, 17.4166472089206, 10.4074780806879, 12.6067005992845, 0.0, 13.6310527839929, 47.1710716435402, 18.2970380116564, 99.7912446059272, 99.5163021821048, 100.911265971645, 97.754846427172, 95.7007607075304, 97.5246122781321, 99.2305900415794, 95.0578923603927, 33.5509105688653, 61.959687700956, 51.2059137209756, 63.403624502074, 27.8858046324649, 49.2278183550724, 94.4708335942898, 57.9067085923557, 72.9768655122978}, {44.3087756544908, 79.5600050276519, 89.1486533829872, 36.1951999580055, 18.7172006453957, 87.6268366426633, 86.010272060958, 90.1691388447289, 90.5226076734426, 85.5392634992843, 91.4435459723648, 5.57853027239254, 9.7689559319305, 8.0494782439609, 12.7679285712288, 22.4241031035803, 27.5039342640285, 46.6094636313271, 49.6551598527283, 14.0122946015276, 6.78896899389001, 11.529960971313, 13.9005899155396, 9.50159986528584, 15.9860063805817, 8.81703464890549, 13.6310527839929, 0.0, 38.138007289317, 13.1815932269206, 96.5743760010905, 95.6383897815098, 97.671942747137, 93.108042617166, 91.3907544557982, 92.8614860962283, 95.9201105086936, 89.2587368272709, 25.0233890590383, 55.17331692041, 44.8198616686843, 53.2988742845475, 23.8640419878947, 43.2841183345578, 83.9261246573437, 48.8916567524562, 63.7415257112661}, {17.8600111982048, 72.1379539493601, 79.868038663786, 25.3346817623589, 23.1488660629414, 75.5287501551561, 87.4626897596912, 90.1814282432919, 85.3784756247147, 76.0600841440502, 90.2677821816843, 37.7121147643566, 46.7637263271438, 37.8720332171379, 47.5468148249701, 49.6857887126691, 21.6211840563832, 13.3256331932107, 23.2289926600359, 50.1521126175159, 36.9112841824827, 37.0737589138194, 25.8354872220363, 34.2636483755014, 52.1756034943536, 37.4851023741433, 47.1710716435402, 38.138007289317, 0.0, 29.86, 104.407913972074, 102.305954860898, 106.305886948936, 97.2751766896365, 91.6174524858665, 96.29527506581, 103.261803199441, 87.4493390483885, 18.7025559750532, 21.6050665354217, 14.2628047732555, 18.9847728456255, 23.3115872475471, 17.5444036661267, 50.3390941515638, 40.0301249061254, 41.2551439216978}, {32.9733164846971, 79.381594844145, 88.4964406063882, 30.8134532306913, 9.669208861122, 85.968778635037, 89.2034892815298, 92.9170253505782, 91.7156197166, 85.561547438087, 93.766199133803, 15.8147526063483, 18.7677622533961, 12.6597353842804, 21.7999633027214, 30.1315449321803, 16.0729586573226, 38.3199699895498, 41.5810353406454, 24.2100722840722, 13.4200186288991, 7.73733804353926, 13.5026515914468, 10.2766726132538, 23.3415937759186, 8.79811911717499, 18.2970380116564, 13.1815932269206, 29.86, 0.0, 101.59996112204, 100.427418566844, 102.892613923449, 97.3102235122292, 93.9017806007958, 96.941279133298, 100.774697221078, 92.0068089871614, 16.287430736614, 44.8929404249711, 34.4820881038257, 45.9448843724739, 12.2530363583889, 32.6365209542929, 78.5842070647786, 49.3360811171702, 60.8560013474431}, {114.4407379389, 44.6560958884675, 47.0453621518636, 83.1954542027387, 105.511669970672, 53.2649002627434, 23.6600845307028, 24.2312298491018, 34.7524330083521, 45.8515964825654, 26.1635242274431, 96.5027776802305, 99.9755650146574, 100.633386110177, 100.230694400468, 78.3636401655768, 110.654905449329, 115.442713065832, 125.071713828507, 99.39424983368, 100.20524137988, 100.92108848006, 94.02470366877, 102.168684536897, 99.0057377125185, 99.6594220332428, 99.7912446059272, 96.5743760010905, 104.407913972074, 101.59996112204, 0.0, 7.42232443376063, 5.36321731799113, 13.241695510772, 22.0506258414586, 13.8820927817098, 2.04755952294433, 27.5342405016009, 108.467590090312, 119.514210033786, 114.523185862078, 116.213097798828, 107.245361671263, 115.482135414964, 119.292987639676, 69.861422831202, 78.7856865172856}, {112.986054006678, 42.6617580509758, 45.690681763353, 81.9325216260308, 104.065510136644, 50.9351754684324, 18.9520157239276, 19.4363165234568, 32.0942378005772, 42.3808919207701, 22.0996583684002, 95.27562962269, 99.2066434267383, 99.2300987604064, 99.259405599671, 77.3788110531559, 109.471249193567, 113.154385244232, 123.3822957316, 98.3495582094805, 98.9699575628888, 100.041119545915, 92.5938529277187, 101.263618343411, 98.501413187832, 98.5293991659342, 99.5163021821048, 95.6383897815098, 102.305954860898, 100.427418566844, 7.42232443376063, 0.0, 6.73738821799664, 8.40049998511994, 20.2803254411757, 9.91889106704978, 6.11460546560447, 23.9008891048011, 106.802544913499, 117.670820937053, 112.92130711252, 113.352316253352, 106.171154745533, 113.991187817305, 115.78344268504, 67.1193898959161, 75.73580725126}, {116.652053561007, 47.7932589388922, 50.5585798851194, 85.4087401850654, 106.992315611917, 56.1976414095823, 24.6061476058322, 25.46047132321, 37.5723156060416, 48.3090509118115, 27.7923028912683, 97.4429084130805, 100.750349379047, 101.439562794799, 100.788255268161, 78.8381887158755, 112.411164925909, 117.419555866985, 127.205041173689, 99.8340903699733, 101.135814131296, 102.041170122652, 95.384587853594, 103.416633091587, 99.6257998713185, 100.633805950088, 100.911265971645, 97.671942747137, 106.305886948936, 102.892613923449, 5.36321731799113, 6.73738821799664, 0.0, 14.125919439102, 25.0363415857829, 16.0179149704323, 5.94151495832503, 30.0441158964613, 109.928496760394, 121.729224510797, 116.710104104143, 117.994857515063, 108.963300702576, 117.525582321467, 121.581312708821, 71.866577071682, 81.2366228987887}, {108.255623410518, 36.7127280381069, 39.5449566948808, 77.3979075944563, 100.54834658014, 44.4144357163299, 11.6607075257036, 12.2331516789419, 25.0046815616596, 35.1632819856168, 14.7588109277137, 92.559405788931, 97.3064031808801, 96.6336426923874, 97.0752264998645, 75.3369603846611, 105.51699199655, 108.078686613041, 118.203790548358, 96.5632145281007, 96.134452201071, 97.3371645364709, 88.9627585003972, 98.1889891994006, 96.9556269640912, 96.0035567049471, 97.754846427172, 93.108042617166, 97.2751766896365, 97.3102235122292, 13.241695510772, 8.40049998511994, 14.125919439102, 0.0, 14.5628843296924, 5.08527285403645, 11.8667602992561, 16.8593267955752, 102.611917436524, 111.979412840039, 107.841585670835, 107.800192949735, 102.434564967105, 108.931887434305, 109.41107987768, 62.4512682016947, 69.4986107774825}, {101.159466190762, 24.7399353273205, 25.8122529043863, 70.7203824933095, 96.758894164826, 31.5538032572937, 12.8641711742343, 10.2773342847258, 13.2854243439944, 25.1697357951966, 8.76368073357308, 91.3520114721072, 96.329499635366, 95.1075922311148, 96.7045500480717, 75.2412812224779, 100.447281695425, 102.328794090422, 112.485087456071, 96.659166145793, 94.6149570628238, 94.4964020479087, 86.1193149067037, 95.6995841161287, 96.181091696861, 93.7034689859452, 95.7007607075304, 91.3907544557982, 91.6174524858665, 93.9017806007958, 22.0506258414586, 20.2803254411757, 25.0363415857829, 14.5628843296924, 0.0, 12.9408500493592, 20.514326701113, 12.065740756373, 98.5850901505902, 104.634386795164, 101.088723406718, 102.370991985035, 97.5750608506088, 102.458356906599, 102.883936549881, 58.13582458347, 62.2644529406627}, {107.109196617284, 34.3396039581123, 37.1515221760832, 76.383205614847, 99.8739705829302, 42.4485582794045, 12.5576311460402, 12.0677255520666, 23.150207342484, 33.3171487375496, 14.4586479312555, 92.4412873125423, 97.3116339396272, 96.5343819579325, 97.4243686148389, 75.8714017268694, 104.859084489614, 106.809702274653, 117.17524525257, 96.8067063792587, 96.0901602662832, 97.2245421691457, 88.5820320381058, 98.0301463836508, 97.203320930923, 95.8274955323367, 97.5246122781321, 92.8614860962283, 96.29527506581, 96.941279133298, 13.8820927817098, 9.91889106704978, 16.0179149704323, 5.08527285403645, 12.9408500493592, 0.0, 12.2515305166334, 14.1740220121178, 102.183822594381, 111.056305088905, 106.802226568551, 106.667284581544, 101.806964889442, 108.206737775427, 107.318630255888, 60.6013770470606, 67.479055269024}, {113.312929535865, 43.0558288736844, 45.5625240740677, 82.1083802056769, 104.595363185946, 51.6489312570938, 22.1210781834882, 22.5275387026635, 33.1961458606267, 44.1843456441306, 24.5351278782076, 95.8430153949676, 99.4140135996933, 99.8993038013779, 99.7203068587336, 77.8336533897774, 109.735115619386, 114.237789281831, 124.051787975829, 98.872010194999, 99.535033530913, 100.210097295632, 93.2078988069144, 101.507229299198, 98.5255987040931, 98.913057277591, 99.2305900415794, 95.9201105086936, 103.261803199441, 100.774697221078, 2.04755952294433, 6.11460546560447, 5.94151495832503, 11.8667602992561, 20.514326701113, 12.2515305166334, 0.0, 25.9308098600873, 107.547131993373, 118.366375715403, 113.421636383893, 114.942340327662, 106.353420725428, 114.453073790091, 117.801292013288, 68.5313862401746, 77.299979948251}, {98.4551517189426, 23.4429115085989, 26.300853598315, 68.7456442256526, 93.8818347711633, 30.5986535651489, 11.8953940666125, 9.71796789457549, 11.9229023312279, 19.97004006005, 9.80246907671735, 88.6985123888783, 94.8628146324997, 92.7452424655842, 94.9825252349083, 74.3032765091823, 98.1798395802315, 97.3939341026945, 108.09718960269, 94.8036924386387, 92.149118281186, 93.29858573419, 83.1026840721766, 93.6330972466467, 95.5826600383145, 92.054603361266, 95.0578923603927, 89.2587368272709, 87.4493390483885, 92.0068089871614, 27.5342405016009, 23.9008891048011, 30.0441158964613, 16.8593267955752, 12.065740756373, 14.1740220121178, 25.9308098600873, 0.0, 95.4159006665032, 101.146238684392, 97.7940289588275, 96.5653566244127, 95.5621242961875, 99.6445302061282, 94.7458711501456, 51.8673307583878, 55.442312361589}, {24.5235723335733, 82.0567389066858, 90.5374419784434, 31.8909469912701, 10.7847855796951, 87.0620611977456, 93.5745846905024, 97.0829109575934, 94.4282928999566, 86.7111734437956, 97.6011787838651, 24.5928851499778, 32.0698066723203, 23.5258602393196, 32.0968845840215, 40.9837333584924, 11.0377715142143, 25.6735291691657, 27.0098296921695, 35.5384073925661, 21.9864071644277, 22.572328191837, 16.6084436356933, 18.5878024521459, 37.4659632199681, 23.6747143594173, 33.5509105688653, 25.0233890590383, 18.7025559750532, 16.287430736614, 108.467590090312, 106.802544913499, 109.928496760394, 102.611917436524, 98.5850901505902, 102.183822594381, 107.547131993373, 95.4159006665032, 0.0, 31.9261475909637, 22.8300240910955, 32.3824026285883, 12.1306430167572, 20.5890966290413, 67.3757255990613, 49.6848679177071, 56.5582363586419}, {17.3507607902363, 83.562865556418, 89.2963722667388, 39.1622318056568, 38.9374742375517, 84.321636606508, 101.741552966327, 103.999648557098, 97.0590768552844, 87.262065641377, 103.376362868888, 55.2925211941, 62.8626311889663, 54.7946128738948, 63.270379325558, 67.2522720805773, 30.9027523046087, 20.9237281572859, 19.256936412628, 66.9943467764258, 53.3285439516212, 51.2377097458503, 43.9602377154628, 48.7644142792672, 67.462820130795, 53.4632920797064, 61.959687700956, 55.17331692041, 21.6050665354217, 44.8929404249711, 119.514210033786, 117.670820937053, 121.729224510797, 111.979412840039, 104.634386795164, 111.056305088905, 118.366375715403, 101.146238684392, 31.9261475909637, 0.0, 11.9651535719355, 24.3116618107442, 34.4100624817799, 13.4320363311004, 51.8806563181308, 57.9136391534844, 52.5190593975178}, {7.90996839437428, 80.680570151679, 87.3913176465489, 32.2258048774581, 28.0509108586513, 83.1063926542357, 98.080563314043, 100.607621977661, 94.6233190075258, 85.4641772908392, 100.330514301483, 45.465811331153, 52.5431489349468, 44.794465059871, 53.864273874248, 58.6138243079224, 20.3279708775864, 15.8357854241588, 16.736932215911, 57.1500166229197, 43.6268277554076, 41.1788780808803, 34.5086423957825, 38.9101580567337, 57.4147402676351, 43.1607472131797, 51.2059137209756, 44.8198616686843, 14.2628047732555, 34.4820881038257, 114.523185862078, 112.92130711252, 116.710104104143, 107.841585670835, 101.088723406718, 106.802226568551, 113.421636383893, 97.7940289588275, 22.8300240910955, 11.9651535719355, 0.0, 24.0854728000096, 23.7082791446364, 7.4809691885477, 55.0864266403258, 52.1912262741546, 50.955981984454}, {29.1451814199191, 82.0976028882695, 89.2997222840027, 42.4549467082459, 37.7871353770036, 83.9736416978566, 97.5627229017313, 99.8954833813822, 94.6205712305733, 83.845164440175, 99.960572727451, 51.7703583143868, 61.5292003848579, 51.6691406934545, 61.5482737369619, 65.3470611427935, 36.9251188217452, 11.4549596245469, 23.0814405962886, 63.7291644382695, 50.9460116201455, 53.3138818695469, 41.4819044885839, 49.5412797573902, 67.6593703783888, 52.8634665908319, 63.403624502074, 53.2988742845475, 18.9847728456255, 45.9448843724739, 116.213097798828, 113.352316253352, 117.994857515063, 107.800192949735, 102.370991985035, 106.667284581544, 114.942340327662, 96.5653566244127, 32.3824026285883, 24.3116618107442, 24.0854728000096, 0.0, 39.7089725377024, 28.4051562220664, 37.2174206521623, 48.5485334484987, 44.8161589161766}, {21.8883553516476, 80.7793717479902, 89.0410854605895, 28.9782677191029, 10.1590403090056, 86.094192603218, 93.806259919048, 97.1444599552646, 94.0732693170595, 87.0678361968414, 97.541322525379, 26.1000478926764, 30.0517886322928, 24.1286468746177, 32.6221167308316, 40.3761427082875, 4.55509604728594, 30.7288073312324, 31.9272986643092, 35.7448863475603, 23.5564768163662, 18.144213953765, 19.1104395553844, 17.9146001909057, 34.3738985278074, 20.8987463738857, 27.8858046324649, 23.8640419878947, 23.3115872475471, 12.2530363583889, 107.245361671263, 106.171154745533, 108.963300702576, 102.434564967105, 97.5750608506088, 101.806964889442, 106.353420725428, 95.5621242961875, 12.1306430167572, 34.4100624817799, 23.7082791446364, 39.7089725377024, 0.0, 21.7025897072216, 72.9758651884306, 51.3405453808196, 58.9812648219755}, {11.7002606808566, 82.9105910001853, 89.599400109599, 33.4289455412521, 27.5032743505205, 85.3982224639366, 99.195261983625, 101.960728224155, 96.4000539418936, 87.6784631480274, 101.673209844088, 43.8737609511653, 50.4311847967109, 43.047048679323, 51.0684726617117, 56.7794196870662, 18.109734951125, 21.3295944640305, 18.3081948864436, 54.9772325603972, 41.4868220041015, 38.5671738658668, 33.4783527073839, 36.2850175692392, 54.7956430749745, 41.2861526422601, 49.2278183550724, 43.2841183345578, 17.5444036661267, 32.6365209542929, 115.482135414964, 113.991187817305, 117.525582321467, 108.931887434305, 102.458356906599, 108.206737775427, 114.453073790091, 99.6445302061282, 20.5890966290413, 13.4320363311004, 7.4809691885477, 28.4051562220664, 21.7025897072216, 0.0, 60.856520603794, 55.5937802276478, 55.1556198405928}, {58.9978338585409, 81.5358816718137, 86.152269848217, 63.7638212468481, 70.8689099676297, 80.3921818338077, 99.5018597816141, 100.211787729788, 92.3353610487336, 80.1428824038667, 99.76699303878, 82.3388268072845, 92.9919614805495, 83.6929393676671, 93.4287450413415, 91.6474745969577, 70.91517186047, 44.6758648489316, 54.6632975587825, 94.760170958056, 82.9765756102287, 85.9297527053348, 71.5375425912856, 82.2092427893604, 99.1625110613885, 84.8669670720004, 94.4708335942898, 83.9261246573437, 50.3390941515638, 78.5842070647786, 119.292987639676, 115.78344268504, 121.581312708821, 109.41107987768, 102.883936549881, 107.318630255888, 117.801292013288, 94.7458711501456, 67.3757255990613, 51.8806563181308, 55.0864266403258, 37.2174206521623, 72.9758651884306, 60.856520603794, 0.0, 56.0682450233642, 41.9597438028404}, {53.1034923521985, 41.2589154001896, 50.9414457980925, 29.7317271614012, 47.5577848516938, 48.3990661066926, 53.568427268308, 55.8840129196177, 52.7669176662803, 44.4218696139638, 56.6957882033578, 48.0676408824065, 56.9649506275569, 51.3133510891659, 58.2602102639529, 45.8913161720167, 53.1529575846914, 48.0963865586595, 60.6438653121649, 58.0862126498191, 51.1304214729353, 53.6434348266403, 39.8888969514074, 52.4106181989871, 60.9908263593797, 51.4941744277933, 57.9067085923557, 48.8916567524562, 40.0301249061254, 49.3360811171702, 69.861422831202, 67.1193898959161, 71.866577071682, 62.4512682016947, 58.13582458347, 60.6013770470606, 68.5313862401746, 51.8673307583878, 49.6848679177071, 57.9136391534844, 52.1912262741546, 48.5485334484987, 51.3405453808196, 55.5937802276478, 56.0682450233642, 0.0, 21.3735818242989}, {52.9202881700393, 40.865022941386, 47.3256262504787, 35.5757445459684, 57.4402202293828, 42.4672532664876, 59.4673893827533, 60.4329289377902, 52.8193676599787, 41.4314192370959, 59.9729805829258, 62.8917013603544, 72.6278431457248, 65.6031249255704, 73.4049051494517, 62.6855397998613, 59.4515004015878, 47.1485779212905, 59.5541132080732, 74.4360134612272, 64.9053926881272, 66.3014788673677, 51.955520399665, 64.622108445949, 76.8589936181837, 65.337737946764, 72.9768655122978, 63.7415257112661, 41.2551439216978, 60.8560013474431, 78.7856865172856, 75.73580725126, 81.2366228987887, 69.4986107774825, 62.2644529406627, 67.479055269024, 77.299979948251, 55.442312361589, 56.5582363586419, 52.5190593975178, 50.955981984454, 44.8161589161766, 58.9812648219755, 55.1556198405928, 41.9597438028404, 21.3735818242989, 0.0}};

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn_doubleArrArr() {
        int j;
        int i;
        System.out.println("learn");
        double[][] points = new double[][]{{40.22360360457568, 18.504098418635056}, {-41.96153329423929, 15.679459081085987}, {-49.154520492544854, 23.057549478935496}, {10.598081220086218, 7.779540233953462}, {35.757866842749806, -4.0940414119709745}, {-45.05078778030483, 26.197239791961866}, {-55.284584971795624, -3.4691421950369614}, {-58.547722578180036, -0.581590856322055}, {-55.23402255948884, 11.41947137100053}, {-46.739993491044444, 17.75826916762321}, {-59.27724694557147, 2.5924406005262988}, {27.6737865285104, -18.86395047195548}, {31.583645719051308, -26.40457138526285}, {32.20027300792993, -19.14462360613023}, {30.93647170723012, -28.139903505514962}, {10.820417446883258, -25.981714242664278}, {40.61994472140328, 1.7893356291367033}, {36.893123121307056, 25.2011449401249}, {50.35435388043603, 23.460119648230112}, {30.31641225177879, -30.621625333828987}, {31.57301393922658, -18.462236251192287}, {33.48847606238201, -16.246616010675815}, {25.404563654492463, -7.368448245974307}, {34.198667011206695, -14.51548898530616}, {30.374194968862504, -32.03010239329132}, {31.799691626843952, -17.620915345075993}, {33.202462089583705, -26.623087076374446}, {28.74143110010598, -18.88136294206028}, {29.619321505441754, 16.53977754459522}, {33.21904729286558, -10.485990318581562}, {-68.03569731150479, -17.717332618032408}, {-66.8523610229811, -14.04860419250387}, {-69.0945497414166, -19.49039719928254}, {-63.412123082772155, -8.958925369982111}, {-60.125050342241366, 0.6420002976226844}, {-63.01224683586109, -7.474379597257728}, {-67.2871126283525, -15.967072181468266}, {-56.75383978958709, 3.8275706756047425}, {37.38667411461407, 1.48236982754225}, {42.09168775562593, 30.160624244349172}, {39.515694105763124, 20.31157656136279}, {34.40756902634357, 33.374967724530244}, {37.50347081823464, -1.1747328861102793}, {42.17288961345579, 16.841661303971275}, {17.7129501323806, 65.0200551147668}, {-6.945057439388253, 11.751691969153283}, {-7.62133456223296, 30.975890997191055}};
        IsotonicMDS mds = new IsotonicMDS(this.swiss, 2);
        double sign = Math.signum(points[0][0] / mds.getCoordinates()[0][0]);
        for (i = 0; i < points.length; ++i) {
            double[] dArray = points[i];
            dArray[0] = dArray[0] * sign;
        }
        sign = Math.signum(points[0][1] / mds.getCoordinates()[0][1]);
        for (i = 0; i < points.length; ++i) {
            double[] dArray = points[i];
            dArray[1] = dArray[1] * sign;
        }
        Assert.assertEquals(0.02319, mds.getStress(), 1.0E-6);
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                System.out.print(points[i][j] + " ");
            }
            System.out.println();
        }
        System.out.println("==============");
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < mds.getCoordinates()[i].length; ++j) {
                System.out.print(mds.getCoordinates()[i][j] + " ");
            }
            System.out.println();
        }
        Assert.assertTrue(Math.equals(points, mds.getCoordinates(), 1.0E-6));
    }
}

