/*
 * Decompiled with CFR 0.152.
 */
package smile.math.random;

import smile.math.random.RandomNumberGenerator;

public class MersenneTwister
implements RandomNumberGenerator {
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAGIC = new int[]{0, -1727483681};
    private static final int MAGIC_FACTOR1 = 1812433253;
    private static final int MAGIC_MASK1 = -1658038656;
    private static final int MAGIC_MASK2 = -272236544;
    private static final int MAGIC_SEED = 19650218;
    private transient int[] mt = new int[624];
    private transient int mti;

    public MersenneTwister() {
        this(19650218);
    }

    public MersenneTwister(int seed) {
        this.setSeed(seed);
    }

    public MersenneTwister(long seed) {
        this.setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        this.setSeed((int)(seed % 899999963L));
    }

    public void setSeed(int seed) {
        this.mt[0] = seed;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    @Override
    public int next(int numbits) {
        return this.nextInt() >>> 32 - numbits;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextInt() >>> 1) / 2.147483647E9;
    }

    @Override
    public void nextDoubles(double[] d) {
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            d[i] = this.nextDouble();
        }
    }

    @Override
    public int nextInt() {
        int x;
        if (this.mti >= 624) {
            int i;
            for (i = 0; i < 227; ++i) {
                x = this.mt[i] & Integer.MIN_VALUE | this.mt[i + 1] & Integer.MAX_VALUE;
                this.mt[i] = this.mt[i + 397] ^ x >>> 1 ^ MAGIC[x & 1];
            }
            while (i < 623) {
                x = this.mt[i] & Integer.MIN_VALUE | this.mt[i + 1] & Integer.MAX_VALUE;
                this.mt[i] = this.mt[i + -227] ^ x >>> 1 ^ MAGIC[x & 1];
                ++i;
            }
            x = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ x >>> 1 ^ MAGIC[x & 1];
            this.mti = 0;
        }
        x = this.mt[this.mti++];
        x ^= x >>> 11;
        x ^= x << 7 & 0x9D2C5680;
        x ^= x << 15 & 0xEFC60000;
        x ^= x >>> 18;
        return x;
    }

    @Override
    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    @Override
    public long nextLong() {
        long x = this.nextInt();
        return x << 32 | (long)this.nextInt();
    }
}

