/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.manifold.IsoMap;
import smile.math.Math;

public class IsoMapTest {
    AttributeDataset swissroll;

    public IsoMapTest() {
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setDelimiter("\t");
        try {
            this.swissroll = parser.parse("Swissroll", IOUtils.getTestDataFile("manifold/swissroll.txt"));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /*
     * Opcode count of 13070 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Test
    public void testLearn() {
        System.out.println("learn");
        double[][] points = new double[][]{{-10.656995169781643, 8.724767075729131}, {14.793549427637924, 11.79271456698354}, {-46.67407802897754, -1.6411155810814095}, {-28.672898578694433, 5.040994792323485}, {8.267171421974126, 11.046311848465312}, {-6.446117788627282, 16.901125668814686}, {13.603491190852939, 14.7173180758012}, {-29.88166100414807, -8.170639714978986}, {-5.554950986036401, -4.893383796053973}, {-41.59396666178828, -19.67356023251009}, {-38.55315696491555, 10.250842633011796}, {28.4746757161194, -5.815769022178523}, {-29.8762542307548, 17.09326329348623}, {37.27735404867014, 5.878878037989845}, {20.6267888938681, 23.417027896374783}, {15.74246051458942, 0.3297963806897435}, {23.49929001900639, 16.389001794346928}, {-30.957050765267564, -3.484551353587939}, {53.214274299548556, -24.467927275023502}, {38.91059107649051, 11.988187487371192}, {5.236320665578599, -1.3581655663527485}, {39.46629083655373, 14.017393582869072}, {43.25720176708444, 22.46682518442928}, {21.279320341223457, -5.179205577723071}, {-18.754976902155388, 8.553378905955816}, {-33.892183679171104, 16.500046885084302}, {22.027238638614456, -21.55393068853292}, {15.140905945186805, 18.751362829539676}, {16.316123467947286, 7.541931966557806}, {-28.382951926599542, 18.138283760158217}, {-24.422611226981296, 13.197788127619893}, {-26.770234724837703, 2.340245176486545}, {15.754085985531843, 11.165879758439512}, {-29.091191686412632, 5.926607018852651}, {52.49964724567716, -10.7901755782248}, {-44.933769188485705, -20.516985762525273}, {-26.32106093975573, -17.446408011135198}, {-17.862110221990662, -11.464848936521348}, {-18.30488616665876, 14.739562731276937}, {27.669182832505324, -26.011485533344388}, {4.4323030094806395, -27.52388345505937}, {5.248562950750164, -5.314591936277219}, {33.43192945326458, 6.863342710037678}, {-11.994024466685188, -0.2111874526297351}, {-36.094546808894236, -20.29136796378005}, {6.03050727875147, -15.679702527050397}, {-0.6606319547882661, -5.258270913252623}, {43.28169674525514, 17.9411432031152}, {-18.94925410807153, 4.8653788596887235}, {41.464812717582774, 10.226578132815515}, {17.61865463387317, 4.679321084124088}, {9.3568540825811, 1.870557723932068}, {-9.783239740251787, -12.329011785921066}, {35.11735232744676, 3.9495623621216955}, {-9.67153022463083, 2.574475241466689}, {18.593413166398413, -11.60847296096321}, {-19.849432671067493, 17.31486404921796}, {-36.181356083644424, 18.291896296659207}, {-14.36019314144953, 13.090378804571044}, {28.578748440867763, -1.9500768407727642}, {10.970099673277222, -24.133332586508192}, {41.75487731462738, 12.572433186962543}, {48.07815987805679, 11.9694818442177}, {22.864101146056296, -4.6423830064802845}, {12.94310715170995, 9.108457844948768}, {-24.00719240577404, -24.171392396479423}, {44.240300535937216, 16.73365743222644}, {-40.852845115654205, -22.2158088572274}, {-20.381050282923447, -22.812740747341778}, {-10.957830159644203, 11.820630155052}, {7.253198802848285, 17.299404472108364}, {-1.182945978861347, 17.33118283140501}, {9.282659002108158, 9.408767405106559}, {-38.484784020446504, 9.942674766452498}, {-5.057999539775727, 16.57298223190475}, {-41.78858564062362, 3.396740613545864}, {-38.130082726306334, 2.5527455676241373}, {35.29776504558499, 2.998646838427902}, {-37.48204748357788, -17.63721110873406}, {43.56377342501922, -25.432952005362296}, {-16.720715034057612, 19.573474408754272}, {-25.686035711171442, -6.079682556330675}, {-23.37330361381891, 24.49478477055417}, {-9.335336201507653, -11.504196863813931}, {5.869867488549844, -5.507344943613809}, {-23.538356455443814, -5.986178763228}, {20.229251373058315, -1.6265025492016754}, {11.703042716338837, -24.893720520407086}, {-35.26598846325004, -7.407639570653892}, {-27.523594897251495, 4.243668713008691}, {51.44246356044047, -19.78368452748853}, {8.592204780894884, -1.195157664626637}, {-27.694814525944047, 6.1520718160707695}, {-7.093031332320166, 4.369567623943838}, {-41.375223215660675, -1.5054894090896707}, {-31.914555239394584, 21.48563460569355}, {41.59340871715706, 3.8228073127751774}, {-19.05504842459942, -11.934250780771569}, {43.81483422941677, 22.1737094829524}, {-17.495470199775276, 12.801212035289621}, {-44.638249573982954, -1.6691802696024864}, {11.130342021694599, -16.960711532568038}, {45.010305371607764, 18.307287329570997}, {14.63298101730924, 22.034489809250886}, {33.39425351004296, 14.646553865933827}, {19.58485515296486, 20.388325551420486}, {12.37102376465103, 13.677393780414473}, {-16.93870340984862, -14.725405412420356}, {-39.808020625133864, -17.72890579045883}, {18.998751090009645, 7.556763260681459}, {26.68685457739199, -1.8912550154314005}, {-50.642456066394786, 6.130446124880718}, {7.9192690632475, -12.245061854948009}, {-27.001600203383152, -4.263254237180371}, {-9.241465386819314, 8.811711755715727}, {15.043385265122474, -17.06112608119824}, {-4.99210063545537, 21.28779503218026}, {22.35123358345853, -17.064399546700294}, {-20.908496824717826, -4.814186946847165}, {-43.71472192444613, -14.686120527765945}, {-28.20089506469381, -17.716648172382616}, {-42.050940144354165, -27.559368105259665}, {-24.710063448765496, 12.864038839634778}, {-22.65585185705238, 22.81046118627454}, {7.839778695139016, -11.654343725690719}, {6.134270770125523, 10.658537103233915}, {-14.623582158417774, -5.464881931124427}, {-12.654252998371575, 12.697368191759072}, {-35.70594054374437, 8.455700491356493}, {42.191187599020544, -16.551572756678112}, {-16.962420966288246, 23.627831472432117}, {-43.91962695490281, 22.268685532129926}, {-1.04726700193075, -16.797672090795547}, {-15.502040192660118, 24.3271108388053}, {-11.222688584634124, 2.2314842321251054}, {-26.203588328332167, 12.255925996780046}, {-44.24529133459088, -25.714895264762458}, {-47.918327922823195, -12.34439545376863}, {23.266132681105233, -15.439099306297827}, {-50.036787156766486, -17.61026541532254}, {5.533377513813381, -11.199545709385626}, {35.016667227326714, 14.830370521861555}, {44.62873020502903, -17.177882700156342}, {-3.5513974900690934, 22.486530625119048}, {-11.233231442865376, -23.96360990761467}, {45.39417686031312, 21.773912312022794}, {5.4670036056503, 9.487885887355112}, {24.454741525963875, -20.235866405787167}, {-5.460234990072881, -18.494680536412964}, {-39.178625261710934, -1.3890184937905619}, {47.73080481418772, -0.46177267515270426}, {-12.00447048515581, -10.829176403880131}, {-50.960571374813654, 4.914475184302721}, {-9.873688449536202, 15.179502705578003}, {-20.028708118545854, -6.010478390340704}, {27.08793008308154, 11.601548875977922}, {-31.753848466162548, 1.8206157662182014}, {-23.41781654341231, 20.842351507729983}, {-42.98550438716479, -19.577716779809194}, {0.8226371591643374, 10.333879794713308}, {37.422095823168235, -4.4213911898654565}, {-43.64187046963233, -25.542909492634866}, {44.87441803368864, 7.705528168418266}, {-18.049006126371285, 15.892281235252574}, {-21.10832533375455, 23.627134233839612}, {12.163145659008087, 12.865209081031011}, {-16.407583142322668, 9.099900903684938}, {46.22205524826436, -15.172016429877807}, {24.411629915561036, 0.7037575545868436}, {-35.80651664979788, 22.053599000854128}, {33.663366988316305, -26.623137725878948}, {6.434405424936133, 15.044163707327158}, {20.472424403076122, 19.940894589440642}, {38.36904172814686, -15.774023019177976}, {-36.97856978555114, 1.7873910390254877}, {-36.43251332611918, -4.4870609996969115}, {-2.8580139887095597, 14.999880296068207}, {-2.2691288288033378, -20.057983225950338}, {27.935954595704118, 8.800872172148512}, {-2.7597496443257863, 17.39775160100564}, {8.371879585458396, 9.272776042231307}, {31.551770680102525, -9.642356862357113}, {4.9237488012564405, -9.802065045107495}, {-16.47574833361979, 19.274362620063382}, {-13.53514182972717, -0.6143911304100036}, {-30.87096128489995, 10.294338425374024}, {18.40737817129325, -19.672894546376664}, {-50.497443885230616, -1.461387100379883}, {47.70893852251737, -13.201729678696207}, {29.27234801931552, -26.823100464429224}, {-40.653496914577616, 10.26565560784844}, {-1.769049869358153, 1.700985171018667}, {-23.687923063596113, 10.794659131395836}, {27.203727139076154, -25.303860188315017}, {-32.98674624410567, 19.15144187007433}, {-35.95324229209055, -8.311140454292207}, {-41.266598290882065, 13.098303810829355}, {-7.6705784642656365, 14.740698874820241}, {-1.0149401115026433, 14.092631056989148}, {-20.650395157750296, 22.5398895967419}, {-22.607582373224073, 18.907363280374064}, {34.34516807894221, 25.210348617634054}, {-8.417909905210758, 4.643662328532717}, {51.87550818828665, 24.742790213098296}, {-50.9887491426665, -17.80057314033422}, {-41.67219375586719, -19.116505509520834}, {2.049039887755917, -0.33189113097379774}, {20.398790259327853, -18.12082448348645}, {0.6592355410944339, 17.88483842905589}, {20.290166949345643, -21.16248743256123}, {20.530588731703773, -3.1166389586375285}, {53.15972314796833, 10.48000392166548}, {28.868401847841884, -8.05452741849664}, {52.035082510657475, 9.569777779841957}, {-33.63945303842243, -16.90031196623727}, {53.3151344568539, -18.2729978396083}, {28.251053271811774, -16.40184416474803}, {21.110241774506488, 7.492896370875313}, {44.530847605339865, -28.81831517204926}, {-39.86782018938878, -9.31250864060631}, {1.9463977668279997, -23.341177911576004}, {-47.039945871104536, 9.795233908700721}, {-2.4496429452167185, -5.8619192845828945}, {-48.55437620860342, 9.099911036047393}, {-2.415759418322288, -20.752647743073357}, {4.701697210845993, -10.895505584984273}, {-47.66074201360953, -2.363839104394526}, {40.247050579056385, 12.453015432708412}, {30.586737935446834, 18.597922707976544}, {-17.422846970672804, -17.836361575076552}, {-5.447624914122561, -16.86925759335037}, {4.134269792854391, 20.7329941954631}, {-12.336011299628842, -11.989167523888733}, {-46.272633438867025, 3.180969586276121}, {-37.858520106994455, 22.562224566601117}, {-37.5394447193661, 1.649852063555931}, {-18.36781513288295, -24.82952654028089}, {-28.70410368826996, -25.81970821286593}, {33.336266217482496, -11.711920877860159}, {-29.138441259788486, 14.50123185665543}, {-11.782128115500512, 1.532710099014838}, {-47.79613654493691, -1.4181044846093327}, {-29.63655563292047, 9.28269244564251}, {-12.702529120326133, 2.985672364089671}, {23.584217108064827, 11.442888973731694}, {-41.4011350600169, -1.5611830013189754}, {31.343178332876814, 10.217196716950898}, {18.16910118896834, 4.956319258486584}, {-36.21802354274372, 17.18764469205951}, {38.005984378832956, 20.544499163806556}, {-38.645715611496584, 17.145156164790656}, {-3.5566951640002644, 15.39151185393883}, {4.543993409975611, 0.9414301388547562}, {52.64845263721001, -15.157782661614903}, {40.6788176339496, 20.743867901187848}, {-22.06129643117674, -21.22815492192455}, {16.332480087572865, -19.224457440255456}, {42.81684490563189, 7.88569063626243}, {-0.2209638190343132, 16.689232606539726}, {43.417624863363244, 14.44314994684758}, {-35.1520873654231, 1.838038744131028}, {-47.471735005860566, -1.8852649524089917}, {19.990823132088877, -27.129260287763415}, {40.983507858232024, 11.545963745581293}, {-31.82398789652508, -17.884209325323592}, {-11.82731656451064, 4.908845988475729}, {43.22701311777904, -16.29182009674808}, {-37.82334129969595, 22.9146584375629}, {26.262053302159803, -22.721496594821772}, {26.709640890417077, 9.315086559512672}, {-3.006958097307696, 21.599228837018224}, {-40.85554474229158, -12.824822300624211}, {52.06187192225925, 21.143016040501983}, {-50.87778464738695, -17.718866223562966}, {-32.2983396942863, -19.321737811398904}, {-43.894693835398265, -23.62093916706369}, {-4.677957135063926, 3.8752075802149153}, {23.906800472646555, -16.81852723346489}, {20.83650570429372, -12.79187984116284}, {46.07231821753578, -11.008471445978781}, {-9.03052513081742, 4.6391381566347505}, {-42.53337743560626, 15.946845250484305}, {29.044998769928856, -2.8119021430232634}, {-23.61096531782781, 6.067193314330981}, {16.098916616331632, 0.794318180532147}, {45.86466323969278, 15.320657248546144}, {-20.256471112537483, 5.7630944419434895}, {-34.92403501417699, 23.15250456636419}, {-20.484066199255125, 7.216528377844835}, {-14.415310282634, 24.036674555212905}, {-14.723712307796623, -3.874171228964786}, {12.560626652143768, 8.934840751372024}, {35.28346714352993, -10.955700516331044}, {-0.65145975272988, -16.940752345204125}, {11.573762216143285, 0.41163547285868646}, {-12.6166658710275, 17.956770532338084}, {6.852264169681288, 1.8253901656367273}, {24.875435563074582, 12.114885580320227}, {-15.309950676734616, 24.256013229217864}, {-26.665441061948428, 15.269366210452938}, {16.615896479266468, 21.869939771844223}, {-22.543923605759993, -21.70395641764026}, {-8.066785723580017, -2.009062820537848}, {18.27540544507304, 22.879794420336513}, {0.6667822528834914, 23.024521386872}, {38.87709256817182, 11.753224147977686}, {38.00770787795046, -15.638789651313948}, {39.75102010480428, 20.65718193810682}, {-38.06181570653291, -14.428032448837529}, {-6.038835982569081, 15.698572493653895}, {-6.909018957849441, 10.900139448040505}, {-19.927821348685466, 24.63725352919461}, {10.791077328025636, -26.156798732560965}, {31.44874568018036, 10.352001977838748}, {-49.30187038016337, 9.10665242821047}, {-1.841668331413733, -8.445283960600294}, {-22.541006914743413, -27.21042954093661}, {-19.34451398317569, 13.066955318590601}, {35.959049097145424, -3.0414320472299647}, {-32.2224294122846, -5.817750097046924}, {-2.867453356552812, -8.805543777520752}, {-13.829703151770314, -12.54048191395319}, {44.94748747515244, -17.696810117701705}, {-10.29041822751276, 21.72759002160427}, {-12.607279418909325, 14.959866425284716}, {-31.21258240551197, -5.870514369613059}, {21.989282154724478, 21.912000769792414}, {41.5892908851763, 8.977771485239364}, {-22.27107093870508, 16.954035040478487}, {27.61865829210073, -25.19321573576878}, {-4.329074403974663, -21.62818392016926}, {46.249215455882364, -14.77235617422126}, {-44.71885353178344, -13.145693156636336}, {-29.2887595433902, 16.532772318378104}, {7.924526152950799, -22.13410295753928}, {-43.2221241135206, -14.185657403359809}, {11.770044275926399, -14.288461947261677}, {14.808069284321233, -1.5837714192852215}, {52.431052382694, -12.400350143196249}, {-15.46409879845976, -21.34646830438739}, {20.5964299993787, 19.54100942762209}, {38.282688715880056, 11.013573459349857}, {1.7859249639584196, -12.989646017382565}, {-28.56719392513409, 10.22218526394005}, {-42.5492531101024, -24.69055636938871}, {-10.299456869332332, 7.145994320808996}, {9.331938763423091, -25.894801165190376}, {-15.535914061091225, -19.000005474840517}, {19.22885994516544, -6.3795392313634105}, {-1.166764077353823, -17.032354780409435}, {6.441582169149168, -20.43604909814846}, {50.50510609934138, -11.453962206880375}, {-31.916693417936767, -23.282529649057395}, {12.724602508405372, -17.43097453947199}, {-16.793184523358985, 15.151510283117913}, {-47.157135701879014, 24.367878781684656}, {1.8563712190753467, -2.105002484778907}, {0.9531899881145844, 8.350828846704273}, {-19.758758946039066, 16.06841796252612}, {-9.836321784802696, -27.22265216391631}, {-19.827149085370046, -15.946778224772702}, {44.04153537341559, 12.36829999683508}, {11.189849941854751, 9.069192784393824}, {2.8192329799092786, -3.80259756146188}, {28.15403531359273, -4.019422772178101}, {26.563200714731583, -26.0488387674826}, {6.947534174526688, -10.730989795359068}, {43.108865380827886, 25.416125368134914}, {44.73598109638683, 9.776525744583159}, {41.67715396166458, 14.230109708413496}, {48.68105404409461, 23.24630797023601}, {-4.360795877583053, 15.538670044169384}, {16.721824283805297, -18.017320793031498}, {51.64684525723469, -28.720374360591727}, {36.17482971394496, -1.5171830724344741}, {0.43523551196595817, 15.931826301042047}, {-22.87834581851501, 13.94806655694937}, {-23.01669160950505, -15.890661612584456}, {-47.04379011311787, -16.413629758106044}, {-31.48980766531937, -17.30443840677233}, {-47.68729404644847, 23.301915120609408}, {-8.655399928056648, 2.064018753379212}, {-39.383000309792514, 9.651383537599473}, {-14.526729879736337, -21.510877824388007}, {15.701862568498642, 9.79718902502437}, {-47.71779838457166, 18.444512278908615}, {-7.628674927843585, 13.319600011307443}, {33.34159085292417, 9.442745728832747}, {-21.967075526450063, -24.348166592135396}, {-29.13487859192878, 10.301324262749205}, {26.243752904017427, -23.12249250983843}, {-16.860114107267737, 16.14694696141029}, {30.729449311135017, 23.42048368239511}, {-48.476448665849745, 2.9402720555246873}, {-36.996723937025955, 10.680927476254109}, {26.817007688377593, 9.206644687687097}, {-24.318607079643577, -7.631626926452952}, {2.2750402968642445, 7.7489349976556126}, {-37.41962418145579, 22.954579863410146}, {18.60964794550242, 24.480742087032585}, {28.42464786916379, -5.897492376492369}, {-7.02333543725647, 19.745900964209287}, {-12.788081713104466, 1.563470764887944}, {-37.319318475022115, -8.130181155093767}, {-39.15312844957737, -25.945887086398365}, {22.097203424418378, 9.635499576877082}, {34.03442243012167, -25.191452408966164}, {27.669001528821653, -24.833290399094736}, {15.915043770491362, -18.96638089946659}, {23.43932672606746, 10.441786089869808}, {22.702869845614053, 23.794572704940492}, {-23.01987091008702, 2.2233153727381803}, {41.19206360285346, -6.071808002638653}, {9.616667747281115, -23.43649854305818}, {-9.296787884510573, 6.238927895153696}, {10.060294665009412, -21.341473369605353}, {-40.32010139127554, -23.90423123596295}, {37.254999881008935, 18.788893557804137}, {-6.7495002973277565, 16.40618857073333}, {-20.64231492353158, -3.249239674162352}, {14.415575112722028, -13.947150969586403}, {39.66678877372628, -2.775821608300492}, {-3.8157679883474604, 20.934113561107363}, {-25.8790474108515, 0.22177351836431483}, {-16.169698241040834, -3.1261956421806265}, {-34.56876896845884, 21.46905859995279}, {12.527308497061977, -16.01698992246792}, {31.259134756186466, -26.157237509549674}, {5.878402477676795, 3.3088669601892846}, {5.389326960157324, 4.653485976570413}, {-17.120699539740432, 15.83163301185193}, {-39.8523657045686, -21.394301623297775}, {47.014318568949044, 15.871085829725292}, {38.0747863041012, -21.058384932167723}, {-3.7812413337558626, -13.711019241334045}, {15.386307762789162, 20.17012219920869}, {-14.019557080936249, -8.637632045467546}, {53.553878646789855, -13.643854639312186}, {9.664655457983697, -24.329545187012414}, {11.366971206161812, 20.92410950662752}, {11.807866966804156, -21.9564524487249}, {49.00410713192804, 23.422769539713375}, {23.10136258391741, 20.65039990156672}, {-43.21875789254314, 15.859479363391898}, {23.08366144009783, -24.90149113953384}, {-49.53998657696021, 9.780140357611634}, {22.080845697194587, -17.582085316342194}, {3.5269324013836263, -19.45174688881643}, {-17.465140031557365, -15.642738680219713}, {-50.005649608415126, -17.505654799549134}, {-47.40172866434767, 9.361537585907042}, {4.708386191312808, -5.622413986061869}, {38.001680515235115, -27.783600948982063}, {47.63827425647966, -11.701959221487884}, {36.316615799416205, -11.06163440841161}, {38.43017959135463, -23.01469746270866}, {26.466254768359466, 17.692242880620498}, {-14.58274562476362, -3.907594901387015}, {19.95200892723127, -3.3478362713006464}, {-22.729116649022945, 15.852694652015876}, {-46.66109271757214, -11.311656322443248}, {-23.798564588176163, 10.298372658431774}, {-17.594663804788144, 17.671003407595784}, {18.097855428766916, -25.14968600678959}, {26.465276154153933, -0.37255045611663296}, {21.451008231561847, 1.2185670467831742}, {-37.91951319524211, -20.6179079551506}, {-14.76288877996798, -6.057302000461208}, {10.5130071835286, 16.71051008706409}, {29.34348821326731, -25.559079792113504}, {-20.76708545062909, -14.502216897206063}, {-45.523685049647604, -27.94304234599421}, {-16.850750879420225, 8.663662850803904}, {-18.427590408708888, -12.322128390832606}, {-33.9596258784277, -17.846799384122814}, {-38.77780074844489, 11.505946997266415}, {0.3777643857360918, 6.663961539517571}, {-17.946502147667434, -14.329760437072308}, {17.715098362447453, 7.2529430327673}, {19.204430131872275, 7.958036634565202}, {-23.8384251673201, 12.549023797826822}, {37.03465361697696, -14.341362034076383}, {-46.07195929539512, -27.983605160114593}, {-1.2761707664665727, 5.71382522196298}, {7.671451236130896, 2.582866926661138}, {-25.020505751682702, 13.36795812587649}, {-44.34613023672753, 21.67142835162105}, {35.95471933521058, 6.35712463520887}, {-44.066974131739045, 8.268738262991414}, {11.201763038593983, 19.091583155432847}, {-23.232159978862793, 14.841831086594864}, {-2.2302581232127197, 5.720328730089321}, {13.555844251364231, 12.571609823841456}, {17.91820177100347, -21.05876405891609}, {4.609065362039199, -13.86025608915767}, {-4.15287198571704, 19.481174384739056}, {34.34728124026977, -2.22871062901384}, {27.18459307322247, 9.007184125526738}, {-32.91893039203093, -8.784644646197172}, {-16.313478457114535, -23.04005948779341}, {42.16318128317807, -10.53897410578756}, {48.02349982881325, -27.109183201455682}, {-11.98957470583003, -18.781033353810113}, {1.5506952681505841, -3.7601002731922315}, {-43.2804597808027, 5.654383661025858}, {-39.75118267003239, 17.37967989373147}, {-22.70113319070727, 8.910470337052015}, {-45.87737535054081, 8.014669831657637}, {-25.04651524011355, 2.6990417281595414}, {44.98175301236897, 21.594540556069198}, {-15.33586257677097, 3.7757705005330875}, {0.7533962190133885, -17.198431802055598}, {10.626451922396225, 19.33580211639682}, {-13.881953563680163, -27.301606756461254}, {-5.652726873866176, -18.912378580839984}, {0.0831028171112641, -26.36602695478846}, {39.604230985331384, -27.275317451012423}, {46.89719189155979, -29.557598053818197}, {-24.08209643471607, 24.965192899104213}, {-29.060109866224774, 7.813524987443568}, {-48.19787615338999, 3.6680054366004846}, {-19.668951502864832, 8.310654833329274}, {-47.136485283221404, 24.356900344466137}, {6.345441702265535, 4.663543027211454}, {47.10673713123117, 12.751913897786686}, {-25.09028943903887, -25.197138159577953}, {37.543939034229076, 12.997879090212843}, {26.25712850715273, -2.9991509222183788}, {35.039913639592044, 11.416494072614418}, {32.20281866737065, -26.26141229019307}, {-49.70668459724236, 2.820795636756397}, {-9.041342802686554, -18.093618071893466}, {29.003719562239844, 23.516659616859254}, {-35.570090398355894, -26.83399088595014}, {-43.38172957298885, -11.433264636358603}, {42.63160952568773, -0.6059522475691638}, {-48.882635266918676, -28.72587765272946}, {33.226078556641426, -11.488828720815073}, {26.95532304464869, -15.631637622695962}, {-3.3258586451542445, -4.172408643085799}, {52.707930222185986, 0.23184774999815128}, {20.501050971216905, 6.305117826710106}, {52.65991555094341, -17.108756821357094}, {19.65502196122523, -11.929636650194373}, {-36.79805298532223, 9.258917343226688}, {7.193022018755386, -2.100915513542003}, {29.395221944909558, 16.9539242780629}, {44.91240310099168, 17.092976025710694}, {20.490468976743937, 18.416131798593117}, {-44.86753396415618, -23.73458080125313}, {12.765358637483203, 0.7141057590401909}, {40.58915878153396, 5.148718365475938}, {-41.03131230377593, -13.739033832111005}, {40.445780183832746, 12.31845241591153}, {-21.651716750114602, -3.1471654255633}, {51.19788748652139, 16.865850703197637}, {36.47968001738857, -24.63303736155011}, {48.13823222058797, 22.982991734548243}, {10.00695778427691, 22.442814565816118}, {49.844590927348754, 13.338773456884665}, {-39.86093125030084, -20.50034370887291}, {48.524572807761636, -15.044511228471109}, {3.5887486393566466, 9.747897644805825}, {43.72732410556832, -25.775739463954928}, {-39.36600581356479, 6.847823195947786}, {42.70619151082612, 11.676635748050233}, {-1.3870359167761404, 16.984076226277008}, {-0.4912080406207236, 12.833663575349174}, {-50.80638276683397, -11.689827116127038}, {5.012797344397445, -5.992119101690163}, {1.3322815511371295, 1.2331620978554825}, {-21.325844334301628, -11.864431250715876}, {-14.65497407335394, 9.413915072209692}, {37.70879850975732, 19.279669671538947}, {-42.84641520213918, 20.670125826654928}, {-40.07111555875315, 16.38746472362629}, {-32.03478144627926, -16.8411073961981}, {30.2635468338541, -6.266874364495436}, {1.677981556503672, -18.713840718379313}, {6.321669174113728, -9.11678014292928}, {5.847169817513829, -6.537171207969373}, {3.070117422785402, 17.56813985805317}, {36.64928541818108, -12.223458728666014}, {-30.18716971073571, -26.343707841891568}, {-13.72446901627935, 4.433531754084428}, {26.05773005579819, 11.765079233445654}, {33.57745890406635, -6.865125800714069}, {2.854552334225888, 22.335163734590818}, {23.46759007109649, -21.507055077022777}, {-49.3061372029881, -0.2802253036795178}, {53.25526782146426, -7.633818341245074}, {-11.907057170487642, -10.513726725361643}, {5.578262252181341, 2.9717037527044114}, {-48.08991805580076, 21.53788390067837}, {11.744189321390653, -14.717923066995203}, {42.33141194890039, 26.16284427330562}, {49.527813218755725, 5.93821545551251}, {-2.131592019055932, 22.5217823822221}, {-32.6599593722962, 8.22511502636578}, {39.18666584719401, -9.15558698124369}, {49.12833960460757, 15.119618356239277}, {30.65550242532323, 8.19149774314345}, {-46.10987936627679, 5.108499741570307}, {41.76799221706992, 16.345210605274996}, {17.282020657259963, 22.09854434194437}, {-48.07548389292602, 24.03089966362328}, {-16.579350618957005, 15.397297007324468}, {7.784081740714321, -17.802184087702226}, {-44.59970166223655, 9.198157701825188}, {47.81728600376053, 5.298359081677588}, {-32.260978199218584, -24.562203577803334}, {21.31403997436239, -20.57117338249278}, {-50.747661337854616, -10.019017059086979}, {-48.39788545255338, -2.4785782589855323}, {33.98748414469049, -10.31763679059019}, {-22.745565960295274, 12.287019163699528}, {3.6671700904231517, -11.681417928253197}, {32.37870005349958, 13.00366455710903}, {44.85776949492832, -11.283863200747327}, {23.15423335373691, 0.9711192851666955}, {16.618416756089218, -2.452975833648211}, {5.861710525289443, 16.272942915418824}, {-6.4540797454693255, -3.5245253584067013}, {-1.651733766705957, -16.84678292867011}, {-3.9211276444528234, -26.317545232200224}, {-42.41998984655136, 7.422809018525573}, {-33.04449152416707, -3.7151220523811004}, {19.64257195870504, 6.562802043085518}, {48.22835798650606, -0.9701369571655173}, {-32.34564914227529, 21.180785140888357}, {-0.4108020441523171, -25.385272703349298}, {27.08100306693427, 8.803333290334722}, {21.25770904595205, -18.054895492517268}, {0.4887020647667087, -15.192431559158978}, {20.10891016308101, -5.021472571665896}, {-45.11225833671647, -16.57140099129798}, {-2.6040899998660594, 9.785138835512672}, {51.842245593084314, 16.89038010103892}, {37.95896632816514, -11.947617414273159}, {-10.856572738079201, 3.801853911757463}, {-50.707607251940274, -23.8224662254163}, {1.2722606556455889, -1.5660725774619157}, {22.65404121889492, 20.935471315618354}, {24.063401742765386, -16.068119602035747}, {-26.366486416550067, -22.88917929860636}, {26.653733983994638, -4.996700392998774}, {-40.675712953930315, 10.732923967435886}, {-35.611982203862524, -17.225024565701972}, {-45.60164584743989, 22.408364405465743}, {-37.66527031861503, 1.7143789897345916}, {34.994352593137336, 25.76499754697832}, {37.60346796052503, -15.617450134827534}, {-10.94302589536472, 21.136186518488625}, {47.939665196519144, -27.04292694522299}, {-45.06643134832336, 7.522592144501475}, {-24.5724433181572, 1.2128483800824854}, {11.85851407052793, 18.985208486967394}, {48.078932948590676, -12.338504585562665}, {-14.021635927487377, 16.04119962465017}, {-33.20964794455088, -3.3657381898867}, {37.25682675055132, 21.977080859580546}, {-12.277437610637921, 9.5739040396528}, {3.780517403533897, 18.935655725787953}, {24.4238093382973, -20.976258908514914}, {-24.55920517691906, -18.686352649367286}, {-9.933975767223847, 3.5046408222288794}, {27.511072692598106, 16.60733133411502}, {1.2280547592417537, 18.84355646015027}, {-16.50920661865645, -4.776722517766028}, {-35.08123002838036, 20.344545975575524}, {-37.98084090059804, 0.3953341424897924}, {40.31135216727194, 23.427920016149084}, {-6.742348881079703, 19.14569275884433}, {4.633862813141563, 7.0971438247810905}, {-36.15747260271421, 1.8751499906271052}, {33.91270262121842, 8.494913648927048}, {-44.793876770960274, 21.898058772675963}, {13.558608350275236, -14.126257408188042}, {19.521983780904257, -4.700745481594}, {-36.41064538867792, -28.2874006894416}, {-49.58434663927959, -6.285469028203754}, {48.42511504315153, 22.98991629472016}, {-25.47136090441358, -6.266027630746923}, {30.855126702859867, -2.2016654114247665}, {-36.545016835600954, 22.774237746618834}, {-36.54797799405855, 17.668073481934275}, {50.923153614763926, 22.620635460241523}, {-0.08780512516157471, -10.255402737133528}, {50.608890896787486, -28.250611473608718}, {-12.073743234297641, 1.8166028194117703}, {-41.11341879533759, 18.602570208781547}, {-21.11738090812157, 5.597431393331972}, {-31.84672892611692, -4.04421292480212}, {39.97239618975572, -25.152083143636332}, {-47.76165784086185, 18.468748288361105}, {-25.242474082483646, 15.048609172177018}, {-25.408806203626526, 12.669940093815883}, {40.399949311385036, 16.822163130492818}, {-37.144513610432746, 1.4767417453071185}, {-18.212246725970466, -11.426217022146615}, {24.53969257734567, -15.993902738858532}, {-8.84370523462621, 1.8984362303217635}, {-21.809292390146116, -14.614727263938335}, {-7.587478036194606, 14.787458256004467}, {-44.37827081472336, 4.343324213236567}, {8.500681201972567, -14.407402218575559}, {15.575269603055476, 8.792386601270293}, {31.780336496379427, 10.343900794817035}, {-46.78794505608035, -16.169955468503897}, {-22.789069944619495, -26.234257339749814}, {18.647735500215777, 7.974578792689393}, {36.809975128173235, -12.268177125657134}, {-27.249589264904746, 19.34338091109677}, {3.3550074974276787, 7.755564511263099}, {-42.24221426586305, 17.88284892163531}, {19.93862109047502, -22.24178097462654}, {22.197946825886405, -4.401477279473152}, {20.716559379470535, -24.5154419826065}, {34.46223734329262, 16.721967517030183}, {35.24818044890102, 5.257221789403698}, {18.97266619367579, -8.584664179048511}, {9.646743606168906, -16.019970465625356}, {-12.422452501228424, -16.83907358458887}, {7.566178120793287, -24.566677099501383}, {45.07060580119071, -18.85591863933373}, {-24.198329450975912, 6.347953012522611}, {-19.229398400393258, 22.929241235064644}, {-25.18379154579731, -17.096237646817634}, {-38.82348385543332, -15.185881690185026}, {14.27161516933978, -25.042688463803472}, {19.46726644422708, 20.44704870462964}, {18.585500806519793, 1.346895069842919}, {-36.34001194413011, 18.07490683802618}, {12.390198798395758, -16.9632048047136}, {49.77130989108528, 23.85536483279054}, {-24.177034429763953, 3.4262364089403285}, {53.10004125442175, -27.051757421644417}, {-43.3970577883082, -26.53151979643488}, {34.53524330531102, -13.681198325706239}, {-19.678883857528476, 4.516765396208811}, {1.47331678410772, -24.42332681503442}, {15.409623352723871, 19.20817179693683}, {-13.721902996447417, -13.939546484138065}, {-19.608476121545085, 13.04681624480798}, {40.65245960012711, 12.791457027110127}, {42.432382376798365, 12.75048580952225}, {-17.483441490254837, 20.474363721246995}, {9.186513063907299, 9.01177543911474}, {-32.05879894924426, 16.282485078788778}, {-46.205102307965056, 9.235717817957013}, {-44.03263047477206, 21.41795940864601}, {-45.1415006042117, 7.479596963926001}, {-1.7753593456311794, -12.447547223576539}, {41.51141532368771, -2.323283699619351}, {-9.73010591113874, 8.887779327810225}, {11.3110867709026, 23.01151478897204}, {27.90195088719976, -2.953418802113269}, {2.551552411319471, -1.6674512389063565}, {-23.74665887746639, -27.022937954412537}, {-19.613164671628226, -3.086466457405699}, {-21.51899150025469, 3.9270943035224994}, {-24.37701766846041, -25.485126783161757}, {-0.7328540771222455, -3.785002164929668}, {-10.83316548654201, -26.44888733042434}, {-33.64766597193213, -5.301309876491775}, {27.421790469936777, 24.12803753281017}, {49.97364482060747, -14.554964696098878}, {22.5468685161852, 10.024173974676954}, {48.80942103216511, -14.200570219975676}, {-8.495303096085228, 11.627653899956455}, {-3.233408727199219, -17.291373972942097}, {-48.2546926067012, -24.962538253920815}, {-49.41177401111285, 4.6747369061284765}, {-42.70859421534325, 21.896118971316284}, {4.978996847535315, 17.35027734699366}, {42.28054636023762, -16.719330475693166}, {44.99271527763372, 8.078984827572212}, {-33.236978787956964, -10.798682264781439}, {-17.89343626503712, -14.38638750545216}, {-46.80414714018874, 9.74940713733522}, {5.666657706097589, -5.362994190497457}, {-29.76653894722559, 19.9056840087988}, {-49.22107564491773, -28.262987470909817}, {37.317357854669936, 21.535953846248987}, {42.13863784430017, 7.864849706620668}, {-23.923364629434527, 12.014510312079839}, {-30.311602034948258, -3.5340451332052676}, {-29.051685241579317, -3.6264164807222854}, {51.18541171679962, 14.346397897202975}, {39.0327641351526, 6.009342239285544}, {-22.992736800752105, 11.943837324540315}, {27.40456305439565, -3.1597727277423457}, {24.23789595247708, 8.456429298024402}, {19.032538155253885, -20.14016116212807}, {-33.15036916309447, -9.804494865479391}, {9.013911619829347, 9.457406177150263}, {3.8194781919686327, 0.021074192265534378}, {30.189086412317966, 17.103576019546846}, {-16.32294904256498, 15.457075293591725}, {-0.13370397590440752, -7.2826103224305445}, {3.425044966308034, -18.247172614665967}, {-6.889719674793027, -19.943755020209476}, {1.1430308136464258, 9.230338180743447}, {-32.765968991948725, -17.221146662195927}, {40.366670023739644, -11.168605869607461}, {53.92008074595084, -2.075390719742952}, {-42.78461621687269, -1.3995941128498934}, {0.05454260106831583, 6.9604629328805245}, {23.5552113719199, -14.742446114458891}, {24.79460886605042, 12.661853600695975}, {4.291124446009174, -27.822802918773608}, {-15.449817465215846, -20.92895136019591}, {52.87684415743428, -4.46841322006742}, {33.288662602810255, -6.136425177693401}, {31.430757616820838, 9.8727100848315}, {-5.190340794745483, -14.006359880539375}, {-27.252732934665215, 0.27636493027880826}, {6.813962062475863, -8.957949952248315}, {-6.986009586609466, 24.41344559229704}, {5.458119531885648, -12.601631299286387}, {33.60117694423266, -1.8284662691402993}, {30.858206987089332, 17.63383721258652}, {32.19122038171333, -7.874350757415607}, {-18.043392283681353, 24.394590806308678}, {-0.6014422679922937, -28.83083500760878}, {-34.29725946005675, -28.01942019910263}, {-17.378399713803006, 21.092882728162174}, {-36.69331375468116, 8.407400077548486}, {-11.435271740382058, -12.822195756806073}, {31.099874575772123, -6.634913585411993}, {31.558736573691213, 13.862699550171323}, {35.6005121162416, 1.5986785338883795}, {-7.133971121143046, 13.813654401622605}, {-23.003296255135307, 7.384325855505672}, {4.964173866822968, -19.002251451719182}, {40.77351063768202, 21.468583216534576}, {31.711883598546734, -14.384777433025741}, {32.964354401272374, 18.554864536182297}, {23.715972534194986, 24.001573461583995}, {46.36170172283813, 15.969060970658473}, {-17.124270953024226, 8.069334897183195}, {-32.934025594777815, -21.37125077223667}, {-40.73608975451322, 17.353457276143516}, {1.6725753721968026, -18.895026511105943}, {-0.01713326852250284, 5.168770224244627}, {-33.104370986352706, -8.021428786103774}, {-36.031337502335525, 22.551509842494667}, {17.829471763847803, 20.387846196592744}, {-6.3756779236768635, -4.7289441582321174}, {27.24334771020317, -5.025751964188048}, {3.565590366688051, -11.737951820523387}, {1.8906287602894416, 17.471139124714398}, {-25.970493881678415, 4.839725445313183}, {29.586622571260893, -2.8088740897152014}, {-50.25393154586277, 9.155782692658525}, {-50.77856311455915, -17.09524965328559}, {47.11095782507494, 13.813757678417355}, {-1.2296062055574137, -4.108051677247456}, {35.38703492748348, 5.236103088693258}, {34.89739266397507, 4.689791921222212}, {41.05504461484416, -5.980682880251799}, {10.63032305691868, 9.74788405537489}, {17.137212494012118, -19.521762868330242}, {-22.14835908836482, 22.920107408471054}, {19.90497729595053, 3.975700094842286}, {11.281464630480299, -0.537588111976078}, {26.83636464286134, 16.27104773621938}, {-38.71360667887754, 11.578727168004646}, {-10.303457738146003, -11.707329356230979}, {50.67506222527207, -13.920733761043174}, {18.860490054765428, -0.7593423345476894}, {53.74529662599051, -18.764574753391912}, {-18.836676622115903, 4.573043363931783}, {18.431193914605004, 7.1669294468273}, {14.347648862758248, -25.74142511499163}, {-18.719637787115797, -19.53180944676528}, {-48.92961835206316, 3.0210300252151288}, {11.21783921303188, -19.26015769843293}, {-47.77742492915133, -2.617776658004009}, {-16.825054148246895, -8.21716402424273}, {41.28041360066787, 9.642157696937996}, {-32.77066457995543, 18.89536436504735}, {1.7033594950881592, -4.754332180948728}, {-29.043459639441842, 3.104981899140624}, {-26.45297010375397, 14.914010591468017}, {52.52519562815234, 6.115421361587703}, {-51.32684895655474, -18.94650530991972}, {41.12352531385446, 6.1370740153375225}, {33.49060546416027, 17.4198484104269}, {41.6271954020113, 11.423802536135412}, {6.481158420649897, 8.321436725927914}, {30.80634991051433, 9.67940876891808}, {-47.534510392685426, 9.035295151408695}, {-41.51019417749128, -1.4849781295309268}, {-8.424827944259713, 18.246015999606968}, {-16.28157874783635, -10.89411963051023}, {-37.62825328131651, 15.562305387648754}, {43.671626156924745, 17.616425348461597}, {20.19283096798235, 3.019873291722502}, {14.890976279936412, -18.414120228967004}, {40.65543474555834, 14.297289210977636}, {-47.83229971233774, -27.585186470422357}, {52.53500306571795, -0.3445358741679674}, {-11.491797597565318, 4.414319475225657}, {3.6912626818673284, 9.739555822426672}, {-13.539818841467833, -13.312301609619073}, {51.22585543045499, 16.880177461896775}, {-30.89616733925165, 11.118833087698285}, {38.48168889433199, 24.32875269965915}, {-22.96041136067565, -0.8087840657864067}, {-3.28405908983401, -23.989783541862813}, {-42.36663035231671, -10.341019595078205}, {-41.28469531713141, 9.484247074942289}, {-20.23323033909822, -19.73830151812917}, {35.283412896462494, 26.29449456259761}, {18.68914535939756, 1.7111051148438712}, {46.92561779858235, -27.739421950733437}, {26.207399983800403, 11.813152393274194}, {10.747975460560184, 12.293968530933542}, {-10.5527180799277, 15.112828264910211}, {-16.78808850597425, -18.710299219512255}, {-32.31155768241921, 1.5387740521273825}, {15.99177274820524, 21.972686614036306}, {-17.158602910310396, -21.581102756925436}, {17.580134883797417, 23.234424871995405}, {30.53558524237524, 24.244014336915225}, {-44.984514831986566, -1.2859031412184776}, {-9.37015205031415, -10.40961925771818}, {22.174188992508384, -13.614182610417663}, {-40.079989102278375, 22.014035581166883}, {-39.272187931300024, 2.0876721803148603}, {-29.64005228170325, 9.597655386159438}, {7.937745738207757, 20.33560518234792}, {-1.6951189524267976, 1.968848427180447}, {29.948459966601334, 12.62552107381421}, {10.2412378624845, 1.3463768057109697}, {-50.85596777095764, -4.967478214734644}, {-27.770702333996894, -1.15612257562035}, {36.46139685169099, -27.641947301168965}, {-16.25936681853777, 4.422413074099256}, {-0.9466109827164658, -14.171455983409032}, {34.777069207590756, 8.059530569168318}, {-8.908705233801657, -21.798834459044055}, {-30.0687615300329, -22.463980256990045}, {-10.287930931778089, 6.777037020525373}, {37.08626102322896, 11.773903477691029}, {-20.898390597241757, -15.019708906612143}, {-14.134447020085839, 1.6373563547105727}, {-43.399807042194446, 16.18113560254184}, {18.47752408385547, -11.458322544218593}, {-5.294674690492737, 20.89102894473524}, {-26.453467758052447, -7.736622338058669}, {11.952395951495413, 18.86629084444103}, {-44.55176559153812, 21.745965091479516}, {-33.39571231431062, 8.667926839903497}, {-22.03015604826375, 18.527348018885824}, {18.204686287308142, -20.711329591734824}, {9.554273590155672, 18.230891028891392}, {-15.74588731366952, 4.191008556537747}, {43.00745875757243, -28.90920415729842}, {44.968915463194044, 22.669267960455034}, {49.624942615462544, -16.255514892173352}, {-1.258670171640925, 23.15495044834062}, {24.19077541478599, -18.108182917167507}, {-35.845152673288744, 17.149043253823727}, {36.87523570075281, 15.680962638158299}, {-13.871734122229556, 23.25905045589431}, {38.63526325220532, -20.38279683064597}, {41.67969636620198, -16.731665234207153}, {28.011181330802327, 24.033195280887416}, {-24.37691234397082, -5.06145402381333}, {9.940110922182397, -14.243273514476742}, {-40.663993259835344, 10.541144176315086}, {-44.915894830562934, 21.97536227506992}, {14.138453430652808, -26.064634713769877}, {7.716157642889978, -27.514810108704165}, {-20.283767736240087, -15.000814697272027}, {-28.060165040013093, -6.291528127195763}, {18.703768213196135, 8.012338169599229}, {47.213759352551065, -15.44937898521078}, {39.35657454091984, -24.950370440244093}, {-38.68334989828978, -21.134947788648887}, {45.849014899752326, -0.5580239447410285}, {-44.532942986035955, 2.4508959509398975}, {-31.372346874356268, -4.095207795184656}, {-43.09421927511634, -1.0839445716138216}, {-5.5775024657823185, -12.334490401782475}, {18.106349068479727, -3.5002087169598615}, {-36.41034693808863, 22.09684897079067}, {-3.6839512178892497, 23.712797774030793}, {-23.1793745088895, -16.174757885949912}, {16.80918903094816, -26.253774778757464}, {0.07492137819808295, -26.243140953392885}, {0.34959215506760793, 21.869107489615377}, {-13.352264643789976, -12.870229108511426}, {41.61783973737676, 2.4871856907149494}, {48.96336260400751, 11.111728805378718}, {-9.240978965338105, -20.330689664464327}, {-26.553967067865226, -17.809168185600566}, {48.55222793362178, -20.44857359581157}};
        double[][] dat = (double[][])this.swissroll.toArray((E[])new double[this.swissroll.size()][]);
        double[][] data = new double[1000][];
        System.arraycopy(dat, 0, data, 0, data.length);
        IsoMap isomap = new IsoMap(data, 2, 7, false);
        double[][] coords = isomap.getCoordinates();
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[0].length; ++j) {
                Assert.assertEquals(Math.abs(points[i][j]), Math.abs(coords[i][j]), 1.0E-4);
            }
        }
    }
}

