/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation.variogram;

import smile.interpolation.variogram.Variogram;

public class ExponentialVariogram
implements Variogram {
    private double a;
    private double b;
    private double c;

    public ExponentialVariogram(double a, double b) {
        this(a, b, 0.0);
    }

    public ExponentialVariogram(double a, double b, double c) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("Invalid parameter a = " + a);
        }
        if (b <= 0.0) {
            throw new IllegalArgumentException("Invalid parameter b = " + b);
        }
        if (c < 0.0) {
            throw new IllegalArgumentException("Invalid parameter c = " + c);
        }
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public double f(double r) {
        return this.c + this.b * (1.0 - Math.exp(-3.0 * r / this.a));
    }

    public String toString() {
        return String.format("Exponential Variogram (range = %.4f, sill = %.4f, nugget effect = %.4f)", this.a, this.b, this.c);
    }
}

