/*
 * Decompiled with CFR 0.152.
 */
package smile.imputation;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.imputation.AverageImputation;
import smile.imputation.KMeansImputation;
import smile.imputation.KNNImputation;
import smile.imputation.LLSImputation;
import smile.imputation.MissingValueImputation;
import smile.imputation.SVDImputation;
import smile.math.Math;

public class MissingValueImputationTest {
    ArffParser arffParser = new ArffParser();
    DelimitedTextParser csvParser = new DelimitedTextParser();
    AttributeDataset movement;
    AttributeDataset control;
    AttributeDataset segment;
    AttributeDataset iris;
    AttributeDataset soybean;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
        try {
            this.arffParser.setResponseIndex(4);
            this.iris = this.arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            this.arffParser.setResponseIndex(35);
            this.soybean = this.arffParser.parse(IOUtils.getTestDataFile("weka/soybean.arff"));
            this.arffParser.setResponseIndex(19);
            this.segment = this.arffParser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            this.csvParser.setDelimiter(",");
            this.movement = this.csvParser.parse("Movement", IOUtils.getTestDataFile("uci/movement_libras.data"));
            this.csvParser.setDelimiter(" +");
            this.control = this.csvParser.parse("Control", IOUtils.getTestDataFile("uci/synthetic_control.data"));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @After
    public void tearDown() {
    }

    private double impute(AttributeDataset dataset, MissingValueImputation imputation, double rate) throws Exception {
        int n = 0;
        double[][] data = (double[][])dataset.toArray((E[])new double[dataset.size()][]);
        double[][] dat = new double[data.length][data[0].length];
        for (int i = 0; i < dat.length; ++i) {
            for (int j = 0; j < dat[i].length; ++j) {
                if (Math.random() < rate) {
                    ++n;
                    dat[i][j] = Double.NaN;
                    continue;
                }
                dat[i][j] = data[i][j];
            }
        }
        imputation.impute(dat);
        double rmse = 0.0;
        for (int i = 0; i < dat.length; ++i) {
            for (int j = 0; j < dat[i].length; ++j) {
                double d = data[i][j] - dat[i][j];
                rmse += d * d;
            }
        }
        rmse = Math.sqrt(rmse / (double)n);
        return rmse;
    }

    void impute(AttributeDataset data) throws Exception {
        int p = data.attributes().length;
        System.out.println("----------- " + data.getName() + " ----------------");
        System.out.println("----------- " + data.size() + " x " + p + " ----------------");
        System.out.println("MeanImputation");
        MissingValueImputation instance = new AverageImputation();
        System.out.println("RMSE of 1% missing values = " + this.impute(data, instance, 0.01));
        System.out.println("RMSE of 5% missing values = " + this.impute(data, instance, 0.05));
        System.out.println("RMSE of 10% missing values = " + this.impute(data, instance, 0.1));
        System.out.println("RMSE of 15% missing values = " + this.impute(data, instance, 0.15));
        System.out.println("RMSE of 20% missing values = " + this.impute(data, instance, 0.2));
        System.out.println("RMSE of 25% missing values = " + this.impute(data, instance, 0.25));
        System.out.println("KMeansImputation");
        instance = new KMeansImputation(10, 5);
        System.out.println("RMSE of 1% missing values = " + this.impute(data, instance, 0.01));
        System.out.println("RMSE of 5% missing values = " + this.impute(data, instance, 0.05));
        System.out.println("RMSE of 10% missing values = " + this.impute(data, instance, 0.1));
        System.out.println("RMSE of 15% missing values = " + this.impute(data, instance, 0.15));
        System.out.println("RMSE of 20% missing values = " + this.impute(data, instance, 0.2));
        System.out.println("RMSE of 25% missing values = " + this.impute(data, instance, 0.25));
        System.out.println("KNNImputation");
        instance = new KNNImputation(10);
        System.out.println("RMSE of 1% missing values = " + this.impute(data, instance, 0.01));
        System.out.println("RMSE of 5% missing values = " + this.impute(data, instance, 0.05));
        System.out.println("RMSE of 10% missing values = " + this.impute(data, instance, 0.1));
        System.out.println("RMSE of 15% missing values = " + this.impute(data, instance, 0.15));
        System.out.println("RMSE of 20% missing values = " + this.impute(data, instance, 0.2));
        System.out.println("RMSE of 25% missing values = " + this.impute(data, instance, 0.25));
        if (p > 15) {
            System.out.println("SVDImputation");
            instance = new SVDImputation(p / 5);
            System.out.println("RMSE of 1% missing values = " + this.impute(data, instance, 0.01));
            System.out.println("RMSE of 5% missing values = " + this.impute(data, instance, 0.05));
            System.out.println("RMSE of 10% missing values = " + this.impute(data, instance, 0.1));
        }
        if (p > 15) {
            System.out.println("LLSImputation");
            instance = new LLSImputation(10);
            System.out.println("RMSE of 1% missing values = " + this.impute(data, instance, 0.01));
            System.out.println("RMSE of 5% missing values = " + this.impute(data, instance, 0.05));
            System.out.println("RMSE of 10% missing values = " + this.impute(data, instance, 0.1));
            System.out.println("RMSE of 15% missing values = " + this.impute(data, instance, 0.15));
            System.out.println("RMSE of 20% missing values = " + this.impute(data, instance, 0.2));
            System.out.println("RMSE of 25% missing values = " + this.impute(data, instance, 0.25));
        }
    }

    @Test
    public void testImpute() throws Exception {
        this.impute(this.segment);
        this.impute(this.movement);
        this.impute(this.control);
    }
}

