/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.LDA;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.feature.SumSquaresRatio;
import smile.sort.QuickSort;
import smile.validation.Accuracy;

public class SumSquaresRatioTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testRank() {
        System.out.println("rank");
        try {
            ArffParser arffParser = new ArffParser();
            arffParser.setResponseIndex(4);
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            SumSquaresRatio ssr = new SumSquaresRatio();
            double[] ratio = ssr.rank(x, y);
            Assert.assertEquals(4L, ratio.length);
            Assert.assertEquals(1.6226463, ratio[0], 1.0E-7);
            Assert.assertEquals(0.6444144, ratio[1], 1.0E-7);
            Assert.assertEquals(16.0412833, ratio[2], 1.0E-7);
            Assert.assertEquals(13.0520327, ratio[3], 1.0E-7);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testLearn() {
        System.out.println("USPS");
        try {
            DelimitedTextParser parser = new DelimitedTextParser();
            parser.setResponseIndex(new NominalAttribute("class"), 0);
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            SumSquaresRatio ssr = new SumSquaresRatio();
            double[] score = ssr.rank(x, y);
            int[] index = QuickSort.sort(score);
            int p = 135;
            int n = x.length;
            double[][] xx = new double[n][p];
            for (int j = 0; j < p; ++j) {
                for (int i = 0; i < n; ++i) {
                    xx[i][j] = x[i][index[255 - j]];
                }
            }
            int testn = testx.length;
            double[][] testxx = new double[testn][p];
            for (int j = 0; j < p; ++j) {
                for (int i = 0; i < testn; ++i) {
                    testxx[i][j] = testx[i][index[255 - j]];
                }
            }
            LDA lda = new LDA(xx, y);
            int[] prediction = new int[testn];
            for (int i = 0; i < testn; ++i) {
                prediction[i] = lda.predict(testxx[i]);
            }
            double accuracy = new Accuracy().measure(testy, prediction);
            System.out.format("SSR %.2f%%%n", 100.0 * accuracy);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

